/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.configurablelayout;

import java.awt.Dimension;

public enum ScaleType {
    SCALE,
    SCALE_X,
    SCALE_Y;


    public static ScaleType valueOfSecure(String name) {
        try {
            return ScaleType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private int calcPercentSize(double elementSize, double areaSize) {
        return (int)(100.0 * (areaSize / elementSize));
    }

    public int getPercentSize(Dimension elementSize, Dimension areaSize) {
        int percentSize = 100;
        if (elementSize == null || areaSize == null) {
            return percentSize;
        }
        switch (this) {
            case SCALE: {
                percentSize = Math.min(this.calcPercentSize(elementSize.getWidth(), areaSize.getWidth()), this.calcPercentSize(elementSize.getHeight(), areaSize.getHeight()));
                break;
            }
            case SCALE_X: {
                percentSize = this.calcPercentSize(elementSize.getWidth(), areaSize.getWidth());
                break;
            }
            case SCALE_Y: {
                percentSize = this.calcPercentSize(elementSize.getHeight(), areaSize.getHeight());
            }
        }
        return percentSize;
    }
}

