/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.configurablelayout.layoutelement;

import hgb.lib.HGBaseTools;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;

public class AreaLayout
extends LayoutElement {
    private String name;
    private String width;
    private String height;
    private String marginTop;
    private String marginBottom;
    private String marginLeft;
    private String marginRight;
    private boolean hidden;

    public AreaLayout(String name, String xPos, String yPos, String width, String height, String marginTop, String marginBottom, String marginLeft, String marginRight, boolean hidden) {
        super(xPos, yPos);
        this.setName(name);
        this.setWidth(width);
        this.setHeight(height);
        this.setMarginTop(marginTop);
        this.setMarginBottom(marginBottom);
        this.setMarginLeft(marginLeft);
        this.setMarginRight(marginRight);
        this.setHidden(hidden);
    }

    @Override
    public String getElementKey() {
        return this.getName();
    }

    private void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    private void setWidth(String width) {
        this.width = width;
    }

    public int getWidth(IntSupplier gamePanelWidthSupplier) {
        if (this.width.contains(PERCENT_SIGN)) {
            if (gamePanelWidthSupplier != null) {
                return this.calcProportionalValue(this.width, gamePanelWidthSupplier.getAsInt());
            }
            return 0;
        }
        return HGBaseTools.toInt(this.width);
    }

    public int getInnerWidth(IntSupplier gamePanelWidthSupplier) {
        return this.getWidth(gamePanelWidthSupplier) - this.getMarginLeft(gamePanelWidthSupplier) - this.getMarginRight(gamePanelWidthSupplier);
    }

    private void setHeight(String height) {
        this.height = height;
    }

    public int getHeight(IntSupplier gamePanelHeightSupplier) {
        if (this.height.contains(PERCENT_SIGN)) {
            if (gamePanelHeightSupplier != null) {
                return this.calcProportionalValue(this.height, gamePanelHeightSupplier.getAsInt());
            }
            return 0;
        }
        return HGBaseTools.toInt(this.height);
    }

    public int getInnerHeight(IntSupplier gamePanelHeightSupplier) {
        return this.getHeight(gamePanelHeightSupplier) - this.getMarginTop(gamePanelHeightSupplier) - this.getMarginBottom(gamePanelHeightSupplier);
    }

    public Dimension getSize(Supplier<Dimension> gamePanelSizeSupplier) {
        return new Dimension(this.getWidth(() -> ((Dimension)supplier.get()).width), this.getHeight(() -> ((Dimension)supplier.get()).height));
    }

    public Dimension getInnerSize(Supplier<Dimension> gamePanelSizeSupplier) {
        return new Dimension(this.getInnerWidth(() -> ((Dimension)supplier.get()).width), this.getInnerHeight(() -> ((Dimension)supplier.get()).height));
    }

    private void setMarginTop(String marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginTop(IntSupplier gamePanelHeightSupplier) {
        if (this.marginTop.contains(PERCENT_SIGN)) {
            return this.calcProportionalValue(this.marginTop, this.getHeight(gamePanelHeightSupplier));
        }
        return HGBaseTools.toInt(this.marginTop, 0);
    }

    private void setMarginBottom(String marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginBottom(IntSupplier gamePanelHeightSupplier) {
        if (this.marginBottom.contains(PERCENT_SIGN)) {
            return this.calcProportionalValue(this.marginBottom, this.getHeight(gamePanelHeightSupplier));
        }
        return HGBaseTools.toInt(this.marginBottom, 0);
    }

    private void setMarginLeft(String marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginLeft(IntSupplier gamePanelWidthSupplier) {
        if (this.marginLeft.contains(PERCENT_SIGN)) {
            return this.calcProportionalValue(this.marginLeft, this.getWidth(gamePanelWidthSupplier));
        }
        return HGBaseTools.toInt(this.marginLeft, 0);
    }

    private void setMarginRight(String marginRight) {
        this.marginRight = marginRight;
    }

    public int getMarginRight(IntSupplier gamePanelWidthSupplier) {
        if (this.marginRight.contains(PERCENT_SIGN)) {
            return this.calcProportionalValue(this.marginRight, this.getWidth(gamePanelWidthSupplier));
        }
        return HGBaseTools.toInt(this.marginRight, 0);
    }

    public Insets getMargin(Supplier<Dimension> gamePanelSizeSupplier) {
        return new Insets(this.getMarginTop(() -> ((Dimension)supplier.get()).height), this.getMarginLeft(() -> ((Dimension)supplier.get()).width), this.getMarginBottom(() -> ((Dimension)supplier.get()).height), this.getMarginRight(() -> ((Dimension)supplier.get()).width));
    }

    private void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isHidden() {
        return this.hidden;
    }
}

