/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.configurablelayout.layoutelement;

import hgb.lib.HGBaseTools;
import java.util.function.IntSupplier;
import tjger.gui.completed.configurablelayout.HorizontalAlignment;
import tjger.gui.completed.configurablelayout.VerticalAlignment;

public abstract class LayoutElement {
    protected static final CharSequence PERCENT_SIGN = "%";
    private String xPos;
    private String yPos;
    private HorizontalAlignment hAlign;
    private VerticalAlignment vAlign;

    protected LayoutElement(String xPos, String yPos) {
        this.setXPos(xPos);
        this.setYPos(yPos);
    }

    public abstract String getElementKey();

    protected final int calcProportionalValue(String ratio, int total) {
        return (int)((double)HGBaseTools.toInt(ratio.replace(PERCENT_SIGN, "").trim(), 0) / 100.0 * (double)total);
    }

    private void setXPos(String xPos) {
        this.hAlign = HorizontalAlignment.valueOfSecure(xPos.toUpperCase());
        this.xPos = this.hAlign == null ? xPos : null;
    }

    public Integer getXPos(IntSupplier surroundingAreaWidthSupplier) {
        if (this.xPos == null) {
            return null;
        }
        if (this.xPos.contains(PERCENT_SIGN)) {
            return surroundingAreaWidthSupplier != null ? this.calcProportionalValue(this.xPos, surroundingAreaWidthSupplier.getAsInt()) : 0;
        }
        return HGBaseTools.toInt(this.xPos);
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.hAlign;
    }

    private void setYPos(String yPos) {
        this.vAlign = VerticalAlignment.valueOfSecure(yPos.toUpperCase());
        this.yPos = this.vAlign == null ? yPos : null;
    }

    public Integer getYPos(IntSupplier surroundingAreaHeightSupplier) {
        if (this.yPos == null) {
            return null;
        }
        if (this.yPos.contains(PERCENT_SIGN)) {
            return surroundingAreaHeightSupplier != null ? this.calcProportionalValue(this.yPos, surroundingAreaHeightSupplier.getAsInt()) : 0;
        }
        return HGBaseTools.toInt(this.yPos);
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.vAlign;
    }
}

