/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.configurablelayout.layoutelement;

import hgb.lib.HGBaseTools;
import java.awt.Dimension;
import java.util.function.Supplier;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.DisplayArea;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;

public abstract class LayoutGameElement
extends LayoutElement
implements DisplayArea {
    private String type;
    private Integer percentSize;
    private ScaleType scale;
    private double angle;
    private AreaLayout area;

    protected LayoutGameElement(String type, String xPos, String yPos, String percentSize, double angle, AreaLayout area) {
        super(xPos, yPos);
        this.setType(type);
        this.setPercentSize(percentSize);
        this.setAngle(angle);
        this.setArea(area);
    }

    @Override
    public String getElementKey() {
        return this.getType();
    }

    private void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    private void setPercentSize(String percentSize) {
        this.scale = ScaleType.valueOfSecure(percentSize.toUpperCase());
        if (this.scale == null) {
            this.percentSize = HGBaseTools.toInt(percentSize);
            if (this.percentSize == -2147483631 || this.percentSize < 0) {
                this.percentSize = 100;
            }
        } else {
            this.percentSize = null;
        }
    }

    public int getPercentSize(Supplier<Dimension> elementSizeSupplier, Supplier<Dimension> areaSizeSupplier) {
        if (this.percentSize != null) {
            return this.percentSize;
        }
        if (elementSizeSupplier == null || areaSizeSupplier == null) {
            return 100;
        }
        return this.scale.getPercentSize(elementSizeSupplier.get(), areaSizeSupplier.get());
    }

    public ScaleType getScale() {
        return this.scale;
    }

    private void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setArea(AreaLayout area) {
        this.area = area;
    }

    @Override
    public AreaLayout getArea() {
        return this.area;
    }
}

