/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.configurablelayout.layoutelement;

import hgb.gui.HGBaseGuiTools;
import hgb.gui.util.StringSizeSupplier;
import java.awt.Color;
import java.awt.Dimension;
import java.util.function.Supplier;
import tjger.gui.completed.configurablelayout.PlayerInfo;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.DisplayArea;
import tjger.gui.completed.configurablelayout.layoutelement.IndexedLayoutElement;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;

public class PlayerInfoLayout
extends LayoutElement
implements DisplayArea,
IndexedLayoutElement {
    private PlayerInfo type;
    private int playerIndex;
    private String fontSize;
    private ScaleType scale;
    private Color color;
    private double angle;
    private AreaLayout area;

    public PlayerInfoLayout(String type, int playerIndex, String xPos, String yPos, String fontSize, Color color, double angle, AreaLayout area) {
        super(xPos, yPos);
        this.setType(type);
        this.setPlayerIndex(playerIndex);
        this.setFontSize(fontSize);
        this.setColor(color);
        this.setAngle(angle);
        this.setArea(area);
    }

    @Override
    public String getElementKey() {
        return this.getType().name() + this.getPlayerIndex();
    }

    private void setType(String type) {
        this.type = PlayerInfo.valueOf(type != null ? type.toUpperCase() : null);
    }

    public PlayerInfo getType() {
        return this.type;
    }

    @Override
    public void setPlayerIndex(int playerIndex) {
        this.playerIndex = playerIndex;
    }

    @Override
    public int getPlayerIndex() {
        return this.playerIndex;
    }

    private void setFontSize(String fontSize) {
        this.scale = ScaleType.valueOfSecure(fontSize.toUpperCase());
        this.fontSize = this.scale == null ? fontSize : null;
    }

    private int findOptimalFontSize(StringSizeSupplier stringSizeSupplier, int maxHeight, int maxWidth) {
        if (stringSizeSupplier == null) {
            return 0;
        }
        int low = 0;
        int high = 1000;
        while (low <= high) {
            int mid = (low + high) / 2;
            Dimension stringSize = stringSizeSupplier.get(mid);
            if (!(stringSize.width > maxWidth && maxWidth != -1 || stringSize.height > maxHeight && maxHeight != -1)) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return high;
    }

    private float getScaledFontSize(StringSizeSupplier stringSizeSupplier, Supplier<Dimension> areaSizeSupplier) throws IllegalArgumentException {
        if (this.getScale() == null || stringSizeSupplier == null || areaSizeSupplier == null) {
            throw new IllegalArgumentException();
        }
        Dimension areaSize = areaSizeSupplier.get();
        switch (this.getScale()) {
            case SCALE: {
                return this.findOptimalFontSize(stringSizeSupplier, areaSize.height, areaSize.width);
            }
            case SCALE_X: {
                return this.findOptimalFontSize(stringSizeSupplier, -1, areaSize.width);
            }
            case SCALE_Y: {
                return HGBaseGuiTools.convertPixelToFontSize(areaSize.height);
            }
        }
        throw new IllegalArgumentException("Invalid scale type " + this.getScale().name());
    }

    public final float getPercentFontSize(Supplier<Dimension> areaSizeSupplier) throws IllegalArgumentException {
        if (areaSizeSupplier == null) {
            throw new IllegalArgumentException("The supplier for the area size must be specified!");
        }
        if (this.fontSize == null) {
            throw new IllegalArgumentException("The font size was not set for the player information " + this.getElementKey() + "!");
        }
        if (!this.fontSize.contains(PERCENT_SIGN)) {
            throw new IllegalArgumentException("The font size was not specified as percentage for the player information " + this.getElementKey() + "!");
        }
        return HGBaseGuiTools.convertPixelToFontSize(this.calcProportionalValue(this.fontSize, areaSizeSupplier.get().height));
    }

    public Float getFontSize(StringSizeSupplier stringSizeSupplier, Supplier<Dimension> areaSizeSupplier) {
        try {
            return Float.valueOf(this.getScaledFontSize(stringSizeSupplier, areaSizeSupplier));
        }
        catch (Exception exception) {
            try {
                return Float.valueOf(this.getPercentFontSize(areaSizeSupplier));
            }
            catch (Exception exception2) {
                if (this.fontSize != null) {
                    return Float.valueOf(this.fontSize);
                }
                return null;
            }
        }
    }

    public ScaleType getScale() {
        return this.scale;
    }

    private void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    private void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    @Override
    public void setArea(AreaLayout area) {
        this.area = area;
    }

    @Override
    public AreaLayout getArea() {
        return this.area;
    }
}

