/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.completed.playingfield;

import hgb.gui.HGBaseGuiTools;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import tjger.game.completed.playingfield.PlayingField;
import tjger.game.completed.playingfield.SingleField;
import tjger.gui.GamePanel;
import tjger.gui.completed.playingfield.SingleFieldPainter;

public class SingleFieldAreaPainter
implements SingleFieldPainter {
    private final Color borderColor;
    private final Color fillColor;

    public SingleFieldAreaPainter(Color border, Color fill) {
        this.borderColor = border;
        this.fillColor = fill;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    @Override
    public void drawSingleField(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        switch (field.getShape()) {
            case SQUARE: 
            case RECTANGLE: {
                this.drawRectangle(playField, field, panel, g);
                break;
            }
            case CIRCLE: 
            case ELLIPSE: {
                this.drawEllipse(playField, field, panel, g);
                break;
            }
            case POLYGON: {
                this.drawPolygon(playField, field, panel, g);
                break;
            }
            default: {
                throw new IllegalStateException("The given field has an unknown shape: " + String.valueOf((Object)field.getShape()));
            }
        }
    }

    protected void drawRectangle(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        Point[] positions = playField.getPixelPositions(field);
        RectangleDimension dim = RectangleDimension.fromPoints(positions);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            panel.drawRect(dim.x, dim.y, dim.width, dim.height, true, g);
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            panel.drawRect(dim.x, dim.y, dim.width, dim.height, false, g);
        }
    }

    protected void drawEllipse(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        Point[] positions = playField.getPixelPositions(field);
        RectangleDimension dim = RectangleDimension.fromPoints(positions);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            panel.drawOval(dim.x, dim.y, dim.width, dim.height, true, g);
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            panel.drawOval(dim.x, dim.y, dim.width, dim.height, false, g);
        }
    }

    protected void drawPolygon(PlayingField playField, SingleField field, GamePanel panel, Graphics g) {
        Point[] positions = playField.getPixelPositions(field);
        Polygon polygon = HGBaseGuiTools.createPolygon(positions);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            panel.drawPolygon(polygon, true, g);
        }
        if (this.borderColor != null) {
            g.setColor(this.borderColor);
            panel.drawPolygon(polygon, false, g);
        }
    }

    protected static class RectangleDimension {
        int x;
        int y;
        int width;
        int height;

        private RectangleDimension() {
        }

        public static RectangleDimension fromPoints(Point[] positions) {
            if (positions.length == 2) {
                RectangleDimension dim = new RectangleDimension();
                dim.x = positions[0].x;
                dim.y = positions[0].y;
                dim.width = positions[1].x - positions[0].x + 1;
                dim.height = positions[1].y - positions[0].y + 1;
                return dim;
            }
            throw new IllegalStateException("The pixel positions do not suite to the shape type of the field!");
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }
    }
}

