/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel;

import hgb.gui.util.MouseClickAction;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import tjger.game.GameRules;
import tjger.game.GameState;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.lib.PlayerUtil;

public abstract class GamePanelMouseListener<P extends GamePanel, R extends GameRules, S extends GameState>
implements MouseListener {
    private P gamePanel;
    private GameEngine gameEngine;

    protected GamePanelMouseListener(P gamePanel, GameEngine gameEngine) {
        this.gamePanel = gamePanel;
        this.gameEngine = gameEngine;
    }

    protected P getGamePanel() {
        return this.gamePanel;
    }

    protected GameEngine getGameEngine() {
        return this.gameEngine;
    }

    protected R getGameRules() {
        return (R)this.getGameEngine().getGameManager().getGameRules();
    }

    protected S getGameState() {
        return (S)this.getGameEngine().getGameState();
    }

    protected boolean isHumanPlayer() {
        return PlayerUtil.isHumanPlaying(this.getGameEngine());
    }

    protected List<Part> getClickedParts() {
        return ((GamePanel)this.getGamePanel()).getPartsAtMousePosition();
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        if (!this.isHumanPlayer()) {
            return;
        }
        switch (MouseClickAction.valueOf(ev)) {
            case LEFT_SINGLE: {
                this.onLeftSingleClick(this.getClickedParts());
                break;
            }
            case LEFT_DOUBLE: {
                this.onLeftDoubleClick(this.getClickedParts());
                break;
            }
            case MIDDLE_SINGLE: {
                this.onMiddleSingleClick(this.getClickedParts());
                break;
            }
            case MIDDLE_DOUBLE: {
                this.onMiddleDoubleClick(this.getClickedParts());
                break;
            }
            case RIGHT_SINGLE: {
                this.onRightSingleClick(this.getClickedParts());
                break;
            }
            case RIGHT_DOUBLE: {
                this.onRightDoubleClick(this.getClickedParts());
                break;
            }
        }
    }

    protected abstract void onLeftSingleClick(List<Part> var1);

    protected abstract void onLeftDoubleClick(List<Part> var1);

    protected abstract void onMiddleSingleClick(List<Part> var1);

    protected abstract void onMiddleDoubleClick(List<Part> var1);

    protected abstract void onRightSingleClick(List<Part> var1);

    protected abstract void onRightDoubleClick(List<Part> var1);

    protected void repaintGamePanel() {
        ((Component)this.getGamePanel()).repaint();
    }

    protected void performMove(MoveInformation move) {
        if (move == null || !((GameRules)this.getGameRules()).isValidMove(move, (GameState)this.getGameState())) {
            return;
        }
        this.getGameEngine().performMove(move);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
    }

    @Override
    public void mouseExited(MouseEvent ev) {
    }
}

