/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import tjger.game.completed.GameConfig;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.CardsetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;
import tjger.gui.completed.configurablelayout.layoutelement.PartLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PartsetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PiecesetLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PlayerInfoLayout;
import tjger.gui.gamepanel.configurablelayout.painter.AreaPainter;
import tjger.gui.gamepanel.configurablelayout.painter.CardsetPainter;
import tjger.gui.gamepanel.configurablelayout.painter.ElementPainter;
import tjger.gui.gamepanel.configurablelayout.painter.PartPainter;
import tjger.gui.gamepanel.configurablelayout.painter.PartsetPainter;
import tjger.gui.gamepanel.configurablelayout.painter.PiecesetPainter;
import tjger.gui.gamepanel.configurablelayout.painter.PlayerInfoPainter;

public class ConfigurableGamePanel
extends GamePanel {
    private final GameConfig config = this.getGameConfig();
    private HashMap<Class<? extends LayoutElement>, ElementPainter<? extends LayoutElement, ? extends Part, ? extends GamePanel>> painterMap;

    public ConfigurableGamePanel() {
        this.createPainter();
    }

    private void createPainter() {
        this.painterMap = new HashMap();
        this.painterMap.put(AreaLayout.class, this.createAreaPainter());
        this.painterMap.put(PartLayout.class, this.createPartPainter());
        this.painterMap.put(PartsetLayout.class, this.createPartsetPainter());
        this.painterMap.put(CardsetLayout.class, this.createCardsetPainter());
        this.painterMap.put(PiecesetLayout.class, this.createPiecesetPainter());
        this.painterMap.put(PlayerInfoLayout.class, this.createPlayerInfoPainter());
    }

    @Override
    public Dimension getFieldSize() {
        Insets margin = this.config.getGamefieldLayoutMargin();
        return new Dimension(this.getFieldWidth() - margin.left - margin.right, this.getFieldHeight() - margin.top - margin.bottom);
    }

    protected AreaPainter<?> createAreaPainter() {
        return new AreaPainter<ConfigurableGamePanel>(this);
    }

    public final AreaPainter<?> getAreaPainter() {
        return (AreaPainter)this.painterMap.get(AreaLayout.class);
    }

    protected PartPainter<?> createPartPainter() {
        return new PartPainter<ConfigurableGamePanel>(this);
    }

    protected final PartPainter<?> getPartPainter() {
        return (PartPainter)this.painterMap.get(PartLayout.class);
    }

    protected PartsetPainter<?> createPartsetPainter() {
        return new PartsetPainter<ConfigurableGamePanel>(this);
    }

    protected final PartsetPainter<?> getPartsetPainter() {
        return (PartsetPainter)this.painterMap.get(PartsetLayout.class);
    }

    protected CardsetPainter<?> createCardsetPainter() {
        return new CardsetPainter<ConfigurableGamePanel>(this);
    }

    protected final CardsetPainter<?> getCardsetPainter() {
        return (CardsetPainter)this.painterMap.get(CardsetLayout.class);
    }

    protected PiecesetPainter<?> createPiecesetPainter() {
        return new PiecesetPainter<ConfigurableGamePanel>(this);
    }

    protected final PiecesetPainter<?> getPiecesetPainter() {
        return (PiecesetPainter)this.painterMap.get(PiecesetLayout.class);
    }

    protected PlayerInfoPainter<?> createPlayerInfoPainter() {
        return new PlayerInfoPainter<ConfigurableGamePanel>(this);
    }

    protected final PlayerInfoPainter<?> getPlayerInfoPainter() {
        return (PlayerInfoPainter)this.painterMap.get(PlayerInfoLayout.class);
    }

    protected boolean isPaintPartsAllowed() {
        return true;
    }

    private Map<String, LayoutElement> getLayoutElements(Class<? extends LayoutElement> elementClass) {
        return this.config.getLayoutElements().getOrDefault(elementClass, new HashMap());
    }

    protected final Stream<AreaLayout> getLayoutAreas() {
        return this.getLayoutElements(AreaLayout.class).values().stream().map(AreaLayout.class::cast);
    }

    protected final Stream<PartLayout> getLayoutParts() {
        return this.getLayoutElements(PartLayout.class).values().stream().map(PartLayout.class::cast);
    }

    protected final Stream<PartsetLayout> getLayoutPartsets() {
        return this.getLayoutElements(PartsetLayout.class).values().stream().map(PartsetLayout.class::cast);
    }

    protected final Stream<CardsetLayout> getLayoutCardsets() {
        return this.getLayoutElements(CardsetLayout.class).values().stream().map(CardsetLayout.class::cast);
    }

    protected final Stream<PiecesetLayout> getLayoutPiecesets() {
        return this.getLayoutElements(PiecesetLayout.class).values().stream().map(PiecesetLayout.class::cast);
    }

    protected final Stream<PlayerInfoLayout> getLayoutPlayerInfos() {
        return this.getLayoutElements(PlayerInfoLayout.class).values().stream().map(PlayerInfoLayout.class::cast);
    }

    @Override
    protected void paintParts(Graphics g) {
        super.paintParts(g);
        if (!this.isPaintPartsAllowed()) {
            return;
        }
        this.paintLayoutAreas(this.getLayoutAreas(), g);
        this.paintLayoutParts(this.getLayoutParts(), g);
        this.paintLayoutPartsets(this.getLayoutPartsets(), g);
        this.paintLayoutCardsets(this.getLayoutCardsets(), g);
        this.paintLayoutPiecesets(this.getLayoutPiecesets(), g);
        this.paintLayoutPlayerInfos(this.getLayoutPlayerInfos(), g);
    }

    private void paintLayoutAreas(Stream<AreaLayout> areas, Graphics g) {
        if (areas == null) {
            return;
        }
        areas.forEach(area -> this.paintLayoutArea((AreaLayout)area, g));
    }

    private void paintLayoutArea(AreaLayout area, Graphics g) {
        AreaPainter<?> areaPainter = this.getAreaPainter();
        if (area == null || !areaPainter.shouldPaint(area)) {
            return;
        }
        areaPainter.paint(area, g);
    }

    private void paintLayoutParts(Stream<PartLayout> parts, Graphics g) {
        if (parts == null) {
            return;
        }
        parts.forEach(part -> this.paintLayoutPart((PartLayout)part, g));
    }

    private void paintLayoutPart(PartLayout part, Graphics g) {
        PartPainter<?> partPainter = this.getPartPainter();
        if (part == null || !partPainter.shouldPaint(part)) {
            return;
        }
        partPainter.paint(part, g);
    }

    private void paintLayoutPartsets(Stream<PartsetLayout> partsets, Graphics g) {
        if (partsets == null) {
            return;
        }
        partsets.forEach(partset -> this.paintLayoutPartset((PartsetLayout)partset, g));
    }

    private void paintLayoutPartset(PartsetLayout partset, Graphics g) {
        PartsetPainter<?> partsetPainter = this.getPartsetPainter();
        if (partset == null || !partsetPainter.shouldPaint(partset)) {
            return;
        }
        partsetPainter.paint(partset, g);
    }

    private void paintLayoutCardsets(Stream<CardsetLayout> cardsets, Graphics g) {
        if (cardsets == null) {
            return;
        }
        cardsets.forEach(cardset -> this.paintLayoutCardset((CardsetLayout)cardset, g));
    }

    private void paintLayoutCardset(CardsetLayout cardset, Graphics g) {
        CardsetPainter<?> cardsetPainter = this.getCardsetPainter();
        if (cardset == null || !cardsetPainter.shouldPaint(cardset)) {
            return;
        }
        cardsetPainter.paint(cardset, g);
    }

    private void paintLayoutPiecesets(Stream<PiecesetLayout> piecesets, Graphics g) {
        if (piecesets == null) {
            return;
        }
        piecesets.forEach(pieceset -> this.paintLayoutPieceset((PiecesetLayout)pieceset, g));
    }

    private void paintLayoutPieceset(PiecesetLayout pieceset, Graphics g) {
        PiecesetPainter<?> piecesetPainter = this.getPiecesetPainter();
        if (pieceset == null || !piecesetPainter.shouldPaint(pieceset)) {
            return;
        }
        piecesetPainter.paint(pieceset, g);
    }

    private void paintLayoutPlayerInfos(Stream<PlayerInfoLayout> playerInfos, Graphics g) {
        if (playerInfos == null) {
            return;
        }
        playerInfos.forEach(playerInfo -> this.paintLayoutPlayerInfo((PlayerInfoLayout)playerInfo, g));
    }

    private void paintLayoutPlayerInfo(PlayerInfoLayout playerInfo, Graphics g) {
        PlayerInfoPainter<?> playerInfoPainter = this.getPlayerInfoPainter();
        if (playerInfo == null || !playerInfoPainter.shouldPaint(playerInfo)) {
            return;
        }
        playerInfoPainter.paint(playerInfo, g);
    }
}

