/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout.painter;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.gamepanel.configurablelayout.painter.ElementPainter;

public class AreaPainter<G extends GamePanel>
implements ElementPainter<AreaLayout, Part, G> {
    private final G gamePanel;

    public AreaPainter(G gamePanel) {
        this.gamePanel = gamePanel;
    }

    @Override
    public G getGamePanel() {
        return this.gamePanel;
    }

    @Override
    public Part getActiveElement(AreaLayout element) {
        throw new UnsupportedOperationException("There are no active gamefield elements for an area!");
    }

    @Override
    public boolean shouldPaint(AreaLayout element) {
        return ElementPainter.super.shouldPaint(element) && !element.isHidden();
    }

    @Override
    public int getPercentSize(AreaLayout element) {
        return 100;
    }

    @Override
    public ScaleType getScale(AreaLayout element) {
        return null;
    }

    @Override
    public double getPaintAngle(AreaLayout element) {
        return 0.0;
    }

    @Override
    public Dimension getPaintDimension(AreaLayout element, Graphics g) {
        return new Dimension(element.getWidth(() -> ((GamePanel)this.getGamePanel()).getFieldWidth()), element.getHeight(() -> ((GamePanel)this.getGamePanel()).getFieldHeight()));
    }

    protected Color getColor(AreaLayout element) {
        return Color.BLACK;
    }

    @Override
    public void paint(AreaLayout element, Graphics g) {
        Point pos = this.getPaintPosition(element, g);
        Dimension dimension = this.getPaintDimension(element, g);
        ((GamePanel)this.getGamePanel()).changeColor(this.getColor(element), g);
        ((GamePanel)this.getGamePanel()).drawRect(pos.x, pos.y, dimension.width, dimension.height, false, g);
    }
}

