/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import tjger.game.completed.GameConfig;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.DisplayArea;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutElement;
import tjger.gui.gamepanel.configurablelayout.ConfigurableGamePanel;

public interface ElementPainter<E extends LayoutElement, P extends Part, G extends GamePanel> {
    public G getGamePanel();

    public P getActiveElement(E var1);

    default public boolean shouldPaint(E element) {
        return true;
    }

    public int getPercentSize(E var1);

    public ScaleType getScale(E var1);

    default public boolean isScaleUsed(E element) {
        return this.getScale(element) != null;
    }

    default public int calcPaintWidth(int elementWidth, int percentSize) {
        double factor = (double)percentSize / 100.0;
        return (int)((double)elementWidth * factor);
    }

    default public int calcPaintHeight(int elementHeight, int percentSize) {
        double factor = (double)percentSize / 100.0;
        return (int)((double)elementHeight * factor);
    }

    public double getPaintAngle(E var1);

    public Dimension getPaintDimension(E var1, Graphics var2);

    private AreaLayout getSurroundingArea(E element) {
        return element instanceof DisplayArea ? ((DisplayArea)element).getArea() : null;
    }

    private Insets getMargin(E element) {
        AreaLayout area = this.getSurroundingArea(element);
        return area != null ? area.getMargin(() -> ((GamePanel)this.getGamePanel()).getFieldSize()) : GameConfig.getInstance().getGamefieldLayoutMargin();
    }

    private Point getSurroundingAreaPosition(E element, Graphics g) {
        AreaLayout area = this.getSurroundingArea(element);
        return area != null ? ((ConfigurableGamePanel)this.getGamePanel()).getAreaPainter().getPaintPosition(area, g) : new Point(0, 0);
    }

    private int getSurroundingAreaWidth(E element) {
        AreaLayout area = this.getSurroundingArea(element);
        return area != null ? area.getWidth(() -> ((GamePanel)this.getGamePanel()).getFieldWidth()) : ((GamePanel)this.getGamePanel()).getFieldWidth();
    }

    private int getSurroundingAreaHeight(E element) {
        AreaLayout area = this.getSurroundingArea(element);
        return area != null ? area.getHeight(() -> ((GamePanel)this.getGamePanel()).getFieldHeight()) : ((GamePanel)this.getGamePanel()).getFieldHeight();
    }

    default public Dimension getSurroundingAreaDimension(E element) {
        AreaLayout area = this.getSurroundingArea(element);
        return area != null ? area.getInnerSize(() -> ((GamePanel)this.getGamePanel()).getFieldSize()) : ((GamePanel)this.getGamePanel()).getFieldSize();
    }

    private int calcHorizontalPosition(E element, Graphics g) {
        Insets margin = this.getMargin(element);
        Point areaPosition = this.getSurroundingAreaPosition(element, g);
        Integer xPos = ((LayoutElement)element).getXPos(() -> this.getSurroundingAreaWidth(element));
        if (xPos != null) {
            return xPos + areaPosition.x + margin.left;
        }
        Dimension dimension = this.getPaintDimension(element, g);
        return areaPosition.x + ((LayoutElement)element).getHorizontalAlignment().getXPosition(dimension.width, this.getSurroundingAreaWidth(element), margin.left, margin.right);
    }

    private int calcVerticalPosition(E element, Graphics g) {
        Insets margin = this.getMargin(element);
        Point areaPosition = this.getSurroundingAreaPosition(element, g);
        Integer yPos = ((LayoutElement)element).getYPos(() -> this.getSurroundingAreaHeight(element));
        if (yPos != null) {
            return yPos + areaPosition.y + margin.top;
        }
        Dimension dimension = this.getPaintDimension(element, g);
        return areaPosition.y + ((LayoutElement)element).getVerticalAlignment().getYPosition(dimension.height, this.getSurroundingAreaHeight(element), margin.top, margin.bottom);
    }

    default public Point getPaintPosition(E element, Graphics g) {
        return new Point(this.calcHorizontalPosition(element, g), this.calcVerticalPosition(element, g));
    }

    default public Rectangle getPaintArea(E element, Graphics g) {
        return new Rectangle(this.getPaintPosition(element, g), this.getPaintDimension(element, g));
    }

    public void paint(E var1, Graphics var2);
}

