/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import tjger.gui.GamePanel;
import tjger.gui.Orientation;
import tjger.gui.completed.Card;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.CoverableLayoutElement;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutGameElement;
import tjger.gui.completed.configurablelayout.layoutelement.LayoutGameElementSet;
import tjger.gui.gamepanel.configurablelayout.painter.ElementPainter;
import tjger.gui.gamepanel.configurablelayout.painter.ElementSetSelectionPainter;
import tjger.lib.PartUtil;

public interface ElementSetPainter<E extends LayoutGameElementSet, S extends PartSet, P extends Part, G extends GamePanel>
extends ElementPainter<E, S, G>,
ElementSetSelectionPainter<E> {
    public P[] getActiveElements(E var1);

    default public Dimension getPaintSpacing(E element) {
        return ((LayoutGameElementSet)element).getSpacing();
    }

    default public Orientation getPaintOrientation(E element) {
        return ((LayoutGameElementSet)element).getOrientation();
    }

    default public int getPaintWrapThreshold(E element) {
        return ((LayoutGameElementSet)element).getWrapThreshold();
    }

    @Override
    default public int getPercentSize(E element) {
        return ((LayoutGameElement)element).getPercentSize(() -> this.getUnscaledPaintDimension(element), () -> this.getSurroundingAreaDimension(element));
    }

    @Override
    default public ScaleType getScale(E element) {
        return ((LayoutGameElement)element).getScale();
    }

    @Override
    default public double getPaintAngle(E element) {
        return ((LayoutGameElement)element).getAngle();
    }

    private Dimension getUnscaledPaintDimension(E element) {
        return this.getPercentagePaintDimension(element, 100);
    }

    private Dimension getPercentagePaintDimension(E element, int percentSize) {
        Part[] elements = this.getActiveElements((LayoutGameElementSet)element);
        Dimension spacing = this.getPaintSpacing(element);
        int width = 0;
        int height = 0;
        int elementIndex = 0;
        while (elementIndex < elements.length) {
            ImageIcon image = elements[elementIndex].getImage();
            width = Math.max(width, this.calcPaintWidth(image.getIconWidth(), percentSize) + elementIndex * spacing.width);
            height = Math.max(height, this.calcPaintHeight(image.getIconHeight(), percentSize) + elementIndex * spacing.height);
            ++elementIndex;
        }
        return new Dimension(width, height);
    }

    @Override
    default public Dimension getPaintDimension(E element, Graphics g) {
        if (this.isScaleUsed(element)) {
            return this.getSurroundingAreaDimension(element);
        }
        return this.getPercentagePaintDimension(element, this.getPercentSize(element));
    }

    default public boolean isCovered(E element) {
        return element instanceof CoverableLayoutElement && ((CoverableLayoutElement)element).isCovered();
    }

    default public P[] getCovers(E element, P[] parts) {
        if (this.isCovered(element) && parts instanceof Card[]) {
            return PartUtil.getCovers((Card[])parts);
        }
        return parts;
    }

    @Override
    default public void paint(E element, Graphics g) {
        Orientation orientation;
        Point pos = this.getPaintPosition(element, g);
        int percentSize = this.getPercentSize(element);
        Dimension spacing = this.getPaintSpacing(element);
        Part[] parts = this.getCovers((LayoutGameElementSet)element, this.getActiveElements((LayoutGameElementSet)element));
        if (this.isScaleUsed(element)) {
            double factor = (double)percentSize / 100.0;
            spacing = new Dimension((int)((double)spacing.width * factor), (int)((double)spacing.height * factor));
        }
        if ((orientation = this.getPaintOrientation(element)) != null) {
            ((GamePanel)this.getGamePanel()).drawParts(pos.x, pos.y, percentSize, this.getPaintAngle(element), orientation, this.getPaintWrapThreshold(element), parts, spacing.width, spacing.height, g);
        } else {
            ((GamePanel)this.getGamePanel()).drawParts(pos.x, pos.y, percentSize, this.getPaintAngle(element), parts, spacing.width, spacing.height, g);
        }
        if (this.isSelected(element)) {
            PartUtil.drawSelectedPart(this.getSelectedIndex(element), parts, pos.x, pos.y, percentSize, spacing.width, spacing.height, this.getSelectionColor(element), this.getGamePanel(), g);
        }
    }
}

