/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import javax.swing.ImageIcon;
import tjger.game.completed.GameConfig;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.AreaLayout;
import tjger.gui.completed.configurablelayout.layoutelement.PartLayout;
import tjger.gui.gamepanel.configurablelayout.painter.ElementPainter;
import tjger.gui.gamepanel.configurablelayout.painter.ElementSelectionPainter;
import tjger.lib.PartUtil;

public class PartPainter<G extends GamePanel>
implements ElementPainter<PartLayout, Part, G>,
ElementSelectionPainter<PartLayout> {
    private final G gamePanel;

    public PartPainter(G gamePanel) {
        this.gamePanel = gamePanel;
    }

    @Override
    public G getGamePanel() {
        return this.gamePanel;
    }

    @Override
    public Part getActiveElement(PartLayout element) {
        return GameConfig.getInstance().getActivePart(element.getType());
    }

    protected Dimension getActiveElementSize(PartLayout element) {
        ImageIcon image = this.getActiveElement(element).getImage();
        return new Dimension(image.getIconWidth(), image.getIconHeight());
    }

    @Override
    public int getPercentSize(PartLayout element) {
        return this.getPercentSize(element, this.getActiveElementSize(element));
    }

    protected int getPercentSize(PartLayout element, Dimension elementSize) {
        AreaLayout area = element.getArea();
        Dimension areaSize = area == null ? ((GamePanel)this.getGamePanel()).getFieldSize() : area.getInnerSize(() -> ((GamePanel)this.getGamePanel()).getFieldSize());
        return element.getPercentSize(() -> elementSize, () -> areaSize);
    }

    @Override
    public ScaleType getScale(PartLayout element) {
        return element.getScale();
    }

    @Override
    public double getPaintAngle(PartLayout element) {
        return element.getAngle();
    }

    @Override
    public Dimension getPaintDimension(PartLayout element, Graphics g) {
        Dimension elementSize = this.getActiveElementSize(element);
        return new Dimension(this.calcPaintWidth(elementSize.width, this.getPercentSize(element, elementSize)), this.calcPaintHeight(elementSize.height, this.getPercentSize(element, elementSize)));
    }

    @Override
    public void paint(PartLayout element, Graphics g) {
        Point pos = this.getPaintPosition(element, g);
        int percentSize = this.getPercentSize(element);
        Part part = this.getActiveElement(element);
        ((GamePanel)this.getGamePanel()).drawPart(pos.x, pos.y, percentSize, this.getPaintAngle(element), part, g);
        if (this.isSelected(element)) {
            PartUtil.drawSelectedPart(part, pos.x, pos.y, percentSize, this.getSelectionColor(element), this.getGamePanel(), g);
        }
    }
}

