/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.gamepanel.configurablelayout.painter;

import hgb.gui.util.StringSizeSupplier;
import hgb.lib.HGBaseTools;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.gui.GamePanel;
import tjger.gui.completed.Part;
import tjger.gui.completed.configurablelayout.ScaleType;
import tjger.gui.completed.configurablelayout.layoutelement.PlayerInfoLayout;
import tjger.gui.gamepanel.configurablelayout.painter.IndexedElementPainter;

public class PlayerInfoPainter<G extends GamePanel>
implements IndexedElementPainter<PlayerInfoLayout, Part, G> {
    private final G gamePanel;

    public PlayerInfoPainter(G gamePanel) {
        this.gamePanel = gamePanel;
    }

    @Override
    public G getGamePanel() {
        return this.gamePanel;
    }

    @Override
    public Part getActiveElement(PlayerInfoLayout element) {
        throw new UnsupportedOperationException("There are no active gamefield elements for a player information!");
    }

    @Override
    public int getPercentSize(PlayerInfoLayout element) {
        return (int)element.getPercentFontSize(() -> this.getSurroundingAreaDimension(element));
    }

    @Override
    public Point getPaintPosition(PlayerInfoLayout element, Graphics g) {
        Point pos = IndexedElementPainter.super.getPaintPosition(element, g);
        pos.translate(0, this.getFontMetrics(g).getAscent());
        return pos;
    }

    @Override
    public ScaleType getScale(PlayerInfoLayout element) {
        return element.getScale();
    }

    @Override
    public double getPaintAngle(PlayerInfoLayout element) {
        return element.getAngle();
    }

    @Override
    public Dimension getPaintDimension(PlayerInfoLayout element, Graphics g) {
        Float fontSize = this.getFontSize(element, g);
        if (fontSize == null) {
            return null;
        }
        return new StringSizeSupplier(this.getInformation(element), g).get(fontSize.floatValue());
    }

    protected Color getColor(PlayerInfoLayout element) {
        return element.getColor();
    }

    protected GamePlayer getPlayer(GameEngine engine, PlayerInfoLayout element) {
        return engine.getPlayerWithIndex(this.getPlayerIndex(element));
    }

    protected String getInformation(PlayerInfoLayout element) {
        GamePlayer player = this.getPlayer(GameEngine.getInstance(), element);
        if (player == null) {
            return null;
        }
        switch (element.getType()) {
            case NAME: {
                return this.getNameInformation(element, player);
            }
            case GAME_SCORE: {
                return this.getGameScoreInformation(element, player);
            }
            case ROUND_SCORE: {
                return this.getRoundScoreInformation(element, player);
            }
            case TURN_SCORE: {
                return this.getTurnScoreInformation(element, player);
            }
        }
        return null;
    }

    protected String getNameInformation(PlayerInfoLayout element, GamePlayer player) {
        return player.getName();
    }

    protected String getGameScoreInformation(PlayerInfoLayout element, GamePlayer player) {
        return this.getScoreInformation(player, 4);
    }

    protected String getRoundScoreInformation(PlayerInfoLayout element, GamePlayer player) {
        return this.getScoreInformation(player, 2);
    }

    protected String getTurnScoreInformation(PlayerInfoLayout element, GamePlayer player) {
        return this.getScoreInformation(player, 1);
    }

    private String getScoreInformation(GamePlayer player, int scoreType) {
        return String.valueOf(player.getScore(scoreType));
    }

    protected Float getFontSize(PlayerInfoLayout element, Graphics g) {
        return element.getFontSize(new StringSizeSupplier(this.getInformation(element), g), () -> this.getSurroundingAreaDimension(element));
    }

    protected void changeColor(PlayerInfoLayout element, Graphics g) {
        Color color = this.getColor(element);
        if (color != null) {
            ((GamePanel)this.getGamePanel()).changeColor(color, g);
        }
    }

    protected void changeFontSize(PlayerInfoLayout element, Graphics g) {
        Float fontSize = this.getFontSize(element, g);
        if (fontSize != null) {
            ((GamePanel)this.getGamePanel()).changeFont(fontSize.floatValue(), g);
        }
    }

    protected FontMetrics getFontMetrics(Graphics g) {
        return g.getFontMetrics();
    }

    @Override
    public void paint(PlayerInfoLayout element, Graphics g) {
        String info = this.getInformation(element);
        if (!HGBaseTools.hasContent(info)) {
            return;
        }
        this.changeColor(element, g);
        this.changeFontSize(element, g);
        Point pos = this.getPaintPosition(element, g);
        ((GamePanel)this.getGamePanel()).drawString(info, pos.x, pos.y, this.getPaintAngle(element), 1, g);
    }
}

