/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigComboBox;
import hgb.gui.config.HGBaseConfigDialog;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.GameElement;

public abstract class GameElementsDlg<A extends GameElement>
extends HGBaseConfigDialog {
    protected static final int COMBO_WIDTH = HGBaseSettings.getInt("partsDlgComboWidth", 150);
    protected static final int LABEL_WIDTH = HGBaseSettings.getInt("partsDlgLabelWidth", 120);
    private static final UserDefinedArrangement ARRANGE_USERDEFINED = new UserDefinedArrangement();
    private final String configKeyArrangement;
    private boolean completeArrangement;
    private boolean onChangeArrangement;
    protected List<HGBaseConfigItem> configItemList;

    protected GameElementsDlg(HGBaseFrame mainFrame, String dlgTitle, String configKeyArrangement) {
        super(mainFrame, dlgTitle);
        this.configKeyArrangement = configKeyArrangement;
        this.onChangeArrangement = false;
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        this.completeArrangement = this.isCompleteArrangement();
        this.configItemList = this.loadConfigItems();
        this.configItemList.removeIf(Objects::isNull);
        GameConfig config = GameConfig.getInstance();
        this.addDialogComponent(pnDialog, this.createNorthPanel(config), "North");
        this.addDialogComponent(pnDialog, this.createEastPanel(config), "East");
        this.addDialogComponent(pnDialog, this.createSouthPanel(config), "South");
        this.addDialogComponent(pnDialog, this.createWestPanel(config), "West");
        this.addDialogComponent(pnDialog, this.createCenterPanel(config), "Center");
    }

    private void addDialogComponent(JPanel panel, Component component, Object constraints) {
        if (component == null) {
            return;
        }
        panel.add(component, constraints);
    }

    protected abstract boolean isCompleteArrangement();

    protected abstract List<HGBaseConfigItem> loadConfigItems();

    protected JPanel createNorthPanel(GameConfig config) {
        return null;
    }

    protected JPanel createEastPanel(GameConfig config) {
        return null;
    }

    protected JPanel createSouthPanel(GameConfig config) {
        return null;
    }

    protected JPanel createWestPanel(GameConfig config) {
        return null;
    }

    protected JPanel createCenterPanel(GameConfig config) {
        return this.createConfigItemsPanel(config, this.configItemList);
    }

    protected JPanel createConfigItemsPanel(GameConfig config, List<HGBaseConfigItem> configItems) {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        configItems.stream().filter(Objects::nonNull).forEach(configItem -> {
            Component component = panel.add(this.createConfigItemPanel(config, (HGBaseConfigItem)configItem));
        });
        return panel;
    }

    protected JPanel createConfigItemPanel(GameConfig config, HGBaseConfigItem configItem) {
        JPanel panel = new JPanel(new FlowLayout(0));
        this.getConfigItemPanelComponents(config, configItem).forEach(panel::add);
        return panel;
    }

    protected List<Component> getConfigItemPanelComponents(GameConfig config, HGBaseConfigItem configItem) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (configItem instanceof Component) {
            components.add(this.createConfigItemLabel(this.getConfigItemLabelTextId(configItem)));
            components.add((Component)((Object)configItem));
        }
        return components;
    }

    protected String getConfigItemLabelTextId(HGBaseConfigItem configItem) {
        if (configItem instanceof HGBaseConfigComboBox) {
            return ((HGBaseConfigComboBox)configItem).getId();
        }
        return configItem.getOption();
    }

    protected JLabel createConfigItemLabel(String textId) {
        return this.createLabel(HGBaseText.getText(textId, new String[0]) + ":");
    }

    protected JLabel createLabel(String text) {
        JLabel label = new JLabel(text);
        label.setPreferredSize(new Dimension(LABEL_WIDTH, HGBaseGuiTools.getFieldHeight()));
        return label;
    }

    protected GameElementComboBox createGameElementComboBox(String id, GameElement[] elements, GameElement activeElement) {
        List<GameElement> elementsList = this.removeHiddenElements(elements);
        if (elementsList.isEmpty()) {
            return null;
        }
        JComboBox<GameElement> combobox = HGBaseGuiTools.createArrayComboBox(elementsList.toArray(new GameElement[0]), COMBO_WIDTH, HGBaseGuiTools.getFieldHeight());
        GameElementComboBox cbElement = new GameElementComboBox(id, id, combobox);
        try {
            if (activeElement != null) {
                cbElement.setSelectedItem(activeElement);
            }
        }
        catch (Exception e) {
            HGBaseLog.logWarn("Exception at createGameElementComboBox: " + e.getMessage());
        }
        if (this.isArrangementCombobox(cbElement) && !this.completeArrangement) {
            cbElement.addItem(ARRANGE_USERDEFINED);
        }
        cbElement.setEnabled(this.isComboboxChangeable(cbElement));
        this.addComboboxActionListener(cbElement);
        return cbElement;
    }

    protected List<GameElement> removeHiddenElements(GameElement[] elements) {
        ArrayList<GameElement> elementsList = new ArrayList<GameElement>(Arrays.asList(elements));
        elementsList.removeIf(GameElement::isHidden);
        return elementsList;
    }

    protected void addComboboxActionListener(GameElementComboBox combobox) {
        if (this.isArrangementCombobox(combobox)) {
            combobox.addActionListener(ev -> this.onArrangementChanged());
        } else {
            combobox.addActionListener(ev -> this.onGameElementComboBoxChanged((GameElementComboBox)ev.getSource()));
        }
    }

    protected void onArrangementChanged() {
        this.changeArrangement(this.getSelectedArrangement());
    }

    protected void onGameElementComboBoxChanged(GameElementComboBox combobox) {
        if (this.isArrangementElement(combobox.getId())) {
            this.testArrangementModified();
        }
    }

    protected void changeArrangement(A arrangement) {
        if (arrangement == null) {
            this.testArrangementModified();
            return;
        }
        this.onChangeArrangement = true;
        Set<String> types = this.getArrangementTypes();
        types.forEach(type -> this.setConfigItemValue((String)type, this.getArrangementValue(arrangement, (String)type)));
        this.onChangeArrangement = false;
    }

    protected void testArrangementModified() {
        if (!this.isArrangementAvailable() || this.isArrangementChanging()) {
            return;
        }
        GameElementComboBox arrangementCombobox = this.getArrangementCombobox();
        if (arrangementCombobox == null) {
            return;
        }
        Object newArrangement = this.findMatchingArrangement(this.getArrangementTypes());
        if (newArrangement == null) {
            newArrangement = ARRANGE_USERDEFINED;
        }
        arrangementCombobox.setSelectedItem(newArrangement);
    }

    protected A findMatchingArrangement(Set<String> types) {
        return (A)((GameElement)Arrays.stream(this.getAvailableArrangements()).filter(arrangement -> types.stream().allMatch(type -> this.isArrangementElement((A)arrangement, (String)type))).findFirst().orElse(null));
    }

    protected abstract A[] getAvailableArrangements();

    protected boolean isArrangementElement(String type) {
        return this.getArrangementTypes().contains(type);
    }

    protected abstract boolean isArrangementElement(A var1, String var2);

    protected boolean isArrangementElement(GameElement arrangementElement, GameElement selectedElement) {
        if (arrangementElement != null && arrangementElement.isHidden()) {
            return true;
        }
        return Objects.equals(arrangementElement, selectedElement);
    }

    protected boolean isComboboxChangeable(GameElementComboBox combobox) {
        return combobox.getItemCount() != 1 && (!this.completeArrangement || this.isArrangementCombobox(combobox));
    }

    protected boolean isArrangementAvailable() {
        return HGBaseTools.hasContent(this.configKeyArrangement);
    }

    protected boolean isArrangementChanging() {
        return this.onChangeArrangement;
    }

    protected boolean isArrangementCombobox(GameElementComboBox combobox) {
        return combobox.getId().equals(this.configKeyArrangement);
    }

    protected GameElementComboBox getArrangementCombobox() {
        if (this.configItemList == null || this.configItemList.isEmpty()) {
            return null;
        }
        return this.configItemList.stream().filter(GameElementComboBox.class::isInstance).map(GameElementComboBox.class::cast).filter(Objects::nonNull).filter(this::isArrangementCombobox).findFirst().orElse(null);
    }

    protected A getSelectedArrangement() {
        GameElementComboBox combobox = this.getArrangementCombobox();
        if (combobox == null) {
            return null;
        }
        Object selectedItem = combobox.getSelectedItem();
        return (A)(selectedItem instanceof UserDefinedArrangement ? null : (GameElement)selectedItem);
    }

    protected abstract Set<String> getArrangementTypes();

    protected abstract Object getArrangementValue(A var1, String var2);

    protected abstract void setConfigItemValue(String var1, Object var2);

    protected abstract Object getConfigItemValue(String var1);

    protected HGBaseConfigItem getConfigItem(String type) {
        if (this.configItemList == null || this.configItemList.isEmpty() || !HGBaseTools.hasContent(type)) {
            return null;
        }
        return this.configItemList.stream().filter(item -> type.equals(item.getOption())).findFirst().orElse(null);
    }

    protected GameElementComboBox getCombobox(String type) {
        HGBaseConfigItem configItem = this.getConfigItem(type);
        if (configItem instanceof GameElementComboBox) {
            return (GameElementComboBox)configItem;
        }
        return null;
    }

    public Object getSelectedComboboxValue(String type) {
        GameElementComboBox comboBox = this.getCombobox(type);
        return comboBox != null ? comboBox.getSelectedItem() : null;
    }

    protected void setComboboxValue(String type, Object value) {
        GameElementComboBox comboBox = this.getCombobox(type);
        if (comboBox == null) {
            return;
        }
        comboBox.setSelectedItem(value);
    }

    protected void enableAllComboboxes() {
        this.configItemList.stream().filter(GameElementComboBox.class::isInstance).map(GameElementComboBox.class::cast).forEach(item -> item.setEnabled(true));
    }

    @Override
    protected void okPressed() {
        this.enableAllComboboxes();
        super.okPressed();
    }

    protected static class GameElementComboBox
    extends HGBaseConfigComboBox<GameElement> {
        public GameElementComboBox(String id, String option, JComboBox<GameElement> box) {
            super(id, option, box);
        }
    }

    private static class UserDefinedArrangement
    extends GameElement {
        private static final String USERDEFINED = "arrangement.userdefined";

        public UserDefinedArrangement() {
            super(USERDEFINED, USERDEFINED, false);
        }
    }
}

