/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigStateDialog;
import hgb.gui.config.HGBaseConfigTextField;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tjger.game.completed.GameConfig;

public class NetworkDlg
extends HGBaseConfigStateDialog {
    private HGBaseConfigTextField tfPort;

    public NetworkDlg(HGBaseFrame mainFrame) {
        super(mainFrame, HGBaseText.getText("settings.network", new String[0]).replace('.', ' '));
    }

    @Override
    protected boolean canLeave() {
        int port;
        this.setMessage(null, 1);
        if (this.tfPort != null && ((port = HGBaseTools.toInt(this.tfPort.getValue())) < 1 || port > 65535)) {
            this.setErrorMessage(HGBaseText.getText("err.networkport", new String[0]));
            return false;
        }
        return true;
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        final GameConfig config = GameConfig.getInstance();
        JPanel pnNet = new JPanel(new GridLayout(1, 1));
        JPanel pnPort = new JPanel(new FlowLayout(0));
        pnPort.add(new JLabel(HGBaseText.getText("dlg.networkport", new String[0]) + "    "));
        this.tfPort = new HGBaseConfigTextField("game.networkport");
        this.tfPort.setValue(String.valueOf(config.getNetworkPort()));
        this.tfPort.addCaretListener(this);
        this.tfPort.setPreferredSize(new Dimension(120, HGBaseGuiTools.getFieldHeight()));
        pnPort.add(this.tfPort);
        JButton btResetPort = new JButton(HGBaseText.getText("dlg.networkreset", new String[0]));
        btResetPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                NetworkDlg.this.tfPort.setValue(String.valueOf(config.getNetworkDefaultPort()));
            }
        });
        pnPort.add(btResetPort);
        pnNet.add(pnPort);
        pnDialog.add((Component)pnNet, "North");
        pnDialog.add((Component)new JLabel(" "), "Center");
    }
}

