/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.config.HGBaseConfigColorChooser;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import tjger.game.completed.GameConfig;
import tjger.gui.GamePanel;
import tjger.gui.completed.Arrangement;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.Cover;
import tjger.gui.completed.GameElement;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.PieceSet;
import tjger.gui.internal.GameDialogFactory;
import tjger.gui.internal.GameElementsDlg;

public class PartsDlg
extends GameElementsDlg<Arrangement> {
    private static final String MSG_SETTINGS_PARTS_DLG_TITLE = "settings.parts";
    private static final int BUTTON_WIDTH = 24;
    private static final int PREVIEW_WIDTH = LABEL_WIDTH + COMBO_WIDTH;
    private static final int PREVIEW_HEIGHT = (int)((double)PREVIEW_WIDTH * 0.6);
    private final String[] cardSetTypes;
    private final String[] userPartSets;
    private final String[] userParts;
    private final String[] colorTypes;
    private JButton btBackColor;
    private Color backgroundColor;
    private GamePanel pnPreview;

    public PartsDlg(HGBaseFrame mainFrame) {
        super(mainFrame, HGBaseText.getText(MSG_SETTINGS_PARTS_DLG_TITLE, new String[0]).replace('.', ' '), "game.arrangement");
        GameConfig config = GameConfig.getInstance();
        this.cardSetTypes = config.getCardSetTypes();
        this.userPartSets = config.getPartSetTypes();
        this.userParts = config.getPartTypes();
        this.colorTypes = config.getColorTypes();
        this.btBackColor = null;
        this.backgroundColor = null;
        this.pnPreview = null;
    }

    @Override
    protected boolean isCompleteArrangement() {
        GameConfig config = GameConfig.getInstance();
        return config.isCompleteArrangement() && config.getArrangements().length > 0;
    }

    @Override
    protected List<HGBaseConfigItem> loadConfigItems() {
        GameConfig config = GameConfig.getInstance();
        ArrayList<HGBaseConfigItem> configItems = new ArrayList<HGBaseConfigItem>();
        this.addArrangements(configItems, config);
        this.addBackgrounds(configItems, config);
        this.addBoards(configItems, config);
        this.addCovers(configItems, config);
        this.addCardSets(configItems, config);
        this.addPieseSets(configItems, config);
        this.addPartSets(configItems, config);
        this.addParts(configItems, config);
        this.addColorChoosers(configItems, config);
        return configItems;
    }

    private void addArrangements(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.arrangement", config.getArrangements(), config.getActiveArrangement()));
    }

    private void addBackgrounds(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.background", config.getBackgrounds(), config.getActiveBackground()));
    }

    private void addBoards(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.board", config.getBoards(), config.getActiveBoard()));
    }

    private void addCovers(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.cover", config.getCovers(), config.getActiveCover()));
    }

    private void addCardSets(List<HGBaseConfigItem> configItems, GameConfig config) {
        Arrays.asList(this.cardSetTypes).forEach(cardSetType -> {
            boolean bl = configItems.add(this.createGameElementComboBox((String)cardSetType, config.getCardSets((String)cardSetType), config.getActiveCardSet((String)cardSetType)));
        });
    }

    private void addPieseSets(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.pieceset", config.getPieceSets(), config.getActivePieceSet()));
    }

    private void addPartSets(List<HGBaseConfigItem> configItems, GameConfig config) {
        Arrays.asList(this.userPartSets).forEach(partSetType -> {
            boolean bl = configItems.add(this.createGameElementComboBox((String)partSetType, config.getPartSets((String)partSetType), config.getActivePartSet((String)partSetType)));
        });
    }

    private void addParts(List<HGBaseConfigItem> configItems, GameConfig config) {
        Arrays.asList(this.userParts).forEach(partType -> {
            boolean bl = configItems.add(this.createGameElementComboBox((String)partType, config.getParts((String)partType), config.getActivePart((String)partType)));
        });
    }

    private void addColorChoosers(List<HGBaseConfigItem> configItems, GameConfig config) {
        Arrays.asList(this.colorTypes).forEach(colorType -> {
            boolean bl = configItems.add(this.createColorChooser((String)colorType, config.getDefaultColor((String)colorType), config.getActiveColor((String)colorType)));
        });
    }

    @Override
    protected void onArrangementChanged() {
        super.onArrangementChanged();
        this.refreshPreview();
    }

    @Override
    protected void onGameElementComboBoxChanged(GameElementsDlg.GameElementComboBox combobox) {
        super.onGameElementComboBoxChanged(combobox);
        if ("game.background".equals(combobox.getOption())) {
            this.backgroundColor = null;
            this.enableBackColorButton((Background)combobox.getSelectedItem());
        }
        this.refreshPreview();
    }

    private void enableBackColorButton(Background background) {
        if (background == null || this.btBackColor == null) {
            return;
        }
        this.btBackColor.setEnabled(!background.isFixedColor() && background.getColor() != null);
    }

    private HGBaseConfigColorChooser createColorChooser(String colorType, Color defaultColor, Color activeColor) {
        HGBaseConfigColorChooser chooser = new HGBaseConfigColorChooser(colorType, defaultColor);
        if (activeColor != null) {
            chooser.setColor(activeColor);
        }
        chooser.addActionListener(ev -> this.testArrangementModified());
        chooser.getLabel().setPreferredSize(new Dimension(COMBO_WIDTH, HGBaseGuiTools.getFieldHeight()));
        chooser.getButton().setPreferredSize(new Dimension(24, HGBaseGuiTools.getFieldHeight()));
        return chooser;
    }

    @Override
    protected JPanel createNorthPanel(GameConfig config) {
        JPanel panel = this.createConfigItemsPanel(config, this.configItemList);
        panel.add(new JLabel());
        return panel;
    }

    protected GamePanel createPreviewPanel() {
        this.pnPreview = GameDialogFactory.getInstance().createGameDialogs().getPreviewPanel(this, PREVIEW_WIDTH, PREVIEW_HEIGHT);
        if (this.pnPreview != null) {
            this.pnPreview.setPreferredSize(new Dimension(PREVIEW_WIDTH, PREVIEW_HEIGHT));
            this.pnPreview.setBorder(new LineBorder(Color.BLACK, 1));
        }
        return this.pnPreview;
    }

    private void refreshPreview() {
        if (this.pnPreview == null) {
            return;
        }
        this.pnPreview.repaint();
    }

    @Override
    protected JPanel createCenterPanel(GameConfig config) {
        return this.createPreviewPanel();
    }

    @Override
    protected List<Component> getConfigItemPanelComponents(GameConfig config, HGBaseConfigItem configItem) {
        List<Component> components = super.getConfigItemPanelComponents(config, configItem);
        if ("game.background".equals(configItem.getOption())) {
            components.add(this.createBackgroundColorButton());
        }
        return components;
    }

    private JButton createBackgroundColorButton() {
        this.btBackColor = new JButton("...");
        this.btBackColor.setPreferredSize(new Dimension(24, HGBaseGuiTools.getFieldHeight()));
        this.btBackColor.addActionListener(ev -> {
            Background background = this.getSelectedBackground();
            if (background == null || background.getColor() == null) {
                return;
            }
            Color color = JColorChooser.showDialog(this.getMainFrame(), HGBaseText.getText("dlg.choosecolor", new String[0]), background.getOriginalColor());
            if (color != null) {
                this.backgroundColor = color;
                this.refreshPreview();
            }
        });
        this.enableBackColorButton(this.getSelectedBackground());
        return this.btBackColor;
    }

    private HGBaseConfigColorChooser getColorChooser(String type) {
        HGBaseConfigItem configItem = this.getConfigItem(type);
        if (configItem instanceof HGBaseConfigColorChooser) {
            return (HGBaseConfigColorChooser)configItem;
        }
        return null;
    }

    private Color getSelectedColorChooserValue(String type) {
        HGBaseConfigColorChooser colorChooser = this.getColorChooser(type);
        return colorChooser != null ? colorChooser.getColor(true) : null;
    }

    public Color getSelectedBackgroundColor() {
        return this.backgroundColor;
    }

    private Background getSelectedBackground() {
        return (Background)this.getSelectedComboboxValue("game.background");
    }

    private Board getSelectedBoard() {
        return (Board)this.getSelectedComboboxValue("game.board");
    }

    private PieceSet getSelectedPieceSet() {
        return (PieceSet)this.getSelectedComboboxValue("game.pieceset");
    }

    private Cover getSelectedCover() {
        return (Cover)this.getSelectedComboboxValue("game.cover");
    }

    private CardSet getSelectedCardSet(String type) {
        return (CardSet)this.getSelectedComboboxValue(type);
    }

    private PartSet getSelectedPartSet(String type) {
        return (PartSet)this.getSelectedComboboxValue(type);
    }

    private Part getSelectedPart(String type) {
        return (Part)this.getSelectedComboboxValue(type);
    }

    private Color getSelectedColor(String type) {
        return this.getSelectedColorChooserValue(type);
    }

    private boolean isCardSet(String type) {
        return Arrays.asList(this.cardSetTypes).contains(type);
    }

    private boolean isUserPartSet(String type) {
        return Arrays.asList(this.userPartSets).contains(type);
    }

    private boolean isUserPart(String type) {
        return Arrays.asList(this.userParts).contains(type);
    }

    private boolean isColor(String type) {
        return Arrays.asList(this.colorTypes).contains(type);
    }

    @Override
    protected Set<String> getArrangementTypes() {
        return Arrays.stream(GameConfig.getInstance().getArrangements()).flatMap(arrangement -> arrangement.getTypes().stream()).collect(Collectors.toSet());
    }

    @Override
    protected Object getArrangementValue(Arrangement arrangement, String type) {
        switch (type) {
            case "game.background": {
                return arrangement.getBackground();
            }
            case "game.board": {
                return arrangement.getBoard();
            }
            case "game.pieceset": {
                return arrangement.getPieceSet();
            }
            case "game.cover": {
                return arrangement.getCover();
            }
        }
        if (this.isCardSet(type)) {
            return arrangement.getCardSet(type);
        }
        if (this.isUserPartSet(type)) {
            return arrangement.getPartSet(type);
        }
        if (this.isUserPart(type)) {
            return arrangement.getPart(type);
        }
        if (this.isColor(type)) {
            return arrangement.getColor(type);
        }
        return null;
    }

    protected Arrangement[] getAvailableArrangements() {
        return GameConfig.getInstance().getArrangements();
    }

    @Override
    protected boolean isArrangementElement(Arrangement arrangement, String type) {
        switch (type) {
            case "game.background": {
                return this.isArrangementElement((GameElement)arrangement.getBackground(), this.getSelectedBackground());
            }
            case "game.board": {
                return this.isArrangementElement((GameElement)arrangement.getBoard(), this.getSelectedBoard());
            }
            case "game.pieceset": {
                return this.isArrangementElement((GameElement)arrangement.getPieceSet(), this.getSelectedPieceSet());
            }
            case "game.cover": {
                return this.isArrangementElement((GameElement)arrangement.getCover(), this.getSelectedCover());
            }
        }
        if (this.isCardSet(type)) {
            return this.isArrangementElement((GameElement)arrangement.getCardSet(type), this.getSelectedCardSet(type));
        }
        if (this.isUserPartSet(type)) {
            return this.isArrangementElement((GameElement)arrangement.getPartSet(type), this.getSelectedPartSet(type));
        }
        if (this.isUserPart(type)) {
            return this.isArrangementElement((GameElement)arrangement.getPart(type), this.getSelectedPart(type));
        }
        if (this.isColor(type)) {
            return Objects.equals(arrangement.getColor(type), this.getSelectedColor(type));
        }
        return false;
    }

    @Override
    protected void setConfigItemValue(String type, Object value) {
        HGBaseConfigItem configItem = this.getConfigItem(type);
        if (configItem instanceof GameElementsDlg.GameElementComboBox) {
            ((GameElementsDlg.GameElementComboBox)configItem).setSelectedItem(value);
        } else if (configItem instanceof HGBaseConfigColorChooser && value instanceof Color) {
            ((HGBaseConfigColorChooser)configItem).setColor((Color)value);
        }
    }

    @Override
    protected Object getConfigItemValue(String type) {
        HGBaseConfigItem configItem = this.getConfigItem(type);
        if (configItem instanceof GameElementsDlg.GameElementComboBox) {
            return ((GameElementsDlg.GameElementComboBox)configItem).getSelectedItem();
        }
        if (configItem instanceof HGBaseConfigColorChooser) {
            return ((HGBaseConfigColorChooser)configItem).getColor();
        }
        return null;
    }

    @Override
    protected void okPressed() {
        super.okPressed();
        this.saveBackgroundColor();
    }

    private void saveBackgroundColor() {
        if (this.backgroundColor == null) {
            return;
        }
        Background background = this.getSelectedBackground();
        if (background == null) {
            return;
        }
        HGBaseConfig.set("game.backcolor." + background.getName(), this.backgroundColor.getRGB());
    }

    public Function<String, Object> getPartSupplier() {
        return type -> {
            if ("game.backcolor.".equals(type)) {
                return this.getSelectedColor((String)type);
            }
            return this.getSelectedComboboxValue((String)type);
        };
    }
}

