/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Arrays;
import javax.swing.ImageIcon;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.gui.GamePanel;
import tjger.gui.completed.Background;
import tjger.gui.completed.Board;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.Cover;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.PieceSet;
import tjger.gui.internal.PartsDlg;

public class PreviewPanel
extends GamePanel {
    private static final long serialVersionUID = 8788760516686439870L;
    protected int distance = 10;
    protected int panelWidth;
    protected int panelHeight;
    private final GameConfig config;
    protected String[] cardSetTypes;
    protected PartsDlg partsDlg;
    protected String[] userParts;
    protected String[] userPartSets;

    public PreviewPanel(PartsDlg partsDlg, int width, int height) {
        this.partsDlg = partsDlg;
        this.panelWidth = width;
        this.panelHeight = height;
        this.config = GameManager.getInstance().getGameConfig();
        this.cardSetTypes = this.config.getCardSetTypes();
        this.userParts = this.config.getPartTypes();
        this.userPartSets = this.config.getPartSetTypes();
    }

    protected Color getSelectedBackgroundColor() {
        return (Color)this.partsDlg.getPartSupplier().apply("game.backcolor.");
    }

    protected Background getSelectedBackground() {
        return (Background)this.partsDlg.getPartSupplier().apply("game.background");
    }

    protected Board getSelectedBoard() {
        return (Board)this.partsDlg.getPartSupplier().apply("game.board");
    }

    protected Cover getSelectedCover() {
        return (Cover)this.partsDlg.getPartSupplier().apply("game.cover");
    }

    protected CardSet getSelectedCardSet(String type) {
        return (CardSet)this.partsDlg.getPartSupplier().apply(type);
    }

    protected PartSet getSelectedPartSet(String type) {
        return (PartSet)this.partsDlg.getPartSupplier().apply(type);
    }

    protected Part getSelectedPart(String type) {
        return (Part)this.partsDlg.getPartSupplier().apply(type);
    }

    protected PieceSet getSelectedPieceSet() {
        return (PieceSet)this.partsDlg.getPartSupplier().apply("game.pieceset");
    }

    protected Color getSelectedColor(String type) {
        return (Color)this.partsDlg.getPartSupplier().apply(type);
    }

    @Override
    protected void paintBackground(Graphics g) {
        if (this.getSelectedBackgroundColor() != null) {
            g.setColor(this.getSelectedBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        } else {
            this.paintBackground(this.getSelectedBackground(), g);
        }
    }

    @Override
    protected void paintBoard(Graphics g) {
        this.paintBoard(this.getSelectedBoard(), g);
    }

    @Override
    protected void paintParts(Graphics g) {
        this.paintStandardParts(g);
        this.paintUserParts(g);
    }

    protected void paintStandardParts(Graphics g) {
        int[] x = new int[]{this.distance};
        int y = 10;
        x[0] = this.drawPartAndAdvanceX(x[0], y, this.getSelectedCover(), g);
        Arrays.stream(this.cardSetTypes).forEach(type -> {
            int n2 = this.drawPartAndAdvanceX(x[0], y, this.getSelectedCardSet((String)type), g);
        });
        this.drawPartAndAdvanceX(x[0], y, this.getSelectedPieceSet(), g);
    }

    protected void paintUserParts(Graphics g) {
        int[] x = new int[]{this.distance};
        int y = this.getFieldHeight() / 2;
        Arrays.stream(this.userPartSets).forEach(partSetType -> {
            int n2 = this.drawPartAndAdvanceX(x[0], y, this.getSelectedPartSet((String)partSetType), g);
        });
        Arrays.stream(this.userParts).forEach(partType -> {
            int n2 = this.drawPartAndAdvanceX(x[0], y, this.getSelectedPart((String)partType), g);
        });
    }

    private int drawPartAndAdvanceX(int x, int y, Part part, Graphics g) {
        if (part == null) {
            return x;
        }
        ImageIcon img = part.getImage();
        if (img == null) {
            return x;
        }
        this.drawPart(x, y, part, g);
        return x + this.distance + img.getIconWidth();
    }

    @Override
    public double getZoomFactor() {
        double wz = (double)this.panelWidth / (double)this.getFieldWidth();
        double hz = (double)this.panelHeight / (double)this.getFieldHeight();
        return Math.min(wz, hz);
    }

    @Override
    public int getFieldWidth() {
        return this.config.getFieldWidth(this.getSelectedBoard(), this.getSelectedBackground());
    }

    @Override
    public int getFieldHeight() {
        return this.config.getFieldHeight(this.getSelectedBoard(), this.getSelectedBackground());
    }
}

