/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseText;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tjger.game.completed.GameConfig;
import tjger.game.completed.SoundUtil;
import tjger.gui.completed.Sound;
import tjger.gui.completed.SoundArrangement;
import tjger.gui.completed.SoundSet;
import tjger.gui.internal.GameElementsDlg;

public class SoundsDlg
extends GameElementsDlg<SoundArrangement> {
    private static final String MSG_SETTINGS_SOUNDS_DLG_TITLE = "settings.sounds";
    private static final String MSG_PLAY_SOUNDSET_DLG_TITLE = "dlg.playsoundsetsoundtitle";
    private static final String MSG_NO_SOUND = "settings.nosound";
    private final String[] userSounds;
    private final String[] userSoundSets;

    public SoundsDlg(HGBaseFrame mainFrame) {
        super(mainFrame, HGBaseText.getText(MSG_SETTINGS_SOUNDS_DLG_TITLE, new String[0]).replace('.', ' '), "game.soundarrangement");
        GameConfig config = GameConfig.getInstance();
        this.userSounds = config.getSoundTypes();
        this.userSoundSets = config.getSoundSetTypes();
    }

    @Override
    protected boolean isCompleteArrangement() {
        GameConfig config = GameConfig.getInstance();
        return config.isCompleteSoundArrangement() && config.getSoundArrangements().length > 0;
    }

    @Override
    protected List<HGBaseConfigItem> loadConfigItems() {
        GameConfig config = GameConfig.getInstance();
        ArrayList<HGBaseConfigItem> configItems = new ArrayList<HGBaseConfigItem>();
        this.addArrangements(configItems, config);
        this.addUserSoundSets(configItems, config);
        this.addUserSounds(configItems, config);
        return configItems;
    }

    @Override
    protected JPanel createNorthPanel(GameConfig config) {
        return this.createEnableSoundsPanel();
    }

    @Override
    protected List<Component> getConfigItemPanelComponents(GameConfig config, HGBaseConfigItem configItem) {
        List<Component> components = super.getConfigItemPanelComponents(config, configItem);
        if (configItem instanceof GameElementsDlg.GameElementComboBox && !this.isArrangementCombobox((GameElementsDlg.GameElementComboBox)configItem)) {
            components.add(this.createComboboxPlayButton(config, (GameElementsDlg.GameElementComboBox)configItem));
        }
        return components;
    }

    @Override
    protected Set<String> getArrangementTypes() {
        return Arrays.stream(GameConfig.getInstance().getSoundArrangements()).flatMap(arrangement -> arrangement.getTypes().stream()).collect(Collectors.toSet());
    }

    @Override
    protected Object getArrangementValue(SoundArrangement arrangement, String type) {
        if (Arrays.asList(this.userSounds).contains(type)) {
            return arrangement.getSound(type);
        }
        if (Arrays.asList(this.userSoundSets).contains(type)) {
            return arrangement.getSoundSet(type);
        }
        return null;
    }

    protected SoundArrangement[] getAvailableArrangements() {
        return GameConfig.getInstance().getSoundArrangements();
    }

    @Override
    protected boolean isArrangementElement(SoundArrangement arrangement, String type) {
        if (this.isUserSoundSet(type)) {
            return Objects.equals(arrangement.getSoundSet(type), this.getSelectedSoundSet(type));
        }
        if (this.isUserSound(type)) {
            return Objects.equals(arrangement.getSound(type), this.getSelectedSound(type));
        }
        return false;
    }

    @Override
    protected void setConfigItemValue(String type, Object value) {
        HGBaseConfigItem configItem = this.getConfigItem(type);
        if (configItem instanceof GameElementsDlg.GameElementComboBox) {
            ((GameElementsDlg.GameElementComboBox)configItem).setSelectedItem(value);
        }
    }

    protected JPanel createEnableSoundsPanel() {
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(new HGBaseConfigCheckBox(MSG_NO_SOUND, "nosound"));
        return panel;
    }

    protected void addArrangements(List<HGBaseConfigItem> configItems, GameConfig config) {
        configItems.add(this.createGameElementComboBox("game.soundarrangement", config.getSoundArrangements(), config.getActiveSoundArrangement()));
    }

    protected void addUserSoundSets(List<HGBaseConfigItem> configItems, GameConfig config) {
        Set.of(this.userSoundSets).forEach(userSoundSetType -> {
            boolean bl = configItems.add(this.createGameElementComboBox((String)userSoundSetType, config.getSoundSets((String)userSoundSetType), config.getActiveSoundSet((String)userSoundSetType)));
        });
    }

    protected void addUserSounds(List<HGBaseConfigItem> configItems, GameConfig config) {
        Set.of(this.userSounds).forEach(userSoundType -> {
            boolean bl = configItems.add(this.createGameElementComboBox((String)userSoundType, config.getSounds((String)userSoundType), config.getActiveSound((String)userSoundType)));
        });
    }

    protected JButton createComboboxPlayButton(GameConfig config, GameElementsDlg.GameElementComboBox combobox) {
        return this.createPlayButton(ev -> {
            Object selectedItem = combobox.getSelectedItem();
            if (selectedItem instanceof SoundSet) {
                HGBaseDialog.showOkDialog(this.getMainFrame(), this.createPlaySoundSetSoundsPanel(config, (SoundSet)selectedItem), HGBaseText.getText(MSG_PLAY_SOUNDSET_DLG_TITLE, new String[0]));
            } else if (selectedItem instanceof Sound) {
                SoundUtil.playSound((Sound)selectedItem);
            }
        });
    }

    protected JButton createSoundPlayButton(Sound sound) {
        return this.createPlayButton(ev -> SoundUtil.playSound(sound));
    }

    protected JButton createPlayButton(ActionListener actionListener) {
        JButton button = new JButton(HGBaseGuiTools.loadImage("/tjger/gui/gfx/play.png"));
        button.addActionListener(actionListener);
        button.setBorderPainted(false);
        button.setContentAreaFilled(false);
        return button;
    }

    protected JPanel createPlaySoundSetSoundsPanel(GameConfig config, SoundSet soundSet) {
        JPanel panel = new JPanel(new GridLayout(0, 1));
        soundSet.getSounds().forEach(sound -> {
            Component component = panel.add(this.createPlaySoundSetSoundPanel((Sound)sound));
        });
        return panel;
    }

    protected JPanel createPlaySoundSetSoundPanel(Sound sound) {
        JPanel panel = new JPanel(new FlowLayout());
        panel.add(this.createLabel(HGBaseText.getText(sound.getName(), new String[0]) + " " + sound.getSequence()));
        panel.add(this.createSoundPlayButton(sound));
        return panel;
    }

    private boolean isUserSoundSet(String type) {
        return Arrays.asList(this.userSoundSets).contains(type);
    }

    private boolean isUserSound(String type) {
        return Arrays.asList(this.userSounds).contains(type);
    }

    private SoundSet getSelectedSoundSet(String type) {
        return (SoundSet)this.getSelectedComboboxValue(type);
    }

    private Sound getSelectedSound(String type) {
        return (Sound)this.getSelectedComboboxValue(type);
    }

    @Override
    protected Object getConfigItemValue(String type) {
        return Optional.ofNullable(this.getConfigItem(type)).filter(GameElementsDlg.GameElementComboBox.class::isInstance).map(GameElementsDlg.GameElementComboBox.class::cast).map(JComboBox::getSelectedItem).orElse(null);
    }
}

