/*
 * Decompiled with CFR 0.152.
 */
package tjger.gui.internal;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseItem;
import hgb.gui.menu.HGBaseMenuRadioButton;
import hgb.gui.menu.HGBaseSubMenu;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JViewport;
import tjger.MainMenu;
import tjger.game.completed.GameConfig;

public class ZoomMenu {
    public static final String ZOOMMENU_ENTRY = "zoom";
    public static final String ZOOMMENU_FITHEIGHT = "fitheight";
    public static final String ZOOMMENU_FITWIDTH = "fitwidth";
    public static final String ZOOMMENU_FITOPTIMAL = "fitoptimal";
    public static final String ZOOMMENU_ZOOMOUT = "zoomout";
    public static final String ZOOMMENU_ZOOMIN = "zoomin";
    public static final String ZOOMMENU_VARIABLE = "variable";
    public static final String ZOOMMENU_FITWINDOW = "fitwindow";
    public static final String ZOOMMENU_PREFIX = "zoom.";
    private final GameConfig gameConfig;
    private final MainMenu mainMenu;
    private final HGBaseSubMenu mainZoomMenu;
    private int currentZoom;

    public ZoomMenu(MainMenu mainMenu) {
        this.mainMenu = mainMenu;
        this.mainZoomMenu = this.findZoomMenu(mainMenu);
        this.gameConfig = GameConfig.getInstance();
        this.currentZoom = this.gameConfig.getActiveZoom();
        this.selectMenuEntry();
        this.testMenuEntries();
    }

    private HGBaseSubMenu findZoomMenu(MainMenu mainMenu) {
        JComponent cZoom = mainMenu.getMenuItem(ZOOMMENU_ENTRY);
        if (cZoom instanceof HGBaseSubMenu) {
            return (HGBaseSubMenu)cZoom;
        }
        return null;
    }

    public boolean hasEntries() {
        return this.mainZoomMenu != null && this.mainZoomMenu.getMenuComponentCount() > 0;
    }

    public HGBaseSubMenu getMenu() {
        return this.mainZoomMenu;
    }

    public void onAction(String id, ActionEvent e) {
        if (this.mainZoomMenu != null) {
            String entry = id.replaceFirst(ZOOMMENU_PREFIX, "");
            if (entry.equals(ZOOMMENU_FITWINDOW)) {
                this.onFitWindow();
                this.testMenuEntries();
            } else if (!HGBaseConfig.getBoolean("zoom.fitwindow")) {
                int newZoom = HGBaseTools.toInt(entry);
                if (newZoom != -2147483631) {
                    this.setZoom(newZoom);
                } else if (entry.equals(ZOOMMENU_VARIABLE)) {
                    this.onZoomVariable();
                } else if (entry.equals(ZOOMMENU_ZOOMIN)) {
                    this.onZoomIn();
                } else if (entry.equals(ZOOMMENU_ZOOMOUT)) {
                    this.onZoomOut();
                } else if (entry.equals(ZOOMMENU_FITWIDTH)) {
                    this.onFitWidth();
                } else if (entry.equals(ZOOMMENU_FITHEIGHT)) {
                    this.onFitHeight();
                } else if (entry.equals(ZOOMMENU_FITOPTIMAL)) {
                    this.onFitOptimal();
                }
            }
        }
    }

    private void testMenuEntries() {
        if (this.mainZoomMenu != null) {
            boolean fitWindow = HGBaseConfig.getBoolean("zoom.fitwindow");
            Component[] cEntry = this.mainZoomMenu.getMenuComponents();
            int i = 0;
            while (i < cEntry.length) {
                String id;
                if (cEntry[i] instanceof HGBaseItem && (id = ((HGBaseItem)((Object)cEntry[i])).getId()).startsWith(ZOOMMENU_PREFIX) && !id.equals("zoom.fitwindow")) {
                    cEntry[i].setEnabled(!fitWindow);
                }
                ++i;
            }
        }
    }

    public void onFitWindow() {
        int newZoom;
        int oldZoom;
        boolean fitWindow = HGBaseConfig.getBoolean("zoom.fitwindow");
        if (fitWindow && (oldZoom = this.getZoom()) != (newZoom = this.getFitWindowZoom())) {
            this.setZoom(newZoom);
        }
    }

    public int getZoom() {
        return this.currentZoom;
    }

    public void setZoom(int newZoom) {
        int oldZoom = this.getZoom();
        if (newZoom < this.gameConfig.getMinZoom()) {
            newZoom = this.gameConfig.getMinZoom();
        }
        if (newZoom > this.gameConfig.getMaxZoom()) {
            newZoom = this.gameConfig.getMaxZoom();
        }
        if (oldZoom != newZoom) {
            this.currentZoom = newZoom;
            HGBaseConfig.set("game.zoom", this.getZoom());
            this.selectMenuEntry();
            this.mainMenu.refreshMainPanel();
            this.mainMenu.onZoomChanged();
        }
    }

    private void selectMenuEntry() {
        if (this.mainZoomMenu != null) {
            boolean found = false;
            AbstractButton variable = null;
            Component[] cEntry = this.mainZoomMenu.getMenuComponents();
            int i = 0;
            while (i < cEntry.length && !found) {
                if (cEntry[i] instanceof HGBaseMenuRadioButton) {
                    HGBaseMenuRadioButton item = (HGBaseMenuRadioButton)cEntry[i];
                    String entry = item.getId().replaceFirst(ZOOMMENU_PREFIX, "");
                    if (entry.equals(ZOOMMENU_VARIABLE)) {
                        variable = item;
                    } else {
                        int zoom = HGBaseTools.toInt(entry);
                        if (zoom == this.getZoom()) {
                            item.setSelected(true);
                            found = true;
                        }
                    }
                }
                ++i;
            }
            if (!found && variable != null) {
                variable.setSelected(true);
            }
        }
    }

    private void onZoomVariable() {
        int oldZoom = this.getZoom();
        JPanel pnZoom = new JPanel(new FlowLayout(0));
        JLabel lbZoom = new JLabel(HGBaseText.getText(ZOOMMENU_ENTRY, new String[0]) + ": ");
        JComboBox<Integer> cbZoom = HGBaseGuiTools.createRangeComboBox(this.gameConfig.getMinZoom(), this.gameConfig.getMaxZoom(), 1, 120, HGBaseGuiTools.getFieldHeight());
        try {
            cbZoom.setSelectedItem(oldZoom);
        }
        catch (Exception exception) {
            // empty catch block
        }
        pnZoom.add(lbZoom);
        pnZoom.add(cbZoom);
        Object[] message = new Object[]{pnZoom};
        Object[] options = new String[]{HGBaseText.getText("dlg.ok", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
        int result = HGBaseDialog.showOptionDialog(this.mainMenu.getMainFrame(), (Object)message, HGBaseText.getText("zoom.variable", new String[0]).replace('.', ' '), -1, -1, null, options, 0);
        if (result == 0) {
            int newZoom = (Integer)cbZoom.getSelectedItem();
            if (newZoom != oldZoom) {
                this.setZoom(newZoom);
            }
        } else {
            this.setZoom(oldZoom);
        }
    }

    private void onZoomIn() {
        this.setZoom((int)((double)this.getZoom() * 1.2));
    }

    private void onZoomOut() {
        this.setZoom((int)((double)this.getZoom() * 0.8));
    }

    private int getFitWindowZoom() {
        int newZoom = this.getBestZoomHeight();
        int zoomW = this.getBestZoomWidth();
        if (zoomW < newZoom) {
            newZoom = zoomW;
        }
        return newZoom;
    }

    private void onFitOptimal() {
        int oldZoom = this.getZoom();
        int newZoom = this.getFitWindowZoom();
        if (newZoom > this.gameConfig.getStandardZoom()) {
            newZoom = this.gameConfig.getStandardZoom();
        }
        if (oldZoom != newZoom) {
            this.setZoom(newZoom);
        }
    }

    private int getBestZoomWidth() {
        int scrollW = 15;
        JViewport viewport = this.mainMenu.getTjgerMainFrame().getMainPanel().getViewport();
        int zoomW = (int)(100.0 * this.calculateRelative(viewport.getWidth(), this.gameConfig.getFieldWidth()));
        int zoomH = (int)(100.0 * this.calculateRelative(viewport.getHeight(), this.gameConfig.getFieldHeight()));
        if (zoomH < zoomW) {
            return 100 * (viewport.getWidth() - scrollW) / this.gameConfig.getFieldWidth();
        }
        return zoomW;
    }

    private double calculateRelative(int num1, int num2) {
        return num2 == 0 ? 1.0 : (double)num1 / (double)num2;
    }

    private int getBestZoomHeight() {
        int zoomH;
        int scrollW = 15;
        JViewport viewport = this.mainMenu.getTjgerMainFrame().getMainPanel().getViewport();
        int zoomW = (int)(100.0 * this.calculateRelative(viewport.getWidth(), this.gameConfig.getFieldWidth()));
        if (zoomW < (zoomH = (int)(100.0 * this.calculateRelative(viewport.getHeight(), this.gameConfig.getFieldHeight())))) {
            return 100 * (viewport.getHeight() - scrollW) / this.gameConfig.getFieldHeight();
        }
        return zoomH;
    }

    private void onFitWidth() {
        int newZoom;
        int oldZoom = this.getZoom();
        if (oldZoom != (newZoom = this.getBestZoomWidth())) {
            this.setZoom(newZoom);
        }
    }

    private void onFitHeight() {
        int newZoom;
        int oldZoom = this.getZoom();
        if (oldZoom != (newZoom = this.getBestZoomHeight())) {
            this.setZoom(newZoom);
        }
    }
}

