/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import tjger.game.GamePlayer;
import tjger.game.completed.PlayerType;
import tjger.gui.completed.Card;
import tjger.gui.completed.GameElement;
import tjger.gui.completed.Part;
import tjger.gui.completed.Piece;
import tjger.gui.completed.SoundSet;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static GamePlayer[] toGamePlayer(List<GamePlayer> list) {
        if (list == null) {
            return new GamePlayer[0];
        }
        return list.toArray(new GamePlayer[0]);
    }

    public static PlayerType[] toPlayerType(List<PlayerType> list) {
        if (list == null) {
            return new PlayerType[0];
        }
        return list.toArray(new PlayerType[0]);
    }

    public static String[] toPlayerTypeIds(PlayerType[] list) {
        String[] strLines = new String[list.length];
        int i = 0;
        while (i < strLines.length) {
            strLines[i] = list[i].getId();
            ++i;
        }
        return strLines;
    }

    public static Card[] toCard(List<Card> list) {
        if (list == null) {
            return new Card[0];
        }
        return list.toArray(new Card[0]);
    }

    public static Piece[] toPiece(List<Piece> list) {
        if (list == null) {
            return new Piece[0];
        }
        return list.toArray(new Piece[0]);
    }

    public static String[] toPartNames(Part[] list) {
        String[] strLines = new String[list.length];
        int i = 0;
        while (i < strLines.length) {
            strLines[i] = list[i].getName();
            ++i;
        }
        return strLines;
    }

    public static String[] toSoundSetNames(SoundSet[] list) {
        return (String[])Stream.of(list).map(GameElement::getName).toArray(String[]::new);
    }

    public static List<Card> toList(Card[] cards) {
        return new ArrayList<Card>(Arrays.asList(cards));
    }

    public static List<Piece> toList(Piece[] pieces) {
        return new ArrayList<Piece>(Arrays.asList(pieces));
    }
}

