/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import java.util.Date;
import java.util.Random;

public class DiceUtil {
    public static final int DEFAULT_MIN = 1;
    public static final int DEFAULT_MAX = 6;
    private static Random diceRandom = new Random(new Date().getTime());

    private DiceUtil() {
    }

    public static int throwDice() {
        return DiceUtil.throwDice(1, 6);
    }

    public static int throwDice(int min, int max) {
        if (min > max) {
            int h = min;
            min = max;
            max = h;
        }
        return diceRandom.nextInt(max - min + 1) + min;
    }

    public static long getLongValueInRange(long min, long max, long step) {
        long value = Math.abs(diceRandom.nextLong()) % (max - min + 1L) + min;
        if (step > 1L) {
            value = value / step * step;
        }
        return value;
    }

    public static int[] countValues(int minValue, int maxValue, int[] values) throws IllegalArgumentException {
        if (values == null || minValue < 0 || maxValue < 0 || maxValue < minValue) {
            throw new IllegalArgumentException();
        }
        int[] countValues = new int[maxValue - minValue + 1];
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int valueIndex;
            int value = nArray[n2];
            if (value < minValue || value > maxValue) {
                throw new IllegalArgumentException("Value is not between minimum and maximum value");
            }
            int n3 = valueIndex = value - minValue;
            countValues[n3] = countValues[n3] + 1;
            ++n2;
        }
        return countValues;
    }

    public static int[] countValues(int[] values) throws IllegalArgumentException {
        return DiceUtil.countValues(1, 6, values);
    }
}

