/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.gui.HGBaseFrame;
import hgb.lib.HGBaseTools;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import tjger.MainFrame;
import tjger.game.GamePlayer;
import tjger.game.GameState;
import tjger.game.GameStateListener;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;
import tjger.lib.MachineLearningPlayer;
import tjger.lib.ScoreUtil;

public class MachineLearner
implements GameStateListener {
    private boolean isFirstGame = true;
    private boolean machineLearningMode = false;
    private int maxTurnsBeforeRestart = 0;
    private Map<GamePlayer, WinCounter> currentPlayers = new LinkedHashMap<GamePlayer, WinCounter>();
    private static Random valueRandom = new Random(new Date().getTime());

    public MachineLearner(int maxTurnsBeforeRestart) {
        this.maxTurnsBeforeRestart = maxTurnsBeforeRestart;
    }

    @Override
    public void newGameStarted(GameState state, GameEngine engine) {
        this.initMachineLearning(engine);
    }

    protected void initMachineLearning(GameEngine engine) {
        GamePlayer[] players = engine.getActivePlayers();
        this.checkForMachineLearningMode(players);
        if (this.isMachineLearningMode()) {
            if (this.isFirstGame) {
                this.isFirstGame = false;
                int i = 0;
                while (i < players.length) {
                    ((MachineLearningPlayer)((Object)players[i])).changeInitialEvaluationValues(i);
                    this.currentPlayers.put(players[i], new WinCounter());
                    ++i;
                }
                GameConfig config = GameConfig.getInstance();
                config.setDelayMove(0);
                config.setDelayTurn(0);
                config.setDelayRound(0);
                config.setDelayPlayer(0);
                config.setDialogAfterTurn(false);
                config.setDialogAfterRound(false);
                config.setDialogAfterGame(false);
                config.setInterruptAfterRound(false);
            }
        } else {
            this.isFirstGame = true;
        }
    }

    protected void checkForMachineLearningMode(GamePlayer[] players) {
        this.machineLearningMode = false;
        if (players != null && players.length >= 2) {
            GamePlayer[] gamePlayerArray = players;
            int n = players.length;
            int n2 = 0;
            while (n2 < n) {
                GamePlayer p = gamePlayerArray[n2];
                if (!(p instanceof MachineLearningPlayer)) {
                    return;
                }
                ++n2;
            }
            this.machineLearningMode = true;
        }
    }

    protected boolean isMachineLearningMode() {
        return this.machineLearningMode;
    }

    protected GamePlayer[] getCurrentPlayers() {
        return this.currentPlayers.keySet().toArray(new GamePlayer[this.currentPlayers.size()]);
    }

    protected WinCounter getGamesWon(GamePlayer player) {
        return this.currentPlayers.get(player);
    }

    @Override
    public void gameFinished(boolean normal) {
        if (normal && this.isMachineLearningMode()) {
            GamePlayer[] players = this.currentPlayers.keySet().toArray(new GamePlayer[this.currentPlayers.size()]);
            int[] ranks = ScoreUtil.getScoreRanking(players, 4);
            players = ScoreUtil.getPlayersInRankingOrder(players, ranks);
            GamePlayer winner = players[0];
            GamePlayer loser = players[players.length - 1];
            if (winner.getScore(4) == loser.getScore(4)) {
                this.printGameResult("DRAW GAME");
            } else {
                WinCounter wonGames = this.getGamesWon(winner);
                wonGames.increaseWins();
                WinCounter wonGamesOfLoser = this.getGamesWon(loser);
                Object gameResultText = this.createGameResultsText(winner, wonGames, true);
                if (this.shallChangeEvaluationValuesOfLoser(wonGames, wonGamesOfLoser)) {
                    for (GamePlayer player : this.currentPlayers.keySet()) {
                        this.currentPlayers.get(player).resetCurrentWins();
                    }
                    wonGamesOfLoser.resetWins();
                    ((MachineLearningPlayer)((Object)loser)).changeEvaluationValuesOfLoser();
                    gameResultText = (String)gameResultText + "\n" + this.createGameResultsText(loser, wonGamesOfLoser, false);
                }
                this.printGameResult((String)gameResultText);
            }
            this.startNewGame();
        }
    }

    protected String createDrawGameText() {
        return "DRAW GAME";
    }

    protected String createGameResultsText(GamePlayer player, WinCounter wonGames, boolean isWinner) {
        StringBuilder text = new StringBuilder();
        text.append(isWinner ? "WINNER " : "LOSER ");
        text.append(player.toString()).append(" (").append(wonGames.getCurrentWins());
        text.append("/").append(wonGames.getTotalWins()).append(" games won): ");
        text.append(((MachineLearningPlayer)((Object)player)).toEvaluationValuesString());
        return text.toString();
    }

    protected boolean shallChangeEvaluationValuesOfLoser(WinCounter wonGamesOfWinner, WinCounter wonGamesOfLoser) {
        return wonGamesOfWinner.getCurrentWins() > (int)(((double)wonGamesOfLoser.getCurrentWins() + 0.5) * 2.0) || wonGamesOfWinner.getCurrentWins() - wonGamesOfLoser.getCurrentWins() >= 5;
    }

    protected void printGameResult(String message) {
        if (HGBaseTools.hasContent(message)) {
            System.out.println(message);
        }
    }

    @Override
    public void newTurnStarted(GameState state, GameEngine engine) {
        if (this.isMachineLearningMode() && this.maxTurnsBeforeRestart > 0 && engine.getCurrentTurn() > this.maxTurnsBeforeRestart) {
            this.startNewGame();
        }
    }

    private void startNewGame() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                HGBaseTools.delay(500L);
                ((MainFrame)HGBaseFrame.getInstance()).getMainMenu().onFileNext();
            }
        }).start();
    }

    @Override
    public void newRoundStarted(GameState state, GameEngine engine) {
    }

    @Override
    public void gameStateBeforeMove(GameState state, GameEngine engine) {
    }

    @Override
    public void gameStateAfterMove(GameState state, GameEngine engine) {
    }

    private static final class WinCounter {
        private int currentWins;
        private int totalWins;

        public int getCurrentWins() {
            return this.currentWins;
        }

        public int getTotalWins() {
            return this.totalWins;
        }

        public void increaseWins() {
            ++this.currentWins;
            ++this.totalWins;
        }

        public void resetWins() {
            this.currentWins = 0;
            this.totalWins = 0;
        }

        public void resetCurrentWins() {
            this.currentWins = 0;
        }
    }
}

