/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseStringBuilder;
import hgb.lib.HGBaseTools;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import tjger.game.completed.GameConfig;
import tjger.gui.completed.Card;
import tjger.gui.completed.CardSet;
import tjger.lib.ArrayUtil;

public class NetworkUtil {
    private NetworkUtil() {
    }

    public static String fromIntArray(int[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            msg.append(String.valueOf(element));
            ++n2;
        }
        return msg.toString();
    }

    public static int[] toIntArray(String msg) {
        if (msg.isEmpty() || msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        int[] values = new int[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = HGBaseTools.toInt(array[i]);
            ++i;
        }
        return values;
    }

    public static String fromBooleanArray(boolean[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean element = blArray[n2];
            msg.append(element ? "1" : "0");
            ++n2;
        }
        return msg.toString();
    }

    public static boolean[] toBooleanArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        boolean[] values = new boolean[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = array[i].equals("1");
            ++i;
        }
        return values;
    }

    public static String fromStringArray(String[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        String[] stringArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element != null) {
                msg.append(element);
            }
            ++n2;
        }
        return msg.toString();
    }

    public static String[] toStringArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] values = msg.split("/");
        int i = 0;
        while (i < values.length) {
            if (values[i].equals("^")) {
                values[i] = "^";
            }
            ++i;
        }
        return values;
    }

    public static String fromCardArray(Card[] array) {
        if (array == null) {
            return "^";
        }
        HGBaseStringBuilder msg = new HGBaseStringBuilder("/");
        Card[] cardArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Card card = cardArray[n2];
            msg.append(NetworkUtil.fromCard(card));
            ++n2;
        }
        return msg.toString();
    }

    public static String fromCardList(List<Card> cardList) {
        if (cardList == null) {
            return "^";
        }
        return NetworkUtil.fromCardArray(ArrayUtil.toCard(cardList));
    }

    public static String fromCard(Card card) {
        if (card == null) {
            return "^";
        }
        String type = card.getCardSet().getType();
        String data = card.getColor() + "-" + card.getSequence();
        if (!"game.cardset".equals(type)) {
            data = data + "-" + type;
        }
        return data;
    }

    public static Card[] toCardArray(String msg) {
        if (msg.equals("^")) {
            return null;
        }
        String[] array = msg.split("/");
        if (array.length == 1 && array[0].isEmpty()) {
            return new Card[0];
        }
        Card[] values = new Card[array.length];
        int i = 0;
        while (i < values.length) {
            values[i] = NetworkUtil.toCard(array[i]);
            ++i;
        }
        return values;
    }

    public static List<Card> toCardList(String msg) {
        Card[] cards = NetworkUtil.toCardArray(msg);
        return cards == null ? null : ArrayUtil.toList(cards);
    }

    public static Card toCard(String msg) {
        if (msg == null || msg.equals("^")) {
            return null;
        }
        String[] parts = msg.split("-");
        if (parts.length < 2) {
            return null;
        }
        String color = parts[0];
        int sequence = HGBaseTools.toInt(parts[1]);
        String type = parts.length >= 3 ? parts[2] : "game.cardset";
        CardSet set = GameConfig.getInstance().getActiveCardSet(type);
        if (set == null) {
            return null;
        }
        return set.getCard(color, sequence);
    }

    public static <T> String fromCollection(Collection<T> collection, Function<T, String> converter) {
        if (collection == null) {
            return "^";
        }
        return collection.stream().map(converter).collect(Collectors.joining("/"));
    }

    public static <T> Collection<T> toCollection(String msg, Function<String, T> converter) {
        if (msg == null || "^".equals(msg)) {
            return null;
        }
        return Arrays.stream(msg.split("/")).map(converter).collect(Collectors.toList());
    }

    public static <K, V> String fromMap(Map<K, V> map, Function<K, String> keyConverter, Function<V, String> valueConverter) {
        if (map == null) {
            return "^";
        }
        return map.entrySet().stream().map(entry -> (String)keyConverter.apply(entry.getKey()) + "%" + (String)valueConverter.apply(entry.getValue())).collect(Collectors.joining("/"));
    }

    public static <K, V> Map<K, V> toMap(String msg, Supplier<Map<K, V>> mapSupplier, Function<String, K> keyConverter, Function<String, V> valueConverter) {
        if (msg == null || "^".equals(msg)) {
            return null;
        }
        Map map = mapSupplier.get();
        Arrays.stream(msg.split("/")).forEach(entry -> {
            String[] entryElements = entry.split("%");
            int countElements = entryElements.length;
            Object key = countElements > 0 ? (Object)keyConverter.apply(entryElements[0]) : null;
            Object value = countElements > 1 ? (Object)valueConverter.apply(entryElements[1]) : null;
            map.put(key, value);
        });
        return map;
    }
}

