/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import tjger.game.completed.GameConfig;
import tjger.game.completed.playingfield.PlayingField;
import tjger.gui.GamePanel;
import tjger.gui.completed.Card;
import tjger.gui.completed.CardSet;
import tjger.gui.completed.ColorValuePart;
import tjger.gui.completed.Cover;
import tjger.gui.completed.Part;
import tjger.gui.completed.PartSet;
import tjger.gui.completed.Piece;
import tjger.gui.completed.PieceSet;

public class PartUtil {
    private PartUtil() {
    }

    protected static Part getActivePart(Part part, PartSet set) {
        ColorValuePart cvPart;
        ColorValuePart activePart;
        if (part instanceof ColorValuePart && (activePart = set.getPart((cvPart = (ColorValuePart)part).getColor(), cvPart.getSequence())) != null) {
            return activePart;
        }
        return part;
    }

    protected static List<Part> getActiveParts(Part[] parts, PartSet set) {
        ArrayList<Part> listParts = new ArrayList<Part>();
        if (parts instanceof ColorValuePart[]) {
            int i = 0;
            while (i < parts.length) {
                listParts.add(PartUtil.getActivePart(parts[i], set));
                ++i;
            }
        } else {
            listParts.addAll(Arrays.asList(parts));
        }
        return listParts;
    }

    public static Card getActiveCard(Card card) {
        if (card != null) {
            String type = card.getCardSet().getType();
            CardSet set = GameConfig.getInstance().getActiveCardSet(type);
            return (Card)PartUtil.getActivePart(card, set);
        }
        return null;
    }

    public static Card[] getActiveCards(Card[] cards) {
        if (cards.length > 0) {
            String type = cards[0].getCardSet().getType();
            CardSet set = GameConfig.getInstance().getActiveCardSet(type);
            List<Part> activeParts = PartUtil.getActiveParts(cards, set);
            return activeParts.toArray(new Card[activeParts.size()]);
        }
        return cards;
    }

    public static Piece getActivePiece(Piece piece) {
        PieceSet set = GameConfig.getInstance().getActivePieceSet();
        return (Piece)PartUtil.getActivePart(piece, set);
    }

    public static Piece[] getActivePieces(Piece[] pieces) {
        PieceSet set = GameConfig.getInstance().getActivePieceSet();
        List<Part> activeParts = PartUtil.getActiveParts(pieces, set);
        return activeParts.toArray(new Piece[activeParts.size()]);
    }

    public static Cover[] getCovers(Card[] cards) {
        Object[] covers = new Cover[cards.length];
        Cover activeCover = GameConfig.getInstance().getActiveCover();
        if (activeCover != null) {
            Arrays.fill(covers, activeCover);
            return covers;
        }
        return new Cover[0];
    }

    public static Part[] multiplyParts(Part singlePart, int number) {
        if (number > 0) {
            Object[] parts = new Part[number];
            Arrays.fill(parts, singlePart);
            return parts;
        }
        return new Part[0];
    }

    public static List<Part> multiplyPartsList(Part singlePart, int number) {
        ArrayList<Part> partList = new ArrayList<Part>();
        if (number > 0) {
            partList.addAll(Collections.nCopies(number, singlePart));
        }
        return partList;
    }

    public static Cover getCover(Card card) {
        return GameConfig.getInstance().getActiveCover();
    }

    public static int getDrawingWidth(Part part, int percentSize) {
        if (part == null) {
            return 0;
        }
        return (int)((double)part.getImage().getIconWidth() * ((double)percentSize / 100.0));
    }

    public static int getDrawingWidth(Part[] parts, int percentSize, int xSpacing) {
        if (parts == null || parts.length == 0) {
            return 0;
        }
        return PartUtil.getDrawingWidth(parts[0], percentSize) + xSpacing * (parts.length - 1);
    }

    public static int getDrawingHeight(Part part, int percentSize) {
        if (part == null) {
            return 0;
        }
        return (int)((double)part.getImage().getIconHeight() * ((double)percentSize / 100.0));
    }

    public static int getDrawingHeight(Part[] parts, int percentSize, int ySpacing) {
        if (parts == null || parts.length == 0) {
            return 0;
        }
        return PartUtil.getDrawingHeight(parts[0], percentSize) + ySpacing * (parts.length - 1);
    }

    public static Point getDrawingPosition(int x, int y, int hAlignment, int vAlignment, int drawingWidth, int drawingHeight, boolean positiveCorrection) {
        int drawY;
        int drawX;
        switch (hAlignment) {
            case 0: {
                drawX = x + drawingWidth / 2 * (positiveCorrection ? 1 : -1);
                break;
            }
            case -1: {
                drawX = x + drawingWidth * (positiveCorrection ? 1 : -1);
                break;
            }
            default: {
                drawX = x;
            }
        }
        switch (vAlignment) {
            case 0: {
                drawY = y + drawingHeight / 2 * (positiveCorrection ? 1 : -1);
                break;
            }
            case -1: {
                drawY = y + drawingHeight * (positiveCorrection ? 1 : -1);
                break;
            }
            default: {
                drawY = y;
            }
        }
        return new Point(drawX, drawY);
    }

    public static Point getDrawingPosition(int x, int y, int percentSize, int hAlignment, int vAlignment, Part part) {
        return PartUtil.getDrawingPosition(x, y, hAlignment, vAlignment, PartUtil.getDrawingWidth(part, percentSize), PartUtil.getDrawingHeight(part, percentSize), false);
    }

    public static Point getDrawingPosition(int x, int y, int percentSize, int hAlignment, int vAlignment, Part[] parts, int xSpacing, int ySpacing) {
        return PartUtil.getDrawingPosition(x, y, hAlignment, vAlignment, PartUtil.getDrawingWidth(parts, percentSize, xSpacing), PartUtil.getDrawingHeight(parts, percentSize, ySpacing), false);
    }

    public static int getSelectedPart(Part[] parts, int xClick, int yClick, int xPart, int yPart, int percentSize, int xSpacing, int ySpacing, boolean rotated) {
        return PartUtil.getSelectedPart(parts, xClick, yClick, xPart, yPart, percentSize, 1, 1, xSpacing, ySpacing, rotated);
    }

    public static int getSelectedPart(Part[] parts, int xClick, int yClick, int xPart, int yPart, int percentSize, int hAlignment, int vAlignment, int xSpacing, int ySpacing, boolean rotated) {
        int clickedPart = -1;
        int numParts = parts.length;
        if (numParts > 0) {
            int cardWidth = PartUtil.getDrawingWidth(parts[0], percentSize);
            int cardHeight = PartUtil.getDrawingHeight(parts[0], percentSize);
            if (rotated) {
                int factor = (int)((double)(cardHeight - cardWidth) / 2.0);
                int help = cardWidth;
                cardWidth = cardHeight;
                cardHeight = help;
                xPart -= factor;
                yPart += factor;
            }
            Point drawPos = PartUtil.getDrawingPosition(xPart, yPart, percentSize, hAlignment, vAlignment, parts, xSpacing, ySpacing);
            int minX = drawPos.x;
            int minY = drawPos.y;
            int i = 0;
            while (i < parts.length) {
                int maxX = minX + cardWidth;
                int maxY = minY + cardHeight;
                if (PartUtil.isValueBetween(xClick, minX, maxX) && PartUtil.isValueBetween(yClick, minY, maxY)) {
                    clickedPart = i;
                }
                minX += xSpacing;
                minY += ySpacing;
                ++i;
            }
        }
        return clickedPart;
    }

    private static boolean isValueBetween(int value, int limit1, int limit2) {
        if (limit1 > limit2) {
            int h = limit1;
            limit1 = limit2;
            limit2 = h;
        }
        return value >= limit1 && value <= limit2;
    }

    public static int getSelectedPart(Part[] parts, int xClick, int yClick, int xPart, int yPart, int percentSize, int xSpacing, int ySpacing) {
        return PartUtil.getSelectedPart(parts, xClick, yClick, xPart, yPart, percentSize, xSpacing, ySpacing, false);
    }

    public static int getSelectedPart(Part[] parts, int xClick, int yClick, int xPart, int yPart, int percentSize, int hAlignment, int vAlignment, int xSpacing, int ySpacing) {
        return PartUtil.getSelectedPart(parts, xClick, yClick, xPart, yPart, percentSize, hAlignment, vAlignment, xSpacing, ySpacing, false);
    }

    public static int getSelectedPart(Part[] parts, int xClick, int yClick, PlayingField field, String positionId, int hAlignment, int vAlignment, int xSpacing, int ySpacing) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        Point drawPos = PartUtil.getDrawingPosition(rect.x, rect.y, hAlignment, vAlignment, rect.width, rect.height, true);
        return PartUtil.getSelectedPart(parts, xClick, yClick, drawPos.x, drawPos.y, 100, hAlignment, vAlignment, xSpacing, ySpacing, false);
    }

    public static boolean getSelectedPart(Part part, int xClick, int yClick, int xPart, int yPart, int percentSize) {
        return PartUtil.getSelectedPart(new Part[]{part}, xClick, yClick, xPart, yPart, percentSize, 0, 0) != -1;
    }

    public static boolean getSelectedPart(Part part, int xClick, int yClick, PlayingField field, String positionId, int percentSize) {
        Rectangle rect = field.getFieldRectangle(field.getField(positionId));
        Point drawPos = PartUtil.getDrawingPosition(rect.x, rect.y, 1, 1, rect.width, rect.height, true);
        return PartUtil.getSelectedPart(part, xClick, yClick, drawPos.x, drawPos.y, percentSize);
    }

    public static void drawSelectedPart(int selectIndex, Part[] parts, int xPos, int yPos, int percentSize, int xSpacing, int ySpacing, boolean rotated, Color selectColor, GamePanel gamePanel, Graphics g) {
        PartUtil.drawSelectedPart(selectIndex, parts, xPos, yPos, percentSize, 1, 1, xSpacing, ySpacing, rotated, selectColor, gamePanel, g);
    }

    public static void drawSelectedPart(int selectIndex, Part[] parts, int xPos, int yPos, int percentSize, int hAlignment, int vAlignment, int xSpacing, int ySpacing, boolean rotated, Color selectColor, GamePanel gamePanel, Graphics g) {
        int numParts = parts.length;
        if (selectIndex >= 0 && selectIndex < numParts) {
            int cardWidth = (int)Math.ceil(PartUtil.getDrawingWidth(parts[0], percentSize));
            int cardHeight = (int)Math.ceil(PartUtil.getDrawingHeight(parts[0], percentSize));
            if (rotated) {
                int factor = (int)((double)(cardHeight - cardWidth) / 2.0);
                int help = cardWidth;
                cardWidth = cardHeight;
                cardHeight = help;
                xPos -= factor;
                yPos += factor;
            }
            g.setColor(selectColor);
            int width = selectIndex == numParts - 1 || cardWidth < PartUtil.absValue(xSpacing) ? cardWidth : PartUtil.absValue(xSpacing);
            int height = selectIndex == numParts - 1 || cardHeight < PartUtil.absValue(ySpacing) ? cardHeight : PartUtil.absValue(ySpacing);
            int x1 = xPos + xSpacing * selectIndex + (xSpacing < 0 ? cardWidth - width - 1 : 0);
            int y1 = yPos + ySpacing * selectIndex;
            Point drawPos1 = PartUtil.getDrawingPosition(x1, y1, percentSize, hAlignment, vAlignment, parts, xSpacing, ySpacing);
            gamePanel.drawRect(drawPos1.x, drawPos1.y, width, cardHeight, true, g);
            int diffX = cardWidth - width;
            int x2 = xPos + xSpacing * selectIndex + (xSpacing < 0 ? 0 : width);
            int y2 = yPos + ySpacing * selectIndex + (ySpacing < 0 ? cardHeight - height - 1 : 0);
            Point drawPos2 = PartUtil.getDrawingPosition(x2, y2, percentSize, hAlignment, vAlignment, parts, xSpacing, ySpacing);
            gamePanel.drawRect(drawPos2.x, drawPos2.y, diffX, height, true, g);
        }
    }

    private static int absValue(int value) {
        return Math.abs(value);
    }

    public static void drawSelectedPart(int selectIndex, Part[] parts, int xPos, int yPos, int percentSize, int xSpacing, int ySpacing, Color selectColor, GamePanel gamePanel, Graphics g) {
        PartUtil.drawSelectedPart(selectIndex, parts, xPos, yPos, percentSize, xSpacing, ySpacing, false, selectColor, gamePanel, g);
    }

    public static void drawSelectedPart(int selectIndex, Part[] parts, int xPos, int yPos, int percentSize, int hAlignment, int vAlignment, int xSpacing, int ySpacing, Color selectColor, GamePanel gamePanel, Graphics g) {
        PartUtil.drawSelectedPart(selectIndex, parts, xPos, yPos, percentSize, hAlignment, vAlignment, xSpacing, ySpacing, false, selectColor, gamePanel, g);
    }

    public static void drawSelectedPart(Part part, int xPos, int yPos, int percentSize, Color selectColor, GamePanel gamePanel, Graphics g) {
        PartUtil.drawSelectedPart(0, new Part[]{part}, xPos, yPos, percentSize, 0, 0, selectColor, gamePanel, g);
    }

    public static boolean isInsidePolygon(Polygon p, int x, int y) {
        int ni = 1;
        int u = x;
        int v = y;
        int i = 0;
        while (i < p.npoints) {
            int b;
            int a;
            int yi;
            int ip1 = (i + 1) % p.npoints;
            if (!(p.xpoints[ip1] == p.xpoints[i] || (p.xpoints[ip1] - u) * (u - p.xpoints[i]) < 0 || p.xpoints[ip1] == u && p.xpoints[i] < u || p.xpoints[i] == u && p.xpoints[ip1] < u || (yi = (a = p.ypoints[i] - (b = (p.ypoints[ip1] - p.ypoints[i]) / (p.xpoints[ip1] - p.xpoints[i])) * p.xpoints[i]) + b * u) <= v)) {
                ni *= -1;
            }
            ++i;
        }
        return ni == -1;
    }

    public static boolean isInsideRectangle(int ulX, int ulY, int w, int h, int x, int y) {
        Rectangle rect = new Rectangle(ulX, ulY, w, h);
        return rect.contains(x, y);
    }

    public static Piece[] getPiecesWithColor(String color) {
        PieceSet set = GameConfig.getInstance().getActivePieceSet();
        if (set != null) {
            return set.getPieces(color);
        }
        return new Piece[0];
    }

    public static Card[] getCardsWithColor(String color) {
        GameConfig gc = GameConfig.getInstance();
        String[] stringArray = gc.getCardSetTypes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Card[] cards;
            String setType = stringArray[n2];
            CardSet set = gc.getActiveCardSet(setType);
            if (set != null && (cards = set.getCards(color)).length > 0) {
                return cards;
            }
            ++n2;
        }
        return new Card[0];
    }
}

