/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.completed.GameEngine;
import tjger.gui.completed.Card;
import tjger.gui.completed.Piece;
import tjger.lib.ArrayUtil;
import tjger.lib.PartUtil;

public class PlayerUtil {
    private PlayerUtil() {
    }

    public static int[] getHumanPlayerIndices(GamePlayer[] players) {
        ArrayList<Integer> listHuman = new ArrayList<Integer>();
        if (players != null) {
            int i = 0;
            while (i < players.length) {
                if (players[i].isHuman()) {
                    listHuman.add(i);
                }
                ++i;
            }
        }
        return HGBaseTools.toIntArray(listHuman);
    }

    public static int getIndexOfMainPlayer(GameEngine engine) {
        if (engine.isClientGame() && engine.getNetworkClient() != null) {
            return engine.getNetworkClient().getClientNr();
        }
        int[] indices = PlayerUtil.getHumanPlayerIndices(engine.getActivePlayers());
        return indices.length > 0 ? indices[0] : 0;
    }

    public static GamePlayer getMainPlayer(GameEngine engine) {
        return engine.getActivePlayers()[PlayerUtil.getIndexOfMainPlayer(engine)];
    }

    public static GamePlayer[] getDropOutPlayers(GamePlayer[] players) {
        return PlayerUtil.getPlayersByDropOutState(players, false);
    }

    public static GamePlayer[] getAdvancedPlayers(GamePlayer[] players) {
        return PlayerUtil.getPlayersByDropOutState(players, true);
    }

    private static GamePlayer[] getPlayersByDropOutState(GamePlayer[] players, boolean isAdvanced) {
        ArrayList<GamePlayer> list = new ArrayList<GamePlayer>();
        if (players != null) {
            GamePlayer[] gamePlayerArray = players;
            int n = players.length;
            int n2 = 0;
            while (n2 < n) {
                GamePlayer player = gamePlayerArray[n2];
                if (player.isDropOut() != isAdvanced) {
                    list.add(player);
                }
                ++n2;
            }
        }
        return ArrayUtil.toGamePlayer(list);
    }

    public static String getPlayerNameType(GamePlayer player) {
        return player.getName() + " (" + player.getType().toString() + ")";
    }

    public static ImageIcon getPlayerPieceImage(GamePlayer player) {
        ImageIcon pieceImage = null;
        String playerColor = player.getPieceColor();
        Piece[] pieces = PartUtil.getPiecesWithColor(playerColor);
        if (pieces.length > 0) {
            pieceImage = pieces[0].getImage();
        } else {
            Card[] cards = PartUtil.getCardsWithColor(playerColor);
            if (cards.length > 0) {
                pieceImage = cards[0].getImage();
            }
        }
        return pieceImage;
    }

    public static boolean isHumanPlaying(GameEngine engine) {
        if (engine.isActiveRound() && engine.isActiveGame()) {
            GamePlayer player = engine.getCurrentPlayer();
            return player != null && player.isHuman();
        }
        return false;
    }

    public static GamePlayer[] getActivePlayerStartingMainPlayer(GameEngine engine) {
        GamePlayer[] players = engine.getActivePlayers();
        int mainIndex = PlayerUtil.getIndexOfMainPlayer(engine);
        if (mainIndex == 0) {
            return players;
        }
        GamePlayer[] sortedPlayers = new GamePlayer[players.length];
        int lengthAfterMain = players.length - mainIndex;
        System.arraycopy(players, mainIndex, sortedPlayers, 0, lengthAfterMain);
        System.arraycopy(players, 0, sortedPlayers, lengthAfterMain, mainIndex);
        return sortedPlayers;
    }
}

