/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.lib.HGBaseTools;
import java.util.Date;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;

public abstract class TimeAction
extends Thread {
    private final long minimumTime;
    private boolean cancelAble;

    public TimeAction(long minimumTime) {
        this.minimumTime = minimumTime;
        this.setPriority(1);
    }

    public static void run(TimeAction action) {
        action.start();
    }

    @Override
    public void run() {
        GameEngine engine = GameManager.getInstance().getGameEngine();
        engine.addTimeAction(this);
        this.cancelAble = true;
        Date timeStart = new Date();
        this.doAction();
        long diff = HGBaseTools.getTimeDifference(timeStart);
        boolean interrupted = false;
        if (diff >= 0L && diff < this.minimumTime) {
            try {
                Thread.sleep(this.minimumTime - diff);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (!interrupted) {
            this.cancelAble = false;
            this.afterAction();
        }
        this.cancelAble = true;
        engine.removeTimeAction(this);
    }

    public boolean isCancelAble() {
        return this.cancelAble;
    }

    public abstract void doAction();

    public abstract void afterAction();
}

