/*
 * Decompiled with CFR 0.152.
 */
package tjger.lib;

import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseTools;
import hgb.lib.IntCollection;
import hgb.lib.xml.ChildNodeIterator;
import hgb.lib.xml.HGBaseXMLTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.game.completed.PlayerType;
import tjger.game.internal.PlayerFactory;
import tjger.gui.completed.Card;
import tjger.lib.ArrayUtil;
import tjger.lib.XmlCollectionConverter;
import tjger.lib.XmlMapConverter;

public class XmlUtil {
    private static final String XML_NUMBER = "number";
    private static final String XML_TRUE = "true";
    private static final String XML_SEQUENCE = "sequence";
    private static final String XML_COLOR = "color";
    private static final String XML_PLAYER = "player";
    private static final String XML_NAME = "name";
    private static final String XML_TYPE = "type";
    private static final String XML_IMAGE = "image";
    private static final String XML_PIECE = "piece";

    private XmlUtil() {
    }

    public static Element saveIntArray(Document doc, String name, int[] values) {
        Element nE = doc.createElement(name);
        nE.setAttribute(XML_NUMBER, String.valueOf(values.length));
        int i = 0;
        while (i < values.length) {
            nE.setAttribute(name + i, String.valueOf(values[i]));
            ++i;
        }
        return nE;
    }

    public static Element saveIntArray(Document doc, Element root, String name, int[] values) {
        Element node = XmlUtil.saveIntArray(doc, name, values);
        root.appendChild(node);
        return node;
    }

    public static int[] loadIntArray(Node node) {
        String nodeName = node.getNodeName();
        int number = Math.max(0, HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, XML_NUMBER)));
        int[] values = new int[number];
        int i = 0;
        while (i < values.length) {
            int value = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, nodeName + i));
            if (value != -2147483631) {
                values[i] = value;
            }
            ++i;
        }
        return values;
    }

    public static Element saveIntCollection(Document doc, String name, IntCollection value) {
        return XmlUtil.saveIntArray(doc, name, value.values());
    }

    public static Element saveIntCollection(Document doc, Element root, String name, IntCollection value) {
        return XmlUtil.saveIntArray(doc, root, name, value.values());
    }

    public static IntCollection loadIntCollection(Node node) {
        return new IntCollection(XmlUtil.loadIntArray(node));
    }

    public static Element saveIntCollectionArray(Document doc, String name, IntCollection[] values) {
        Element nE = doc.createElement(name);
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                Element eNode = XmlUtil.saveIntCollection(doc, name + i, values[i]);
                nE.appendChild(eNode);
            }
            ++i;
        }
        return nE;
    }

    public static Element saveIntCollectionArray(Document doc, Element root, String name, IntCollection[] values) {
        Element node = XmlUtil.saveIntCollectionArray(doc, name, values);
        root.appendChild(node);
        return node;
    }

    public static IntCollection[] loadIntCollectionArray(Node node) {
        final String nodeName = node.getNodeName();
        final ArrayList list = new ArrayList();
        ChildNodeIterator.run(new ChildNodeIterator(node, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().startsWith(nodeName)) {
                    IntCollection collection = XmlUtil.loadIntCollection(node);
                    list.add(collection);
                }
            }
        });
        return list.toArray(new IntCollection[list.size()]);
    }

    public static Element saveBooleanArray(Document doc, String name, boolean[] values) {
        Element nE = doc.createElement(name);
        nE.setAttribute(XML_NUMBER, String.valueOf(values.length));
        int i = 0;
        while (i < values.length) {
            nE.setAttribute(name + i, String.valueOf(values[i]));
            ++i;
        }
        return nE;
    }

    public static Element saveBooleanArray(Document doc, Element root, String name, boolean[] values) {
        Element node = XmlUtil.saveBooleanArray(doc, name, values);
        root.appendChild(node);
        return node;
    }

    public static boolean[] loadBooleanArray(Node node) {
        String nodeName = node.getNodeName();
        int number = Math.max(0, HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, XML_NUMBER)));
        boolean[] values = new boolean[number];
        int i = 0;
        while (i < values.length) {
            values[i] = HGBaseXMLTools.getAttributeValue(node, nodeName + i).equals(XML_TRUE);
            ++i;
        }
        return values;
    }

    public static Element saveStringArray(Document doc, String name, String[] values) {
        Element nE = doc.createElement(name);
        int i = 0;
        while (i < values.length) {
            if (values[i] != null) {
                Element eNode = doc.createElement(name + i);
                HGBaseXMLTools.setNodeValue(eNode, values[i]);
                nE.appendChild(eNode);
            }
            ++i;
        }
        return nE;
    }

    public static Element saveStringArray(Document doc, Element root, String name, String[] values) {
        Element node = XmlUtil.saveStringArray(doc, name, values);
        root.appendChild(node);
        return node;
    }

    public static String[] loadStringArray(Node node) {
        final String nodeName = node.getNodeName();
        final ArrayList list = new ArrayList();
        ChildNodeIterator.run(new ChildNodeIterator(node, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().startsWith(nodeName)) {
                    list.add(HGBaseXMLTools.getNodeValue(node));
                }
            }
        });
        return HGBaseTools.toStringArray(list);
    }

    public static Element saveCardArray(Document doc, String name, Card[] cards) {
        Element nE = doc.createElement(name);
        int i = 0;
        while (i < cards.length) {
            Element eNode = XmlUtil.saveCard(doc, name + i, cards[i]);
            nE.appendChild(eNode);
            ++i;
        }
        return nE;
    }

    public static Element saveCardArray(Document doc, Element root, String name, Card[] cards) {
        Element node = XmlUtil.saveCardArray(doc, name, cards);
        root.appendChild(node);
        return node;
    }

    public static Element saveCardList(Document doc, String name, List<Card> cardList) {
        return XmlUtil.saveCardArray(doc, name, ArrayUtil.toCard(cardList));
    }

    public static Element saveCardList(Document doc, Element root, String name, List<Card> cardList) {
        Element node = XmlUtil.saveCardList(doc, name, cardList);
        root.appendChild(node);
        return node;
    }

    public static Card[] loadCardArray(Node node) {
        final String nodeName = node.getNodeName();
        final ArrayList<Card> list = new ArrayList<Card>();
        ChildNodeIterator.run(new ChildNodeIterator(node, null){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (node.getNodeName().startsWith(nodeName)) {
                    Card card = XmlUtil.loadCard(node);
                    list.add(card);
                }
            }
        });
        return ArrayUtil.toCard(list);
    }

    public static List<Card> loadCardList(Node node) {
        Card[] cards = XmlUtil.loadCardArray(node);
        return ArrayUtil.toList(cards);
    }

    public static Element saveCard(Document doc, String name, Card card) {
        Element eCard = doc.createElement(name);
        if (card != null) {
            eCard.setAttribute(XML_COLOR, card.getColor());
            eCard.setAttribute(XML_SEQUENCE, String.valueOf(card.getSequence()));
            String type = card.getCardSet().getType();
            if (!"game.cardset".equals(type)) {
                eCard.setAttribute(XML_TYPE, type);
            }
        }
        return eCard;
    }

    public static Element saveCard(Document doc, Element root, String name, Card card) {
        Element node = XmlUtil.saveCard(doc, name, card);
        root.appendChild(node);
        return node;
    }

    public static Card loadCard(Node node) {
        GameConfig config = GameManager.getInstance().getGameConfig();
        String color = HGBaseXMLTools.getAttributeValue(node, XML_COLOR);
        int sequence = HGBaseTools.toInt(HGBaseXMLTools.getAttributeValue(node, XML_SEQUENCE));
        if (HGBaseTools.hasContent(color) && sequence != -2147483631) {
            String type = HGBaseXMLTools.getAttributeValue(node, XML_TYPE);
            if (HGBaseTools.hasContent(type)) {
                return config.getActiveCardSet(type).getCard(color, sequence);
            }
            return config.getActiveCardSet().getCard(color, sequence);
        }
        return null;
    }

    public static Element savePlayer(Document doc, String name, GamePlayer player) {
        Element eP = doc.createElement(name);
        if (player != null) {
            eP.setAttribute(XML_NAME, player.getName());
            eP.setAttribute(XML_TYPE, XmlUtil.getPlayerTypeForSaving(player));
            eP.setAttribute(XML_PIECE, player.getPieceColor());
            if (player.getImage() != null) {
                eP.setAttribute(XML_IMAGE, HGBaseFileTools.getFileName(player.getImage().getDescription(), false));
            }
        }
        return eP;
    }

    private static String getPlayerTypeForSaving(GamePlayer player) {
        if (player.isNetwork()) {
            PlayerFactory pf = PlayerFactory.getInstance();
            PlayerType[] ptList = pf.getSupportedPlayerTypes();
            Object[] humanList = pf.getHumanPlayerTypes();
            Object[] networkList = pf.getNetworkPlayerTypes();
            int i = 0;
            while (i < ptList.length) {
                PlayerType pt = ptList[i];
                if (HGBaseTools.getIndexOf(networkList, pt) < 0 && HGBaseTools.getIndexOf(humanList, pt) < 0) {
                    return pt.getId();
                }
                ++i;
            }
            if (humanList.length > 0) {
                return humanList[0].getId();
            }
        }
        return player.getType().getId();
    }

    public static Element savePlayer(Document doc, Element root, String name, GamePlayer player) {
        Element node = XmlUtil.savePlayer(doc, name, player);
        root.appendChild(node);
        return node;
    }

    public static GamePlayer loadPlayer(Node node) {
        String pName = HGBaseXMLTools.getAttributeValue(node, XML_NAME);
        String pType = HGBaseXMLTools.getAttributeValue(node, XML_TYPE);
        String pPiece = HGBaseXMLTools.getAttributeValue(node, XML_PIECE);
        GameConfig config = GameConfig.getInstance();
        String imagePath = config.getElementPath(XML_PLAYER);
        String imageExtension = config.getElementExtension(XML_PLAYER);
        String imageName = HGBaseXMLTools.getAttributeValue(node, XML_IMAGE);
        ImageIcon pImage = HGBaseGuiTools.loadImage(imagePath + "/" + imageName + "." + imageExtension);
        return PlayerFactory.getInstance().createPlayer(pType, pName, pImage, pPiece);
    }

    public static <K, V> Element saveMap(Document doc, String nodeName, String itemName, Map<K, V> map, XmlMapConverter<K, V> xmlConverter) {
        Element mapNode = doc.createElement(nodeName);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            Element itemNode = doc.createElement(itemName);
            mapNode.appendChild(itemNode);
            xmlConverter.writeNode(itemNode, entry.getKey(), entry.getValue());
        }
        return mapNode;
    }

    public static <K, V> Element saveMap(Document doc, Element root, String nodeName, String itemName, Map<K, V> map, XmlMapConverter<K, V> xmlConverter) {
        Element node = XmlUtil.saveMap(doc, nodeName, itemName, map, xmlConverter);
        root.appendChild(node);
        return node;
    }

    public static <V> Element saveCollection(Document doc, String nodeName, String itemName, Collection<V> collection, XmlCollectionConverter<V> xmlConverter) {
        Element collectionNode = doc.createElement(nodeName);
        for (V value : collection) {
            Element itemNode = doc.createElement(itemName);
            collectionNode.appendChild(itemNode);
            xmlConverter.writeValue(itemNode, value);
        }
        return collectionNode;
    }

    public static <V> Element saveCollection(Document doc, Element root, String nodeName, String itemName, Collection<V> collection, XmlCollectionConverter<V> xmlConverter) {
        Element node = XmlUtil.saveCollection(doc, nodeName, itemName, collection, xmlConverter);
        root.appendChild(node);
        return node;
    }

    public static <K, V> Map<K, V> loadMap(Node node, final String itemName, final XmlMapConverter<K, V> xmlConverter) {
        final HashMap map = new HashMap();
        ChildNodeIterator.run(new ChildNodeIterator(node, map){

            @Override
            public void performNode(Node node, int index, Object obj) {
                Object key;
                if (itemName.equals(node.getNodeName()) && (key = xmlConverter.readKey(node)) != null) {
                    Object value = xmlConverter.readValue(node);
                    map.put(key, value);
                }
            }
        });
        return map;
    }

    public static <V> Collection<V> loadCollection(Node node, final String itemName, final XmlCollectionConverter<V> xmlConverter) {
        final ArrayList collection = new ArrayList();
        ChildNodeIterator.run(new ChildNodeIterator(node, collection){

            @Override
            public void performNode(Node node, int index, Object obj) {
                if (itemName.equals(node.getNodeName())) {
                    collection.add(xmlConverter.readValue(node));
                }
            }
        });
        return collection;
    }
}

