/*
 * Decompiled with CFR 0.152.
 */
package tjger.net;

import hgb.lib.HGBaseTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import tjger.MainFrame;
import tjger.game.completed.GameManager;

public abstract class NetworkConnection {
    public static final int DISCONNECTED = 0;
    public static final int CONNECTED = 1;
    public static final int CONNECTING = 2;
    public static final int NOTUSED = 9;
    private boolean wasClosed;
    private List<String> msgBuffer = new ArrayList<String>();

    protected MainFrame getMainFrame() {
        return GameManager.getInstance().getMainFrame();
    }

    public void reset() {
        this.msgBuffer.clear();
        this.wasClosed = false;
    }

    public static void netWait() {
        HGBaseTools.sleep(150L);
    }

    protected int start() {
        this.reset();
        Thread t = new Thread(){

            @Override
            public void run() {
                while (!NetworkConnection.this.wasClosed) {
                    String msg = NetworkConnection.this.getMessage();
                    if (HGBaseTools.hasContent(msg)) {
                        NetworkConnection.this.msgBufInsert(msg);
                        NetworkConnection.this.handleMessage(msg);
                    }
                    NetworkConnection.netWait();
                }
            }
        };
        t.start();
        return 0;
    }

    public abstract int getId();

    public String getIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            return "";
        }
    }

    public void close() {
        this.wasClosed = true;
    }

    protected int putMessage(PrintStream out, String message) {
        if (out != null) {
            out.println(message);
            return out.checkError() ? -30224 : 0;
        }
        return -30221;
    }

    protected abstract String getMessage();

    protected int getMessage(BufferedReader in, StringBuffer message) {
        if (in != null) {
            try {
                if (in.ready()) {
                    String str = in.readLine();
                    if (str != null) {
                        message.append(str);
                    }
                    return 0;
                }
            }
            catch (IOException e) {
                return -30225;
            }
        }
        return 0;
    }

    protected abstract boolean handleMessage(String var1);

    protected void msgBufClear() {
        if (this.msgBuffer != null) {
            this.msgBuffer.clear();
        }
    }

    protected void msgBufInsert(String msg) {
        if (this.msgBuffer != null && msg != null) {
            this.msgBuffer.add(msg);
        }
    }

    protected boolean isMessageType(String msg, String type, String param) {
        return type.equals(this.getMessagePart(0, msg)) && (param == null || param.equals(this.getMessagePart(1, msg)));
    }

    protected int getIndexOfMessage(String type, String param) {
        int i = 0;
        while (i < this.msgBuffer.size()) {
            String msg = this.msgBuffer.get(i);
            if (this.isMessageType(msg, type, param)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNextMessage(String type, String param) {
        String msg = null;
        List<String> list = this.msgBuffer;
        synchronized (list) {
            int idx = this.getIndexOfMessage(type, param);
            if (idx >= 0) {
                msg = this.msgBuffer.remove(idx);
            }
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getNextMessage(String type, String param, int id) {
        String msg = null;
        List<String> list = this.msgBuffer;
        synchronized (list) {
            int i = 0;
            while (i < this.msgBuffer.size() && msg == null) {
                String m = this.msgBuffer.get(i);
                if (this.isMessageType(m, type, param) && this.getClientIdOfMessage(m) == id) {
                    msg = this.msgBuffer.remove(i);
                }
                ++i;
            }
        }
        return msg;
    }

    protected int getClientIdOfMessage(String msg) {
        StringTokenizer st = new StringTokenizer(msg, ";");
        String lastPart = "";
        while (st.hasMoreTokens()) {
            lastPart = st.nextToken();
        }
        int id = HGBaseTools.toInt(lastPart);
        return id == -2147483631 ? -1 : id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int removeMessagesWithClientId(int id) {
        int num = 0;
        List<String> list = this.msgBuffer;
        synchronized (list) {
            int i = this.msgBuffer.size() - 1;
            while (i >= 0) {
                String m = this.msgBuffer.get(i);
                if (this.getClientIdOfMessage(m) == id) {
                    this.msgBuffer.remove(i);
                    ++num;
                }
                --i;
            }
        }
        return num;
    }

    protected String getMessagePart(int index, String msg) {
        if (msg != null) {
            StringTokenizer st = new StringTokenizer(msg, ";");
            int i = 0;
            while (st.hasMoreTokens()) {
                String part = st.nextToken();
                if (i == index) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    protected int getNumberMessageParts(String msg) {
        return msg.split(";").length;
    }

    public String messageMoveInformation() {
        return this.messageGameInformation("TJxMI");
    }

    protected String messageGameInformation(String msgType) {
        String msg = this.getNextMessage(msgType, null);
        return msg == null ? null : msg.replaceFirst(msgType + ";", "");
    }
}

