/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGameState;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Track;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.ImageIcon;
import tjger.gui.GamePanel;
import tjger.gui.completed.Background;

public abstract class AbstractLineRacerGamePanel
extends GamePanel {
    private Point maxGridPos;
    private Point pointedGridPos = null;

    public Point getPointedGridPos() {
        return this.pointedGridPos;
    }

    public void setPointedGridPos(Point pointedGridPos) {
        this.pointedGridPos = pointedGridPos;
    }

    public abstract boolean isPaintingAllowed();

    @Override
    protected void paintBackground(Graphics g) {
        Background background;
        AbstractLineRacerGameState state = (AbstractLineRacerGameState)this.getGameState();
        Track track = state.getTrack();
        if (track == null || !this.isPaintingAllowed()) {
            return;
        }
        Color backgroundColor = state.getBackgroundColor();
        ImageIcon backgroundImage = state.getBackgroundImage();
        if (backgroundImage != null) {
            if (state.isBackgroundImageHidden()) {
                return;
            }
            background = new Background("background", backgroundImage, false, false, true, 100);
        } else if (backgroundColor != null) {
            background = new Background("background", backgroundColor, true, true);
        } else {
            return;
        }
        this.paintBackground(background, g);
    }

    @Override
    protected void paintParts(Graphics g) {
        super.paintParts(g);
        if (this.isPaintingAllowed()) {
            AbstractLineRacerGameState state = (AbstractLineRacerGameState)this.getGameState();
            int gridSize = state.getGridSize();
            this.paintGrid(gridSize, state.getGridColor(), g);
            this.paintTrack(state.getOuterPoints(), state.getInnerPoints(), state.getBorderColor(), state.getFinishLine(), state.getFinishLineColor(), gridSize, g);
        }
    }

    protected void paintHorizontalGridLines(int fieldWidth, int fieldHeight, int gridSize, Graphics g) {
        int y = gridSize;
        while (y < fieldHeight) {
            this.drawLine(0, y, fieldWidth, y, g);
            y += gridSize;
        }
    }

    protected void paintVerticalGridLines(int fieldWidth, int fieldHeight, int gridSize, Graphics g) {
        int x = gridSize;
        while (x < fieldWidth) {
            this.drawLine(x, 0, x, fieldHeight, g);
            x += gridSize;
        }
    }

    protected void paintGrid(int gridSize, Color lineColor, Graphics g) {
        int fieldWidth = this.getFieldWidth();
        int fieldHeight = this.getFieldHeight();
        Color oldColor = this.changeColor(lineColor, g);
        this.paintHorizontalGridLines(fieldWidth, fieldHeight, gridSize, g);
        this.paintVerticalGridLines(fieldWidth, fieldHeight, gridSize, g);
        this.changeColor(oldColor, g);
    }

    protected void paintTrack(Point[] outerLinePoints, Point[] innerLinePoints, Color lineColor, Line finishLine, Color finishLineColor, int gridSize, Graphics g) {
        this.paintTrackLine(outerLinePoints, innerLinePoints, lineColor, gridSize, g);
        this.paintFinishLine(finishLine, finishLineColor, gridSize, g);
    }

    protected void paintTrackLine(Point[] outerLinePoints, Point[] innerLinePoints, Color lineColor, int gridSize, Graphics g) {
        Color oldColor = this.changeColor(lineColor, g);
        this.drawPolygon(AbstractLineRacerGamePanel.getPolygon(outerLinePoints, gridSize), false, g);
        this.drawPolygon(AbstractLineRacerGamePanel.getPolygon(innerLinePoints, gridSize), false, g);
        this.changeColor(oldColor, g);
    }

    protected void paintFinishLine(Line line, Color lineColor, int gridSize, Graphics g) {
        Color oldColor = this.changeColor(lineColor, g);
        this.paintGridLine(line, gridSize, g);
        this.changeColor(oldColor, g);
    }

    protected void paintGridLine(Line line, int gridSize, Graphics g) {
        if (line == null) {
            return;
        }
        this.paintGridLine(line.getStartPos(), line.getEndPos(), gridSize, g);
    }

    protected void paintGridLine(Point startPos, Point endPos, int gridSize, Graphics g) {
        if (startPos == null || endPos == null) {
            return;
        }
        Point panelStartPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(startPos, gridSize);
        Point panelEndPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(endPos, gridSize);
        this.drawLine(panelStartPos.x, panelStartPos.y, panelEndPos.x, panelEndPos.y, g);
    }

    public static Point convertGridPosToScreenPos(Point pos, int gridSize) {
        int screenX = (pos.x + 1) * gridSize;
        int screenY = (pos.y + 1) * gridSize;
        return new Point(screenX, screenY);
    }

    public Point convertScreenPosToGridPos(Point pos, int gridSize) {
        if (pos.x > this.getFieldWidth() || pos.x < 0 || pos.y > this.getFieldHeight() || pos.y < 0) {
            return null;
        }
        int gridPosX = Math.max((int)Math.floor(pos.getX() / (double)gridSize) - 1, 0);
        int gridPosY = Math.max((int)Math.floor(pos.getY() / (double)gridSize) - 1, 0);
        Point gridPos = new Point(gridPosX, gridPosY);
        return gridPos;
    }

    public static Polygon getPolygon(Point[] gridPoints, int gridSize) {
        Polygon polygon = new Polygon();
        if (gridPoints == null || gridPoints.length == 0) {
            return polygon;
        }
        Point[] pointArray = gridPoints;
        int n = gridPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point gridPos = pointArray[n2];
            if (gridPos != null) {
                Point panelPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(gridPos, gridSize);
                polygon.addPoint(panelPos.x, panelPos.y);
            }
            ++n2;
        }
        return polygon;
    }

    protected void paintGridDot(Point pos, int dotSize, int gridSize, Graphics g) {
        this.paintGridOval(pos, dotSize, gridSize, true, g);
    }

    protected void paintGridCircle(Point pos, int circleSize, int gridSize, Graphics g) {
        this.paintGridOval(pos, circleSize, gridSize, false, g);
    }

    private void paintGridOval(Point pos, int size, int gridSize, boolean filled, Graphics g) {
        if (!this.isGridPosValid(pos)) {
            return;
        }
        Point screenPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(pos, gridSize);
        int offset = size / 2;
        this.drawOval(screenPos.x - offset, screenPos.y - offset, size, size, filled, g);
    }

    protected void paintGridDots(Point[] positions, int dotSize, Color dotColor, int gridSize, Graphics g) {
        Color oldColor = this.changeColor(dotColor, g);
        Point[] pointArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            Point pos = pointArray[n2];
            this.paintGridDot(pos, dotSize, gridSize, g);
            ++n2;
        }
        this.changeColor(oldColor, g);
    }

    public boolean isGridPosValid(Point gridPos) {
        return LineRacerUtils.isGridPosValid(gridPos, this.maxGridPos);
    }

    protected void calcMaxGridPos(int gridSize) {
        this.maxGridPos = LineRacerUtils.calcMaxGridPos(gridSize, this.getFieldWidth(), this.getFieldHeight());
    }
}

