/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.Vector;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Line {
    private Point startPos;
    private Point endPos;

    public Line(Point startPos, Point endPos) {
        this.startPos = startPos;
        this.setEndPos(endPos);
    }

    public Point getStartPos() {
        return this.startPos;
    }

    public Point getEndPos() {
        return this.endPos;
    }

    public void setEndPos(Point endPos) {
        this.endPos = endPos;
    }

    public Point[] getPositions() {
        return new Point[]{this.startPos, this.endPos};
    }

    public String toString() {
        return "(" + (this.startPos != null ? String.valueOf(this.startPos.x) + "/" + this.startPos.y : "") + ")-(" + (this.endPos != null ? String.valueOf(this.endPos.x) + "/" + this.endPos.y : "") + ")";
    }

    private Rectangle getBounds() {
        int height;
        int topY;
        int width;
        int leftX;
        if (this.startPos == null || this.endPos == null) {
            return null;
        }
        if (this.startPos.x <= this.endPos.x) {
            leftX = this.startPos.x;
            width = this.getDeltaX();
        } else {
            leftX = this.endPos.x;
            width = this.getDeltaX() * -1;
        }
        if (this.startPos.y <= this.endPos.y) {
            topY = this.startPos.y;
            height = this.getDeltaY();
        } else {
            topY = this.endPos.y;
            height = this.getDeltaY() * -1;
        }
        return new Rectangle(leftX, topY, width, height);
    }

    private int getDeltaX() {
        if (this.startPos == null || this.endPos == null) {
            return 0;
        }
        return this.endPos.x - this.startPos.x;
    }

    private int getDeltaY() {
        if (this.startPos == null || this.endPos == null) {
            return 0;
        }
        return this.endPos.y - this.startPos.y;
    }

    private double getSlope(double deltaX, double deltaY) {
        return deltaY / deltaX;
    }

    public Vector getVector() {
        return new Vector(this.getDeltaX(), this.getDeltaY());
    }

    public boolean contains(Point pos) {
        if (pos == null || this.startPos == null || this.endPos == null) {
            return false;
        }
        double deltaX = this.getDeltaX();
        double deltaY = this.getDeltaY();
        if (deltaX == 0.0) {
            return pos.x == this.startPos.x && pos.y >= Math.min(this.startPos.y, this.endPos.y) && pos.y <= Math.max(this.startPos.y, this.endPos.y);
        }
        if (deltaY == 0.0) {
            return pos.y == this.startPos.y && pos.x >= Math.min(this.startPos.x, this.endPos.x) && pos.x <= Math.max(this.startPos.x, this.endPos.x);
        }
        if (!this.getBounds().contains(pos)) {
            return false;
        }
        double slope = this.getSlope(deltaX, deltaY);
        return (double)pos.y == slope * (double)(pos.x - this.startPos.x) + (double)this.startPos.y;
    }

    private Line2D getLine2D() {
        if (this.startPos == null || this.endPos == null) {
            return null;
        }
        return new Line2D.Double(this.startPos.getX(), this.startPos.getY(), this.endPos.getX(), this.endPos.getY());
    }

    public boolean intersectsLine(Line otherLine) {
        if (otherLine == null) {
            return false;
        }
        Line2D thisLine2D = this.getLine2D();
        Line2D otherline2D = otherLine.getLine2D();
        if (thisLine2D == null || otherline2D == null) {
            return false;
        }
        return thisLine2D.intersectsLine(otherline2D);
    }

    public Point2D getIntersectionPoint(Line otherLine) {
        if (otherLine == null || this.startPos == null || this.endPos == null || otherLine.startPos == null || otherLine.endPos == null) {
            return null;
        }
        double a1 = this.getDeltaY();
        double b1 = this.getDeltaX() * -1;
        double c1 = a1 * (double)this.startPos.x + b1 * (double)this.startPos.y;
        double a2 = otherLine.getDeltaY();
        double b2 = otherLine.getDeltaX() * -1;
        double c2 = a2 * (double)otherLine.startPos.x + b2 * (double)otherLine.startPos.y;
        double determinant = a1 * b2 - a2 * b1;
        if (determinant == 0.0) {
            return null;
        }
        double x = (b2 * c1 - b1 * c2) / determinant;
        double y = (a1 * c2 - a2 * c1) / determinant;
        return new Point2D.Double(x, y);
    }

    public Point getIntersectionPointRounded(Line otherLine) {
        Point2D intersection = this.getIntersectionPoint(otherLine);
        if (intersection == null) {
            return null;
        }
        return new Point((int)Math.round(intersection.getX()), (int)Math.round(intersection.getY()));
    }

    private static Point movePoint(Point point, Vector direction, int length) {
        if (point == null || direction == null) {
            return null;
        }
        double angle = direction.getAngle();
        int deltaX = (int)((double)length * Math.cos(Math.toRadians(angle)));
        int deltaY = (int)((double)length * Math.sin(Math.toRadians(angle)));
        return new Point(point.x + deltaX, point.y + deltaY);
    }

    public Polygon toRectangle(int height) {
        Vector vector = this.getVector();
        Vector above = vector.rotate(270.0);
        Vector below = vector.rotate(90.0);
        Point startPosAbove = Line.movePoint(this.startPos, above, height / 2);
        Point startPosBelow = Line.movePoint(this.startPos, below, height / 2);
        Point endPosAbove = Line.movePoint(this.endPos, above, height / 2);
        Point endPosBelow = Line.movePoint(this.endPos, below, height / 2);
        if (startPosAbove == null || startPosBelow == null || endPosAbove == null || endPosBelow == null) {
            return null;
        }
        return new Polygon(new int[]{startPosAbove.x, endPosAbove.x, endPosBelow.x, startPosBelow.x}, new int[]{startPosAbove.y, endPosAbove.y, endPosBelow.y, startPosBelow.y}, 4);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Line)) {
            return false;
        }
        Line other = (Line)obj;
        if (this == other) {
            return true;
        }
        if (this.getStartPos() == null || this.getEndPos() == null) {
            return false;
        }
        return this.getStartPos().equals(other.getStartPos()) && this.getEndPos().equals(other.getEndPos());
    }
}

