/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.Vector;
import hgb.gui.HGBaseGuiTools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tjger.game.GamePlayer;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameEngine;

public class LineRacerUtils {
    private LineRacerUtils() {
    }

    public static boolean isPointInArray(Point[] points, Point point) {
        if (points == null || point == null) {
            return false;
        }
        return Arrays.asList(points).contains(point);
    }

    public static int getPointIndex(Point[] points, Point point) {
        if (points == null || point == null) {
            return -1;
        }
        return Arrays.asList(points).indexOf(point);
    }

    public static boolean isPosNextToPos(Point pos1, Point pos2, Vector vector) {
        if (pos1 == null || pos2 == null || vector == null) {
            return false;
        }
        if (vector.isVertical()) {
            return pos1.y == pos2.y;
        }
        if (vector.isHorizontal()) {
            return pos1.x == pos2.x;
        }
        return false;
    }

    public static Point calcMaxGridPos(int gridSize, int fieldWidth, int fieldHeight) {
        if (gridSize < 1) {
            return new Point(0, 0);
        }
        return new Point(fieldWidth / gridSize - 2, fieldHeight / gridSize - 2);
    }

    public static boolean isGridPosValid(Point gridPos, Point maxGridPos) {
        return gridPos != null && gridPos.x >= 0 && gridPos.y >= 0 && gridPos.x <= maxGridPos.x && gridPos.y <= maxGridPos.y;
    }

    public static Point convertPoint2DToPoint(Point2D point) {
        if (point == null) {
            return null;
        }
        return new Point((int)Math.round(point.getX()), (int)Math.round(point.getY()));
    }

    public static Icon createPlayerColorIcon(GameEngine engine, GamePlayer player) {
        return LineRacerUtils.createPlayerColorIcon(LineRacerUtils.getPlayerLaneColor(engine, player));
    }

    public static Color getPlayerLaneColor(GameEngine engine, GamePlayer player) {
        return LineRacerUtils.getPlayerLaneColor(GameConfig.getInstance(), engine.getIndexOfPlayer(player));
    }

    public static Color getPlayerLaneColor(GameConfig config, int playerIndex) {
        Color[] colors = LineRacerUtils.getPlayerLaneColors(config);
        if (playerIndex < 0 || playerIndex >= colors.length) {
            return null;
        }
        return colors[playerIndex];
    }

    public static Color[] getPlayerLaneColors(GameConfig config) {
        ArrayList<Color> colors = new ArrayList<Color>();
        int i = 1;
        while (i <= config.getMaxPlayers()) {
            colors.add(config.getActiveColor("color_lane_player" + i));
            ++i;
        }
        return colors.toArray(new Color[0]);
    }

    public static Color getCurrentPlayerLaneColor() {
        return LineRacerUtils.getPlayerLaneColors(GameConfig.getInstance())[GameEngine.getInstance().getCurrentPlayerIndex()];
    }

    public static Icon createPlayerColorIcon(Color color) {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D g = bufferedImage.createGraphics();
        g.setColor(color);
        g.fillOval(0, 0, 10, 10);
        return new ImageIcon(bufferedImage);
    }

    public static Icon getRankIcon(int rank) {
        if (rank < 1 || rank > 3) {
            return null;
        }
        return HGBaseGuiTools.loadImage("/gfx/trophy/rank" + rank + ".png");
    }
}

