/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.common;

import com.tjger.lineracer.desktop.common.CloneUtils;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Vector;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.UndoStack;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class Track
implements UndoStack.Undoable<Track> {
    public static final int MINIMUM_GRID_SIZE = 1;
    public static final int MAXIMUM_GRID_SIZE = 100;
    public static final int FIELD_WIDTH = 1600;
    public static final int FIELD_HEIGHT = 900;
    private String name;
    private String version;
    private String author;
    private HashMap<String, String> descriptions;
    private int gridSize;
    private Color gridColor;
    private Point[] outerPoints;
    private Point[] innerPoints;
    private Color borderColor;
    private Line finishLine;
    private Color finishLineColor;
    private Point[] startPositions;
    private Vector startVector;
    private Line[] checkLines;
    private Color backgroundColor;
    private byte[] backgroundImageData;
    private ImageIcon backgroundImage;

    public Track() {
        this(null, null, null, new HashMap<String, String>(), 0, Color.LIGHT_GRAY, null, null, Color.BLACK, null, Color.RED, null, null, null, null, null);
    }

    public Track(String name, String version, String author, HashMap<String, String> descriptions, int gridSize, Color gridColor, Point[] outerPoints, Point[] innerPoints, Color borderColor, Line finishLine, Color finishLineColor, Point[] startPositions, Vector startVector, Line[] checkLines, Color backgroundColor, byte[] backgroundImageData) {
        this.setName(name);
        this.setVersion(version);
        this.setAuthor(author);
        this.setDescriptions(descriptions);
        this.setGridSize(gridSize);
        this.setGridColor(gridColor);
        this.setOuterPoints(outerPoints);
        this.setInnerPoints(innerPoints);
        this.setBorderColor(borderColor);
        this.setFinishLine(finishLine);
        this.setFinishLineColor(finishLineColor);
        this.setStartPositions(startPositions);
        this.setStartVector(startVector);
        this.setCheckLines(checkLines);
        this.setBackgroundColor(backgroundColor);
        this.setBackgroundImageData(backgroundImageData);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getAuthor() {
        return this.author;
    }

    private void initDescriptions() {
        if (this.descriptions == null) {
            this.descriptions = new HashMap();
        }
    }

    public void setDescriptions(HashMap<String, String> descriptions) {
        this.descriptions = descriptions;
        this.initDescriptions();
    }

    public void setDescription(String language, String description) {
        this.initDescriptions();
        this.descriptions.put(language, description);
    }

    public HashMap<String, String> getDescriptions() {
        this.initDescriptions();
        return this.descriptions;
    }

    public String getDescription(String language) {
        this.initDescriptions();
        return this.descriptions.getOrDefault(language, "");
    }

    public boolean isDescriptionAvailable(String language) {
        this.initDescriptions();
        return this.descriptions.containsKey(language);
    }

    public String getFirstDescription() {
        this.initDescriptions();
        String[] values = this.descriptions.values().toArray(new String[0]);
        return values.length > 0 ? values[0] : "";
    }

    public void setGridSize(int gridSize) {
        this.gridSize = gridSize;
    }

    public int getGridSize() {
        return this.gridSize;
    }

    public void setGridColor(Color gridColor) {
        this.gridColor = gridColor;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setOuterPoints(Point[] outerPoints) {
        this.outerPoints = outerPoints;
    }

    public Point[] getOuterPoints() {
        return this.outerPoints;
    }

    public Line[] getOuterLines() {
        return Track.getLines(this.outerPoints);
    }

    private Polygon getOuterPolygon() {
        return Track.getPolygon(this.outerPoints);
    }

    public void setInnerPoints(Point[] innerPoints) {
        this.innerPoints = innerPoints;
    }

    public Point[] getInnerPoints() {
        return this.innerPoints;
    }

    public Line[] getInnerLines() {
        return Track.getLines(this.innerPoints);
    }

    private Polygon getInnerPolygon() {
        return Track.getPolygon(this.innerPoints);
    }

    public Point[] getTrackPoints() {
        ArrayList both = new ArrayList(this.getOuterLines().length + this.getInnerPoints().length);
        Collections.addAll(both, this.getOuterPoints());
        Collections.addAll(both, this.getInnerPoints());
        return both.toArray(new Point[0]);
    }

    public Line[] getTrackLines() {
        ArrayList both = new ArrayList(this.getOuterLines().length + this.getInnerLines().length);
        Collections.addAll(both, this.getOuterLines());
        Collections.addAll(both, this.getInnerLines());
        return both.toArray(new Line[0]);
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setFinishLine(Line finishLine) {
        this.finishLine = finishLine;
    }

    public Line getFinishLine() {
        return this.finishLine;
    }

    public void setFinishLineColor(Color finishLineColor) {
        this.finishLineColor = finishLineColor;
    }

    public Color getFinishLineColor() {
        return this.finishLineColor;
    }

    public void setStartPositions(Point[] startPositions) {
        this.startPositions = startPositions;
    }

    public Point[] getStartPositions() {
        return this.startPositions;
    }

    public void setStartVector(Vector startVector) {
        this.startVector = startVector;
    }

    public Vector getStartVector() {
        return this.startVector;
    }

    public void setCheckLines(Line[] checkLines) {
        this.checkLines = checkLines;
    }

    public Line[] getCheckLines() {
        return this.checkLines;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundImageData(byte[] backgroundImageData) {
        this.backgroundImageData = backgroundImageData;
        this.backgroundImage = backgroundImageData == null || backgroundImageData.length == 0 ? null : new ImageIcon(backgroundImageData);
    }

    public byte[] getBackgroundImageData() {
        return this.backgroundImageData;
    }

    public ImageIcon getBackgroundImage() {
        return this.backgroundImage;
    }

    @Override
    public Track getClone() {
        return new Track(this.name, this.version, this.author, (HashMap)this.descriptions.clone(), this.gridSize, CloneUtils.cloneColor(this.gridColor), CloneUtils.deepClonePoints(this.outerPoints), CloneUtils.deepClonePoints(this.innerPoints), CloneUtils.cloneColor(this.borderColor), CloneUtils.deepCloneLine(this.finishLine), CloneUtils.cloneColor(this.finishLineColor), CloneUtils.deepClonePoints(this.startPositions), CloneUtils.cloneVector(this.startVector), CloneUtils.deepCloneLines(this.checkLines), CloneUtils.cloneColor(this.backgroundColor), CloneUtils.cloneByteArray(this.backgroundImageData));
    }

    private static Polygon getPolygon(Point[] points) {
        if (points == null) {
            return new Polygon();
        }
        Polygon polygon = new Polygon();
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point pos = pointArray[n2];
            if (pos != null) {
                polygon.addPoint(pos.x, pos.y);
            }
            ++n2;
        }
        return polygon;
    }

    private static Line[] getLines(Point[] points) {
        int countPoints;
        int n = countPoints = points == null ? 0 : points.length;
        if (countPoints < 2) {
            return new Line[0];
        }
        ArrayList<Line> lines = new ArrayList<Line>();
        int i = 1;
        while (i < countPoints) {
            lines.add(new Line(points[i - 1], points[i]));
            ++i;
        }
        if (countPoints > 2) {
            lines.add(new Line(points[countPoints - 1], points[0]));
        }
        return lines.toArray(new Line[0]);
    }

    private static boolean isCornerPos(Point pos, Point[] points) {
        if (pos == null || points == null) {
            return false;
        }
        return LineRacerUtils.isPointInArray(points, pos);
    }

    private static boolean isPosOnBorderLine(Point pos, Point[] points) {
        Line[] lines;
        if (pos == null || points == null) {
            return false;
        }
        Line[] lineArray = lines = Track.getLines(points);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            if (line.contains(pos)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isPosInside(Point pos) {
        if (pos == null) {
            return false;
        }
        if (Track.isCornerPos(pos, this.outerPoints) || Track.isCornerPos(pos, this.innerPoints)) {
            return false;
        }
        Polygon outerPolygon = Track.getPolygon(this.outerPoints);
        Polygon innerPolygon = Track.getPolygon(this.innerPoints);
        if (!outerPolygon.contains(pos) || innerPolygon.contains(pos)) {
            return false;
        }
        return !Track.isPosOnBorderLine(pos, this.outerPoints) && !Track.isPosOnBorderLine(pos, this.innerPoints);
    }

    private static Line[] getCrossedBorderLines(Line line, Point[] points) {
        if (line == null || points == null) {
            return null;
        }
        Line[] borderLines = Track.getLines(points);
        ArrayList<Line> crossedLines = new ArrayList<Line>();
        Line[] lineArray = borderLines;
        int n = borderLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line borderLine = lineArray[n2];
            if (line.intersectsLine(borderLine)) {
                crossedLines.add(borderLine);
            }
            ++n2;
        }
        return crossedLines.toArray(new Line[0]);
    }

    public Line[] getCrossedBorderLines(Line line) {
        if (line == null) {
            return null;
        }
        ArrayList<Line> crossedBorderLines = new ArrayList<Line>();
        crossedBorderLines.addAll(Arrays.asList(Track.getCrossedBorderLines(line, this.outerPoints)));
        crossedBorderLines.addAll(Arrays.asList(Track.getCrossedBorderLines(line, this.innerPoints)));
        return crossedBorderLines.toArray(new Line[0]);
    }

    public Line getCrossedBorderLine(Line line) {
        if (line == null) {
            return null;
        }
        Line[] crossedBorderLines = this.getCrossedBorderLines(line);
        return crossedBorderLines != null && crossedBorderLines.length > 0 ? crossedBorderLines[0] : null;
    }

    public boolean crossesBorder(Line line) {
        return this.getCrossedBorderLine(line) != null;
    }

    public Point getBorderLineCollisionPosition(Line line) {
        Line borderLine = this.getCrossedBorderLine(line);
        return borderLine != null ? borderLine.getIntersectionPointRounded(line) : null;
    }

    private Problem getTrackAttributeProblems() {
        return !HGBaseTools.hasContent(this.name) ? new Problem(ProblemType.WARNING, "trackerr_no_track_name") : null;
    }

    private Problem[] getGridProblems() {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        this.addProblem(problems, this.gridSize < 1 || this.gridSize > 100 ? new Problem(ProblemType.ERROR, "trackerr_grid_size_valid", new String[]{String.valueOf(1), String.valueOf(100)}) : null);
        this.addProblem(problems, this.gridColor == null ? new Problem(ProblemType.WARNING, "trackerr_no_grid_color") : null);
        return problems.toArray(new Problem[0]);
    }

    private Problem[] getBorderLineProblems(Point maxGridPos) {
        int n;
        int n2;
        Point[] pointArray;
        ArrayList<Problem> problems = new ArrayList<Problem>();
        this.addProblem(problems, this.outerPoints == null || this.outerPoints.length < 3 ? new Problem(ProblemType.ERROR, "trackerr_to_less_outer_border_points") : null);
        this.addProblem(problems, this.innerPoints == null || this.innerPoints.length < 3 ? new Problem(ProblemType.ERROR, "trackerr_to_less_inner_border_points") : null);
        if (this.outerPoints != null) {
            this.addNullPositionProblems(problems, this.outerPoints, "trackerr_outer_point_not_defined", null);
            this.addInvalidGridPosProblems(problems, this.outerPoints, maxGridPos, "trackerr_outer_point_outside_grid", null);
            Polygon innerPolygon = this.getInnerPolygon();
            pointArray = this.outerPoints;
            n2 = this.outerPoints.length;
            n = 0;
            while (n < n2) {
                Point outerPoint = pointArray[n];
                if (outerPoint != null) {
                    this.addProblem(problems, innerPolygon.contains(outerPoint) ? new Problem(ProblemType.WARNING, outerPoint, "trackerr_outer_point_inside_inner_border") : null);
                }
                ++n;
            }
        }
        if (this.innerPoints != null) {
            this.addNullPositionProblems(problems, this.innerPoints, "trackerr_inner_point_not_defined", null);
            this.addInvalidGridPosProblems(problems, this.innerPoints, maxGridPos, "trackerr_inner_point_outside_grid", null);
            Polygon outerPolygon = this.getOuterPolygon();
            pointArray = this.innerPoints;
            n2 = this.innerPoints.length;
            n = 0;
            while (n < n2) {
                Point innerPoint = pointArray[n];
                if (innerPoint != null) {
                    this.addProblem(problems, !outerPolygon.contains(innerPoint) ? new Problem(ProblemType.WARNING, innerPoint, "trackerr_inner_point_outside_outer_border") : null);
                }
                ++n;
            }
        }
        Line[] outerLines = this.getOuterLines();
        this.addLineIntersectionProblems(problems, outerLines, outerLines, true, "trackerr_outer_line_intersection");
        Line[] innerLines = this.getInnerLines();
        this.addLineIntersectionProblems(problems, innerLines, innerLines, true, "trackerr_inner_line_intersection");
        this.addLineIntersectionProblems(problems, outerLines, innerLines, false, "trackerr_outer_inner_line_intersection");
        this.addProblem(problems, this.borderColor == null ? new Problem(ProblemType.WARNING, "trackerr_no_border_color") : null);
        return problems.toArray(new Problem[0]);
    }

    private Problem[] getFinishLineProblems(Point maxGridPos) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (this.finishLine == null) {
            this.addProblem(problems, new Problem(ProblemType.ERROR, "trackerr_no_finish_line"));
        } else {
            boolean startPosOnOuter = LineRacerUtils.isPointInArray(this.outerPoints, this.finishLine.getStartPos());
            boolean startPosOnInner = LineRacerUtils.isPointInArray(this.innerPoints, this.finishLine.getStartPos());
            boolean endPosOnOuter = LineRacerUtils.isPointInArray(this.outerPoints, this.finishLine.getEndPos());
            boolean endPosOnInner = LineRacerUtils.isPointInArray(this.innerPoints, this.finishLine.getEndPos());
            this.addProblem(problems, !startPosOnOuter && !startPosOnInner ? new Problem(ProblemType.WARNING, this.finishLine.getStartPos(), "trackerr_finish_line_start_pos_not_on_track") : null);
            this.addProblem(problems, !endPosOnOuter && !endPosOnInner ? new Problem(ProblemType.WARNING, this.finishLine.getEndPos(), "trackerr_finish_line_end_pos_not_on_track") : null);
            this.addProblem(problems, startPosOnOuter && endPosOnOuter || startPosOnInner && endPosOnInner ? new Problem(ProblemType.WARNING, "trackerr_finish_not_connects_outer_inner") : null);
            this.addLineIntersectionProblems(problems, new Line[]{this.finishLine}, this.getTrackLines(), false, "trackerr_finish_line_intersection");
            this.addNullPositionProblems(problems, this.finishLine.getPositions(), "trackerr_finish_line_point_not_defined", null);
            this.addInvalidGridPosProblems(problems, this.finishLine.getPositions(), maxGridPos, "trackerr_finish_line_outside_grid", null);
        }
        this.addProblem(problems, this.finishLineColor == null ? new Problem(ProblemType.WARNING, "trackerr_no_finish_line_color") : null);
        return problems.toArray(new Problem[0]);
    }

    private Problem[] getStartPositionProblems(Point maxGridPos) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (this.startPositions == null) {
            this.addProblem(problems, new Problem(ProblemType.ERROR, "trackerr_no_start_positions"));
        } else {
            this.addProblem(problems, this.startPositions.length != 6 ? new Problem(ProblemType.ERROR, "trackerr_to_less_start_positions") : null);
            int index = 0;
            while (index < this.startPositions.length) {
                String[] posPlaceholder = new String[]{String.valueOf(index + 1)};
                if (this.startPositions[index] == null) {
                    this.addProblem(problems, new Problem(ProblemType.ERROR, "trackerr_start_position_not_defined", posPlaceholder));
                } else {
                    this.addProblem(problems, !this.isPosInside(this.startPositions[index]) ? new Problem(ProblemType.WARNING, this.startPositions[index], "trackerr_start_position_not_inside_track", posPlaceholder) : null);
                    this.addProblem(problems, LineRacerUtils.isPointInArray(this.outerPoints, this.startPositions[index]) || LineRacerUtils.isPointInArray(this.innerPoints, this.startPositions[index]) ? new Problem(ProblemType.WARNING, this.startPositions[index], "trackerr_start_position_is_on_border_point", posPlaceholder) : null);
                    int index2 = index + 1;
                    while (index2 < this.startPositions.length) {
                        this.addProblem(problems, this.startPositions[index].equals(this.startPositions[index2]) ? new Problem(ProblemType.WARNING, this.startPositions[index], "trackerr_start_positions_multipe_usage", new String[]{String.valueOf(index + 1), String.valueOf(index2 + 1)}) : null);
                        ++index2;
                    }
                }
                ++index;
            }
            this.addInvalidGridPosProblems(problems, this.startPositions, maxGridPos, "trackerr_start_position_outside_grid", null);
        }
        return problems.toArray(new Problem[0]);
    }

    private Problem[] getStartVectorProblems() {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (this.startVector == null) {
            this.addProblem(problems, new Problem(ProblemType.WARNING, "trackerr_no_start_vector"));
        } else {
            this.addProblem(problems, this.startVector.getDeltaX() < -1 || this.startVector.getDeltaX() > 1 || this.startVector.getDeltaY() < -1 || this.startVector.getDeltaY() > 1 || this.startVector.getDeltaX() == 0 && this.startVector.getDeltaY() == 0 ? new Problem(ProblemType.WARNING, "trackerr_start_vector_invalid") : null);
        }
        return problems.toArray(new Problem[0]);
    }

    private Problem[] getCheckLineProblems(Point maxGridPos) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        if (this.checkLines == null || this.checkLines.length == 0) {
            this.addProblem(problems, new Problem(ProblemType.WARNING, "trackerr_no_check_lines"));
        } else {
            Line[] lineArray = this.checkLines;
            int n = this.checkLines.length;
            int n2 = 0;
            while (n2 < n) {
                Line line = lineArray[n2];
                boolean startPosOnOuter = LineRacerUtils.isPointInArray(this.outerPoints, line.getStartPos());
                boolean startPosOnInner = LineRacerUtils.isPointInArray(this.innerPoints, line.getStartPos());
                boolean endPosOnOuter = LineRacerUtils.isPointInArray(this.outerPoints, line.getEndPos());
                boolean endPosOnInner = LineRacerUtils.isPointInArray(this.innerPoints, line.getEndPos());
                String[] linePlaceholder = new String[]{line.toString()};
                this.addProblem(problems, !startPosOnOuter && !startPosOnInner ? new Problem(ProblemType.WARNING, line.getStartPos(), "trackerr_check_line_start_pos_not_on_track", linePlaceholder) : null);
                this.addProblem(problems, !endPosOnOuter && !endPosOnInner ? new Problem(ProblemType.WARNING, line.getEndPos(), "trackerr_check_line_end_pos_not_on_track", linePlaceholder) : null);
                this.addProblem(problems, startPosOnOuter && endPosOnOuter || startPosOnInner && endPosOnInner ? new Problem(ProblemType.WARNING, "trackerr_check_not_connects_outer_inner", linePlaceholder) : null);
                this.addLineIntersectionProblems(problems, new Line[]{line}, this.getTrackLines(), false, "trackerr_check_line_intersection");
                this.addNullPositionProblems(problems, line.getPositions(), "trackerr_check_line_point_not_defined", linePlaceholder);
                this.addInvalidGridPosProblems(problems, line.getPositions(), maxGridPos, "trackerr_check_line_outside_grid", linePlaceholder);
                ++n2;
            }
        }
        return problems.toArray(new Problem[0]);
    }

    private void addProblem(ArrayList<Problem> problemList, Problem problem) {
        if (problem == null) {
            return;
        }
        problemList.add(problem);
    }

    private void addProblems(ArrayList<Problem> problemList, Problem[] problems) {
        if (problems == null) {
            return;
        }
        Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Problem problem = problemArray[n2];
            this.addProblem(problemList, problem);
            ++n2;
        }
    }

    private void addNullPositionProblems(ArrayList<Problem> problemList, Point[] gridPos, String msgKey, String[] msgPlaceholders) {
        int index = 0;
        while (index < gridPos.length) {
            ArrayList<String> placeholders = new ArrayList<String>();
            placeholders.add(String.valueOf(index));
            if (msgPlaceholders != null) {
                placeholders.addAll(Arrays.asList(msgPlaceholders));
            }
            this.addProblem(problemList, gridPos[index] == null ? new Problem(ProblemType.ERROR, msgKey, placeholders.toArray(new String[0])) : null);
            ++index;
        }
    }

    private void addInvalidGridPosProblems(ArrayList<Problem> problemList, Point[] gridPos, Point maxGridPos, String msgKey, String[] msgPlaceholders) {
        Point[] pointArray = gridPos;
        int n = gridPos.length;
        int n2 = 0;
        while (n2 < n) {
            Point pos = pointArray[n2];
            if (pos != null) {
                this.addProblem(problemList, !LineRacerUtils.isGridPosValid(pos, maxGridPos) ? new Problem(ProblemType.ERROR, pos, msgKey, msgPlaceholders) : null);
            }
            ++n2;
        }
    }

    private void addLineIntersectionProblems(ArrayList<Problem> problemList, Line[] lines1, Line[] lines2, boolean equalCheck, String msgKey) {
        Line[] lineArray = lines1;
        int n = lines1.length;
        int n2 = 0;
        while (n2 < n) {
            Line line1 = lineArray[n2];
            if (line1 != null) {
                Line[] lineArray2 = lines2;
                int n3 = lines2.length;
                int n4 = 0;
                while (n4 < n3) {
                    Line line2 = lineArray2[n4];
                    if (line2 != null) {
                        this.addProblem(problemList, (!line1.equals(line2) || !equalCheck) && line1.intersectsLine(line2) && !LineRacerUtils.isPointInArray(line1.getPositions(), line2.getStartPos()) && !LineRacerUtils.isPointInArray(line1.getPositions(), line2.getEndPos()) ? new Problem(ProblemType.WARNING, msgKey, new String[]{line1.toString(), line2.toString()}) : null);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public Problem[] getTrackProblems() {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Point maxGridPos = LineRacerUtils.calcMaxGridPos(this.gridSize, 1600, 900);
        this.addProblem(problems, this.getTrackAttributeProblems());
        this.addProblems(problems, this.getGridProblems());
        this.addProblems(problems, this.getBorderLineProblems(maxGridPos));
        this.addProblems(problems, this.getFinishLineProblems(maxGridPos));
        this.addProblems(problems, this.getStartPositionProblems(maxGridPos));
        this.addProblems(problems, this.getStartVectorProblems());
        this.addProblems(problems, this.getCheckLineProblems(maxGridPos));
        return problems.toArray(new Problem[0]);
    }

    public class Problem {
        private ProblemType type;
        private Point gridPos;
        private String msgKey;
        private String[] msgPlaceholders;

        private Problem(ProblemType type, String msgKey) {
            this(type, (Point)null, msgKey, (String[])null);
        }

        private Problem(ProblemType type, String msgKey, String[] msgPlaceholders) {
            this(type, null, msgKey, msgPlaceholders);
        }

        private Problem(ProblemType type, Point gridPos, String msgKey) {
            this(type, gridPos, msgKey, (String[])null);
        }

        private Problem(ProblemType type, Point gridPos, String msgKey, String[] msgPlaceholders) {
            this.type = type;
            this.gridPos = gridPos;
            this.msgKey = msgKey;
            this.msgPlaceholders = msgPlaceholders;
        }

        public ProblemType getType() {
            return this.type;
        }

        public Point getGridPos() {
            return this.gridPos;
        }

        public String getMessage() {
            return String.valueOf(this.gridPos != null ? String.valueOf(this.gridPos.x) + "/" + this.gridPos.y + ": " : "") + HGBaseText.getText(this.msgKey, this.msgPlaceholders);
        }
    }

    public static enum ProblemType {
        WARNING,
        ERROR;

    }
}

