/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGameState;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.TrackLoader;
import com.tjger.lineracer.desktop.common.Vector;
import com.tjger.lineracer.desktop.trackdesigner.PointType;
import com.tjger.lineracer.desktop.trackdesigner.ui.DesignerPanel;
import com.tjger.lineracer.desktop.trackdesigner.ui.LRTDMainMenu;
import com.tjger.lineracer.desktop.trackdesigner.ui.LRTDStatusBar;
import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.UndoStack;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import tjger.MainFrame;
import tjger.MainMenu;
import tjger.game.GamePlayer;
import tjger.game.MoveInformation;
import tjger.game.completed.GameEngine;
import tjger.game.completed.GameManager;

public class DesignerState
extends AbstractLineRacerGameState {
    private UndoStack<Track> undoStack = new UndoStack();
    private int pointedGridPosChosenPointTypeIndex = -1;
    private PointType[] pointedGridPosChooseablePointTypes = null;
    private Point selectedGridPos = null;
    private int selectedGridPosChosenPointTypeIndex = -1;
    private Track trackBeforeDrag = null;
    private Point dragStartGridPos = null;
    private Point dragEndGridPos = null;
    private Point[] draggedPoints = null;
    private PointType draggedPointType = null;
    private int draggedCheckLineIndex = -1;
    private Line pointedTrackLine = null;
    private Line selectedTrackLine = null;
    private Track.Problem[] trackProblems = null;
    private Line newCheckLine = null;

    private void initMembers() {
        this.track = null;
        this.undoStack = new UndoStack();
        this.trackProblems = null;
        this.setBackgroundImageHidden(false);
        this.resetPointedSelectedGridPos();
        this.resetPointedSelectedTrackLine();
        this.resetDragInformation();
        this.resetNewCheckLineInformation();
        this.enableUndoRedoMenuItems();
        this.checkTrackProblems();
    }

    private void resetPointedSelectedGridPos() {
        this.pointedGridPosChooseablePointTypes = null;
        this.setPointedGridPosChosenPointTypeIndex(-1);
        this.resetSelectedGridPos();
    }

    private void resetSelectedGridPos() {
        this.setSelectedGridPos(null);
        this.setSelectedGridPosChosenPointTypeIndex(-1);
    }

    private void resetPointedSelectedTrackLine() {
        this.setPointedTrackLine(null);
        this.resetSelectedTrackLine();
    }

    private void resetSelectedTrackLine() {
        this.setSelectedTrackLine(null);
    }

    public void resetSelectionInformation() {
        this.resetSelectedGridPos();
        this.resetSelectedTrackLine();
    }

    private void resetDragInformation() {
        this.trackBeforeDrag = null;
        this.dragStartGridPos = null;
        this.dragEndGridPos = null;
        this.draggedPoints = null;
        this.draggedPointType = null;
        this.draggedCheckLineIndex = -1;
    }

    public void resetNewCheckLineInformation() {
        this.newCheckLine = null;
    }

    public void setTrack(Track track) {
        this.track = track;
    }

    public void setTrackName(String name) {
        this.track.setName(name);
    }

    public void setTrackVersion(String version) {
        this.track.setVersion(version);
    }

    public void setTrackDescriptions(HashMap<String, String> descriptions) {
        this.track.setDescriptions(descriptions);
    }

    public void setTrackAuthor(String author) {
        this.track.setAuthor(author);
    }

    public void setGridSize(int gridSize) {
        this.track.setGridSize(gridSize);
    }

    public void setGridColor(Color gridColor) {
        this.track.setGridColor(gridColor);
    }

    public void setOuterPoints(Point[] outerPoints) {
        this.track.setOuterPoints(outerPoints);
    }

    public void setInnerPoints(Point[] innerPoints) {
        this.track.setInnerPoints(innerPoints);
    }

    public void setBorderColor(Color borderColor) {
        this.track.setBorderColor(borderColor);
    }

    public void setFinishLine(Line finishLine) {
        this.track.setFinishLine(finishLine);
    }

    public void setFinishLineColor(Color finishLineColor) {
        this.track.setFinishLineColor(finishLineColor);
    }

    public void setStartPosition(Point[] startPositions) {
        this.track.setStartPositions(startPositions);
    }

    public Point[] getStartPositions() {
        return this.track.getStartPositions();
    }

    public Vector getStartVector() {
        return this.track.getStartVector();
    }

    public void setStartVector(Vector startVector) {
        this.track.setStartVector(startVector);
    }

    public Line[] getCheckLines() {
        return this.track.getCheckLines();
    }

    public void setCheckLines(Line[] checkLines) {
        this.track.setCheckLines(checkLines);
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.track.setBackgroundColor(backgroundColor);
    }

    public void setBackgroundImageData(byte[] backgroundImageData) {
        this.addCurrentTrackToUndoStack();
        this.track.setBackgroundImageData(backgroundImageData);
        this.setTrackChanged(true);
        this.enableBackgroundImageMenuItems();
    }

    public void removeBackgroundImage() {
        this.addCurrentTrackToUndoStack();
        this.track.setBackgroundImageData(null);
        this.setTrackChanged(true);
        this.enableBackgroundImageMenuItems();
    }

    public void addCurrentTrackToUndoStack() {
        this.addTrackToUndoStack(this.getTrack());
    }

    private void addTrackToUndoStack(Track track) {
        this.undoStack.addState(track);
        this.enableUndoRedoMenuItems();
    }

    public void undoModification() {
        this.setTrack(this.undoStack.performUndo(this.getTrack()));
        this.enableUndoRedoMenuItems();
        this.enableBackgroundImageMenuItems();
        this.setTrackChanged(true);
        this.resetPointedSelectedGridPos();
        this.resetPointedSelectedTrackLine();
        this.resetNewCheckLineInformation();
        this.checkTrackProblems();
    }

    public void redoModification() {
        this.setTrack(this.undoStack.performRedo());
        this.enableUndoRedoMenuItems();
        this.enableBackgroundImageMenuItems();
        this.setTrackChanged(true);
        this.resetPointedSelectedGridPos();
        this.resetPointedSelectedTrackLine();
        this.resetNewCheckLineInformation();
        this.checkTrackProblems();
    }

    private GameManager getGameManager() {
        return GameManager.getInstance();
    }

    private MainFrame getMainFrame() {
        return this.getGameManager().getMainFrame();
    }

    private MainMenu getMainMenu() {
        return this.getMainFrame().getMainMenu();
    }

    private void setTrackChanged(boolean changed) {
        this.getMainFrame().setChanged(changed);
    }

    public void setPointedGridPosChooseablePointTypes(Point pointedGridPos) {
        this.pointedGridPosChooseablePointTypes = this.getChooseablePointTypes(pointedGridPos);
        this.setPointedGridPosChosenPointTypeIndex(this.pointedGridPosChooseablePointTypes != null && this.pointedGridPosChooseablePointTypes.length > 0 ? 0 : -1);
    }

    public PointType getPointedGridPosChosenPointType() {
        return this.pointedGridPosChooseablePointTypes == null || this.pointedGridPosChosenPointTypeIndex < 0 || this.pointedGridPosChosenPointTypeIndex >= this.pointedGridPosChooseablePointTypes.length ? null : this.pointedGridPosChooseablePointTypes[this.pointedGridPosChosenPointTypeIndex];
    }

    private void setPointedGridPosChosenPointTypeIndex(int index) {
        this.pointedGridPosChosenPointTypeIndex = index;
        if (this.getSelectedGridPos() == null) {
            LRTDStatusBar.setChosenPointType(this.getPointedGridPosChosenPointType());
        }
        this.enablePointMenuItems();
    }

    public void chooseNextPointType() {
        int newIndex;
        PointType[] types;
        if (this.getSelectedGridPos() == null) {
            types = this.pointedGridPosChooseablePointTypes;
            newIndex = this.pointedGridPosChosenPointTypeIndex;
        } else {
            types = this.getChooseablePointTypes(this.getSelectedGridPos());
            newIndex = this.selectedGridPosChosenPointTypeIndex;
        }
        if (types == null || types.length == 0) {
            newIndex = -1;
        } else if (++newIndex >= types.length) {
            newIndex = 0;
        }
        this.setChosenPointTypeIndex(newIndex);
    }

    public void setChosenPointTypeIndex(int index) {
        if (this.getSelectedGridPos() == null) {
            this.setPointedGridPosChosenPointTypeIndex(index);
        } else {
            this.setSelectedGridPosChosenPointTypeIndex(index);
        }
    }

    public void setChosenPointType(PointType pointType) {
        int index = this.getSelectedGridPos() == null ? Arrays.asList(this.pointedGridPosChooseablePointTypes).indexOf((Object)pointType) : Arrays.asList(this.getChooseablePointTypes(this.getSelectedGridPos())).indexOf((Object)pointType);
        this.setChosenPointTypeIndex(index);
    }

    private PointType getChosenPointType() {
        PointType pointType = this.getSelectedGridPosChosenPointType();
        return pointType != null ? pointType : this.getPointedGridPosChosenPointType();
    }

    public void setSelectedGridPos(Point gridPos) {
        this.selectedGridPos = gridPos;
        this.setSelectedGridPosChosenPointTypeIndex(this.pointedGridPosChosenPointTypeIndex);
    }

    public Point getSelectedGridPos() {
        return this.selectedGridPos;
    }

    public PointType getSelectedGridPosChosenPointType() {
        PointType[] posUsage = this.getChooseablePointTypes(this.selectedGridPos);
        return posUsage == null || this.selectedGridPosChosenPointTypeIndex < 0 || this.selectedGridPosChosenPointTypeIndex >= posUsage.length ? null : posUsage[this.selectedGridPosChosenPointTypeIndex];
    }

    private void setSelectedGridPosChosenPointTypeIndex(int index) {
        this.selectedGridPosChosenPointTypeIndex = index;
        LRTDStatusBar.setChosenPointType(this.getSelectedGridPosChosenPointType());
        this.enablePointMenuItems();
    }

    public Point getDragStartGridPos() {
        return this.dragStartGridPos;
    }

    public void startDrag(Point gridPos) {
        PointType chosenPointType;
        this.draggedPointType = chosenPointType = this.getChosenPointType();
        if (chosenPointType == null) {
            this.draggedPoints = null;
            this.dragStartGridPos = null;
            return;
        }
        switch (chosenPointType) {
            case OUTER_LINE_POS: 
            case INNER_LINE_POS: {
                this.startDragTrackPoint(gridPos);
                break;
            }
            case FINISH_LINE_START_POS: 
            case FINISH_LINE_END_POS: {
                this.startDragFinishLinePoint(gridPos);
                break;
            }
            case CHECK_LINE_START_POS: 
            case CHECK_LINE_END_POS: {
                this.startDragCheckLinePoint(gridPos, chosenPointType);
                break;
            }
            case START_POS: {
                this.startDragStartPos(gridPos);
            }
        }
    }

    private void startDragTrackPoint(Point gridPos) {
        this.dragStartGridPos = gridPos;
        this.trackBeforeDrag = this.track.getClone();
        this.draggedPoints = this.getPointsAtPosition(gridPos, null);
    }

    private void startDragFinishLinePoint(Point gridPos) {
        this.dragStartGridPos = gridPos;
        this.trackBeforeDrag = this.track.getClone();
        ArrayList<Point> points = new ArrayList<Point>();
        this.addPointToList(points, this.getFinishLine().getPositions(), gridPos);
        this.draggedPoints = points.toArray(new Point[0]);
    }

    private void startDragCheckLinePoint(Point gridPos, PointType pointType) {
        this.dragStartGridPos = gridPos;
        this.trackBeforeDrag = this.track.getClone();
        Line[] checkLines = this.getCheckLinesFromPoint(gridPos, pointType);
        this.draggedCheckLineIndex = checkLines.length - 1;
        this.draggedPoints = new Point[]{PointType.CHECK_LINE_START_POS.equals((Object)pointType) ? checkLines[this.draggedCheckLineIndex].getStartPos() : checkLines[this.draggedCheckLineIndex].getEndPos()};
    }

    private void startDragStartPos(Point gridPos) {
        this.dragStartGridPos = gridPos;
        this.trackBeforeDrag = this.track.getClone();
        this.draggedPoints = this.getPointsAtPosition(gridPos, new ArrayList<PointType>(Arrays.asList(PointType.START_POS)));
    }

    public void stopDrag() {
        if (this.dragStartGridPos == null || this.dragEndGridPos == null || this.dragStartGridPos.equals(this.dragEndGridPos)) {
            this.resetDragInformation();
            return;
        }
        this.addTrackToUndoStack(this.trackBeforeDrag);
        this.setTrackChanged(true);
        this.enableUndoRedoMenuItems();
        this.resetDragInformation();
        this.checkTrackProblems();
    }

    public void setDragEndGridPos(Point gridPos) {
        if (this.draggedPoints == null) {
            return;
        }
        if (!this.isDragEndGridPosAllowed(gridPos)) {
            return;
        }
        this.dragEndGridPos = gridPos;
        Point[] pointArray = this.draggedPoints;
        int n = this.draggedPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point draggedPoint = pointArray[n2];
            draggedPoint.setLocation(gridPos);
            ++n2;
        }
    }

    private Line[] getCheckLinesFromPoint(Point gridPos, PointType pointType) {
        Line[] checkLines;
        ArrayList<Line> lines = new ArrayList<Line>();
        Line[] lineArray = checkLines = this.getCheckLines();
        int n = checkLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            if (gridPos.equals(PointType.CHECK_LINE_START_POS.equals((Object)pointType) ? line.getStartPos() : line.getEndPos())) {
                lines.add(line);
            }
            ++n2;
        }
        return lines.toArray(new Line[0]);
    }

    private boolean isTrackLinePoint(Point gridPos) {
        return LineRacerUtils.isPointInArray(this.getOuterPoints(), gridPos) || LineRacerUtils.isPointInArray(this.getInnerPoints(), gridPos);
    }

    private boolean isDragEndGridPosAllowed(Point gridPos) {
        if (this.draggedPointType == null) {
            return false;
        }
        switch (this.draggedPointType) {
            case OUTER_LINE_POS: 
            case INNER_LINE_POS: {
                return !this.isTrackLinePoint(gridPos) && !LineRacerUtils.isPointInArray(this.getStartPositions(), gridPos);
            }
            case FINISH_LINE_START_POS: {
                return this.isTrackLinePoint(gridPos) && !gridPos.equals(this.getFinishLine().getEndPos());
            }
            case FINISH_LINE_END_POS: {
                return this.isTrackLinePoint(gridPos) && !gridPos.equals(this.getFinishLine().getStartPos());
            }
            case CHECK_LINE_START_POS: {
                return this.isTrackLinePoint(gridPos) && !gridPos.equals(this.getCheckLines()[this.draggedCheckLineIndex].getEndPos());
            }
            case CHECK_LINE_END_POS: {
                return this.isTrackLinePoint(gridPos) && !gridPos.equals(this.getCheckLines()[this.draggedCheckLineIndex].getStartPos());
            }
            case START_POS: {
                return !this.isTrackLinePoint(gridPos) && !LineRacerUtils.isPointInArray(this.getStartPositions(), gridPos);
            }
        }
        return false;
    }

    public Point getDragEndGridPos() {
        return this.dragEndGridPos;
    }

    public PointType[] getChooseablePointTypes(Point gridPos) {
        Line[] checkLines;
        Line finishLine;
        if (gridPos == null || this.track == null) {
            return null;
        }
        ArrayList<PointType> types = new ArrayList<PointType>();
        if (LineRacerUtils.isPointInArray(this.getOuterPoints(), gridPos)) {
            types.add(PointType.OUTER_LINE_POS);
        }
        if (LineRacerUtils.isPointInArray(this.getInnerPoints(), gridPos)) {
            types.add(PointType.INNER_LINE_POS);
        }
        if (gridPos.equals((finishLine = this.getFinishLine()).getStartPos())) {
            types.add(PointType.FINISH_LINE_START_POS);
        }
        if (gridPos.equals(finishLine.getEndPos())) {
            types.add(PointType.FINISH_LINE_END_POS);
        }
        if ((checkLines = this.getCheckLines()) != null) {
            Line[] lineArray = checkLines;
            int n = checkLines.length;
            int n2 = 0;
            while (n2 < n) {
                Line checkLine = lineArray[n2];
                if (gridPos.equals(checkLine.getStartPos())) {
                    types.add(PointType.CHECK_LINE_START_POS);
                }
                if (gridPos.equals(checkLine.getEndPos())) {
                    types.add(PointType.CHECK_LINE_END_POS);
                }
                ++n2;
            }
        }
        if (LineRacerUtils.isPointInArray(this.getStartPositions(), gridPos)) {
            types.add(PointType.START_POS);
        }
        return types.toArray(new PointType[0]);
    }

    public int getCountChooseablePointTypes(Point gridPos) {
        if (gridPos == null) {
            return 0;
        }
        return this.getChooseablePointTypes(gridPos).length;
    }

    public PointType[] getChooseablePointTypes() {
        PointType[] pointTypes = this.selectedGridPos != null ? this.getChooseablePointTypes(this.selectedGridPos) : this.pointedGridPosChooseablePointTypes;
        return pointTypes;
    }

    private void addPointToList(ArrayList<Point> pointList, Point[] points, Point point) {
        int index = LineRacerUtils.getPointIndex(points, point);
        if (index > -1) {
            pointList.add(points[index]);
        }
    }

    private Point[] getPointsAtPosition(Point gridPos, ArrayList<PointType> pointTypes) {
        Line[] checkLines;
        ArrayList<Point> points = new ArrayList<Point>();
        if (pointTypes == null || pointTypes.contains((Object)PointType.OUTER_LINE_POS)) {
            this.addPointToList(points, this.getOuterPoints(), gridPos);
        }
        if (pointTypes == null || pointTypes.contains((Object)PointType.INNER_LINE_POS)) {
            this.addPointToList(points, this.getInnerPoints(), gridPos);
        }
        if (pointTypes == null || pointTypes.contains((Object)PointType.FINISH_LINE_START_POS) || pointTypes.contains((Object)PointType.FINISH_LINE_END_POS)) {
            this.addPointToList(points, this.getFinishLine().getPositions(), gridPos);
        }
        if ((checkLines = this.getCheckLines()) != null && (pointTypes == null || pointTypes.contains((Object)PointType.CHECK_LINE_START_POS) || pointTypes.contains((Object)PointType.CHECK_LINE_END_POS))) {
            Line[] lineArray = checkLines;
            int n = checkLines.length;
            int n2 = 0;
            while (n2 < n) {
                Line checkLine = lineArray[n2];
                this.addPointToList(points, checkLine.getPositions(), gridPos);
                ++n2;
            }
        }
        if (pointTypes == null || pointTypes.contains((Object)PointType.START_POS)) {
            this.addPointToList(points, this.getStartPositions(), gridPos);
        }
        return points.toArray(new Point[0]);
    }

    private void enablePointMenuItems() {
        PointType chosenPointType = this.getChosenPointType();
        boolean enable = chosenPointType != null;
        MainMenu mainMenu = this.getMainMenu();
        mainMenu.setItemEnabled("edit.removepoint", enable);
        mainMenu.setItemEnabled("edit.addcheckline", enable);
    }

    private void enableLineMenuItems() {
        Line chosenLine = this.getChosenTrackLine();
        boolean enable = chosenLine != null;
        MainMenu mainMenu = this.getMainMenu();
        mainMenu.setItemEnabled("edit.addpoint", enable);
    }

    private void enableBackgroundImageMenuItems() {
        MainMenu mainMenu = this.getMainMenu();
        mainMenu.setItemEnabled("edit.removebackgroundimage", this.isRemoveBackgroundImageAllowed());
        mainMenu.setItemEnabled("edit.showhidebackgroundimage", this.isShowHideBackgroundImageAllowed());
    }

    private void enableUndoRedoMenuItems() {
        MainMenu mainMenu = this.getMainMenu();
        mainMenu.setItemEnabled("edit.undo", this.undoStack.isUndoAvailable());
        mainMenu.setItemEnabled("edit.redo", this.undoStack.isRedoAvailable());
    }

    public boolean isRemoveBackgroundImageAllowed() {
        return this.getBackgroundImage() != null;
    }

    private Point getChosenGridPos() {
        Point gridPos = this.getSelectedGridPos();
        return gridPos != null ? gridPos : this.getPointedGridPos();
    }

    private Point getPointedGridPos() {
        return ((DesignerPanel)this.getMainFrame().getGamePanel()).getPointedGridPos();
    }

    public void addPointToChosenTrackLine() {
        Line chosenLine = this.getSelectedTrackLine();
        Point newPoint = null;
        if (chosenLine == null) {
            chosenLine = this.getPointedTrackLine();
            newPoint = this.getPointedGridPos();
        } else if (chosenLine.equals(this.getPointedTrackLine())) {
            newPoint = this.getPointedGridPos();
        }
        if (chosenLine == null) {
            return;
        }
        if (this.isTrackLinePoint(newPoint)) {
            newPoint = null;
        }
        Point startPos = chosenLine.getStartPos();
        if (newPoint == null) {
            Vector vector = chosenLine.getVector();
            double tanAngle = Math.tan(vector.getAngleRad());
            if (vector.getDeltaX() > vector.getDeltaY()) {
                int dx = 1;
                while (dx < vector.getDeltaX()) {
                    int dy = (int)Math.round((double)dx * tanAngle);
                    Point testPoint = new Point(startPos.x + dx, startPos.y + dy);
                    if (!this.isTrackLinePoint(testPoint)) {
                        newPoint = testPoint;
                        break;
                    }
                    ++dx;
                }
            } else {
                int dy = 1;
                while (dy < vector.getDeltaY()) {
                    int dx = (int)Math.round((double)dy * (1.0 / tanAngle));
                    Point testPoint = new Point(startPos.x + dx, startPos.y + dy);
                    if (!this.isTrackLinePoint(testPoint)) {
                        newPoint = testPoint;
                        break;
                    }
                    ++dy;
                }
            }
        }
        if (newPoint == null) {
            this.showErrorDialog("err_no_possible_add_point");
            return;
        }
        Point[] points = this.getOuterPoints();
        int indexStartPos = LineRacerUtils.getPointIndex(points, startPos);
        boolean useOuterPoints = true;
        if (indexStartPos == -1) {
            points = this.getInnerPoints();
            indexStartPos = LineRacerUtils.getPointIndex(points, startPos);
            useOuterPoints = false;
        }
        if (indexStartPos == -1) {
            this.showErrorDialog("err_track_line_not_found");
            return;
        }
        this.addCurrentTrackToUndoStack();
        ArrayList<Point> pointList = new ArrayList<Point>(Arrays.asList(points));
        pointList.add(indexStartPos + 1, newPoint);
        if (useOuterPoints) {
            this.setOuterPoints(pointList.toArray(new Point[0]));
        } else {
            this.setInnerPoints(pointList.toArray(new Point[0]));
        }
        this.confirmNewCheckLineEndPosition(new Point(newPoint), false);
        this.resetPointedSelectedTrackLine();
        this.setTrackChanged(true);
        this.checkTrackProblems();
    }

    public void removeChosenPoint() {
        PointType pointType = this.getChosenPointType();
        if (pointType == null) {
            return;
        }
        Point gridPos = this.getChosenGridPos();
        if (gridPos == null) {
            return;
        }
        switch (pointType) {
            case OUTER_LINE_POS: 
            case INNER_LINE_POS: {
                ArrayList<Point> points = PointType.OUTER_LINE_POS.equals((Object)pointType) ? new ArrayList<Point>(Arrays.asList(this.getOuterPoints())) : new ArrayList<Point>(Arrays.asList(this.getInnerPoints()));
                if (!this.checkDeleteTrackPoint(points.size())) {
                    return;
                }
                if (this.showQuestionDialog("question_delete_track_point") == 1) {
                    return;
                }
                this.addCurrentTrackToUndoStack();
                points.remove(gridPos);
                if (PointType.OUTER_LINE_POS.equals((Object)pointType)) {
                    this.setOuterPoints(points.toArray(new Point[0]));
                } else {
                    this.setInnerPoints(points.toArray(new Point[0]));
                }
                this.resetPointedSelectedGridPos();
                this.resetPointedSelectedTrackLine();
                this.resetNewCheckLineInformation();
                LRTDStatusBar.clearInfo();
                this.setTrackChanged(true);
                this.checkTrackProblems();
                break;
            }
            case FINISH_LINE_START_POS: 
            case FINISH_LINE_END_POS: {
                this.showErrorDialog("err_delete_finish_line");
                break;
            }
            case CHECK_LINE_START_POS: 
            case CHECK_LINE_END_POS: {
                if (this.showQuestionDialog("question_delete_check_line") == 1) {
                    return;
                }
                this.addCurrentTrackToUndoStack();
                ArrayList<Line> checkLines = new ArrayList<Line>(Arrays.asList(this.getCheckLines()));
                for (Line checkLine : checkLines) {
                    if ((pointType != PointType.CHECK_LINE_START_POS || !gridPos.equals(checkLine.getStartPos())) && (pointType != PointType.CHECK_LINE_END_POS || !gridPos.equals(checkLine.getEndPos()))) continue;
                    checkLines.remove(checkLine);
                    break;
                }
                this.setCheckLines(checkLines.toArray(new Line[0]));
                this.resetPointedSelectedGridPos();
                this.resetPointedSelectedTrackLine();
                this.resetNewCheckLineInformation();
                LRTDStatusBar.clearInfo();
                this.setTrackChanged(true);
                this.checkTrackProblems();
                break;
            }
            case START_POS: {
                this.showErrorDialog("err_delete_start_pos");
            }
        }
    }

    private boolean checkDeleteTrackPoint(int countTrackPoints) {
        if (countTrackPoints <= 3) {
            this.showErrorDialog("err_to_less_track_points");
            return false;
        }
        List<PointType> pointTypes = Arrays.asList(this.getChooseablePointTypes());
        if (pointTypes.contains((Object)PointType.FINISH_LINE_START_POS) || pointTypes.contains((Object)PointType.FINISH_LINE_END_POS) || pointTypes.contains((Object)PointType.CHECK_LINE_START_POS) || pointTypes.contains((Object)PointType.CHECK_LINE_END_POS)) {
            this.showErrorDialog("err_other_usage_for_track_point");
            return false;
        }
        return true;
    }

    public Line getPointedTrackLine() {
        return this.pointedTrackLine;
    }

    public void setPointedTrackLine(Line line) {
        this.pointedTrackLine = line;
        this.enableLineMenuItems();
    }

    public Line getSelectedTrackLine() {
        return this.selectedTrackLine;
    }

    public void setSelectedTrackLine(Line line) {
        this.selectedTrackLine = line;
        this.enableLineMenuItems();
    }

    private Line getChosenTrackLine() {
        Line line = this.getSelectedTrackLine();
        return line != null ? line : this.getPointedTrackLine();
    }

    public void checkTrackProblems() {
        this.trackProblems = this.track != null ? this.track.getTrackProblems() : null;
        LRTDStatusBar.setProblemState(this.trackProblems != null && this.trackProblems.length > 0);
    }

    public Track.Problem[] getTrackProblems() {
        return this.trackProblems;
    }

    public Track.Problem[] getTrackErrors() {
        Track.Problem[] problems = this.getTrackProblems();
        ArrayList<Track.Problem> errors = new ArrayList<Track.Problem>();
        Track.Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Track.Problem problem = problemArray[n2];
            if (Track.ProblemType.ERROR.equals((Object)problem.getType())) {
                errors.add(problem);
            }
            ++n2;
        }
        return errors.toArray(new Track.Problem[0]);
    }

    public void setNewCheckLineStartPosition() {
        Point chosenGridPos = this.getChosenGridPos();
        if (chosenGridPos == null) {
            return;
        }
        this.newCheckLine = new Line(chosenGridPos, null);
        this.resetPointedSelectedGridPos();
        this.resetPointedSelectedTrackLine();
    }

    public void setNewCheckLineEndPosition(Point gridPos) {
        if (gridPos == null || this.newCheckLine == null) {
            return;
        }
        this.newCheckLine.setEndPos(gridPos);
    }

    public void confirmNewCheckLineEndPosition(Point gridPos, boolean addUndo) {
        if (gridPos == null || this.newCheckLine == null) {
            return;
        }
        if (!this.isTrackLinePoint(gridPos) || gridPos.equals(this.newCheckLine.getStartPos())) {
            this.showErrorDialog("err_no_valid_check_line_point");
            this.resetNewCheckLineInformation();
            return;
        }
        if (addUndo) {
            this.addCurrentTrackToUndoStack();
        }
        this.newCheckLine.setEndPos(gridPos);
        ArrayList<Line> checkLines = new ArrayList<Line>(Arrays.asList(this.getCheckLines()));
        checkLines.add(this.newCheckLine);
        this.setCheckLines(checkLines.toArray(new Line[0]));
        this.resetNewCheckLineInformation();
        this.resetPointedSelectedGridPos();
        this.resetPointedSelectedTrackLine();
        this.setTrackChanged(true);
        this.checkTrackProblems();
    }

    public Line getNewCheckLine() {
        return this.newCheckLine;
    }

    private String getAppName() {
        return HGBaseSettings.get("appName");
    }

    private void showErrorDialog(String msgKey) {
        HGBaseDialog.printError(msgKey, (JFrame)this.getMainFrame());
    }

    private int showQuestionDialog(String msgKey) {
        return HGBaseDialog.showConfirmDialog(this.getMainFrame(), HGBaseText.getText(msgKey, new String[0]), this.getAppName());
    }

    @Override
    public void resetGame(GameEngine engine) {
    }

    @Override
    public void resetRound(GameEngine engine) {
    }

    @Override
    public void resetTurn(GameEngine engine) {
    }

    @Override
    public void stopGame() {
        this.initMembers();
    }

    @Override
    public void changeState(GamePlayer player, MoveInformation move, GameEngine engine) {
    }

    @Override
    public void undoMove(GamePlayer player, MoveInformation move) {
    }

    @Override
    public int save(Document doc, Element root) {
        TrackLoader.saveTrack(this.track, doc, root);
        return 0;
    }

    @Override
    public int load(Node node) {
        this.track = TrackLoader.loadTrack(node);
        this.checkTrackProblems();
        this.enableBackgroundImageMenuItems();
        Track.Problem[] trackErrors = this.getTrackErrors();
        ((LRTDMainMenu)this.getMainMenu()).setTrackErrors(trackErrors);
        return trackErrors.length > 0 ? -87225 : 0;
    }

    @Override
    public String toNetworkString() {
        return null;
    }

    @Override
    public boolean fromNetworkString(String data) {
        return false;
    }

    @Override
    public String toNetworkStringMove(MoveInformation move) {
        return null;
    }

    @Override
    public MoveInformation fromNetworkStringMove(String data) {
        return null;
    }
}

