/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGamePanel;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.Vector;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.PointType;
import com.tjger.lineracer.desktop.trackdesigner.ui.KeyListener;
import com.tjger.lineracer.desktop.trackdesigner.ui.MouseListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import tjger.gui.completed.Part;

public class DesignerPanel
extends AbstractLineRacerGamePanel {
    public static final Color CHECK_LINE_COLOR = Color.LIGHT_GRAY.darker();
    private static final int LINE_DOT_SIZE = 6;
    private static final int POINTED_LINE_DOT_CIRCLE_SIZE = 10;
    private static final int START_VECTOR_ARROW_SIZE = 3;
    public static final int START_POS_DOT_SIZE = 4;
    public static final float START_POS_FONT_SIZE = 6.0f;
    public static final Color START_POS_COLOR = Color.BLACK;
    private static final int POINTED_START_POS_DOT_CIRCLE_SIZE = 8;

    public DesignerPanel() {
        MouseListener mouseListener = new MouseListener(this, this.getDesignerState());
        this.addMouseMotionListener(mouseListener);
        this.addMouseListener(mouseListener);
        this.addKeyListener(new KeyListener(this, this.getDesignerState()));
        this.setFocusable(true);
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public boolean isPaintingAllowed() {
        return this.getDesignerState().getTrack() != null;
    }

    private DesignerState getDesignerState() {
        return (DesignerState)this.getGameState();
    }

    @Override
    protected void paintParts(Graphics g) {
        DesignerState state = this.getDesignerState();
        int gridSize = 0;
        if (this.isPaintingAllowed()) {
            gridSize = state.getGridSize();
            this.calcMaxGridPos(gridSize);
        }
        super.paintParts(g);
        if (this.isPaintingAllowed()) {
            this.paintCheckLines(state.getCheckLines(), gridSize, g);
            this.paintNewCheckLine(state.getNewCheckLine(), gridSize, g);
            this.paintStartVectors(state.getStartVector(), state.getFinishLine(), state.getFinishLineColor(), gridSize, g);
            this.paintMarkedGridPos(this.getPointedGridPos(), state.getPointedGridPosChosenPointType(), state.getBorderColor(), state.getFinishLineColor(), CHECK_LINE_COLOR, gridSize, g);
            this.paintMarkedGridPos(state.getSelectedGridPos(), state.getSelectedGridPosChosenPointType(), state.getBorderColor(), state.getFinishLineColor(), CHECK_LINE_COLOR, gridSize, g);
            this.paintMarkedTrackLine(state.getPointedTrackLine(), gridSize, g);
            this.paintMarkedTrackLine(state.getSelectedTrackLine(), gridSize, g);
            this.paintStartPositions(state.getStartPositions(), gridSize, g);
            this.paintProblemMarkers(state.getTrackProblems(), gridSize, g);
        }
    }

    private void paintCheckLines(Line[] checkLines, int gridSize, Graphics g) {
        if (checkLines == null) {
            return;
        }
        Color oldColor = this.changeColor(CHECK_LINE_COLOR, g);
        Line[] lineArray = checkLines;
        int n = checkLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            this.paintGridLine(line, gridSize, g);
            ++n2;
        }
        this.changeColor(oldColor, g);
    }

    private void paintNewCheckLine(Line newCheckLine, int gridSize, Graphics g) {
        if (newCheckLine == null) {
            return;
        }
        Color oldColor = this.changeColor(CHECK_LINE_COLOR, g);
        this.paintGridLine(newCheckLine, gridSize, g);
        this.changeColor(oldColor, g);
    }

    private void paintStartVector(Vector startVector, Point startPos, int gridSize, Graphics g) {
        if (startVector == null) {
            return;
        }
        Point screenStartPos = DesignerPanel.convertGridPosToScreenPos(startPos, gridSize);
        Point screenEndPos = DesignerPanel.convertGridPosToScreenPos(startVector.calcEndPos(startPos), gridSize);
        this.drawArrow(screenStartPos.x, screenStartPos.y, screenEndPos.x, screenEndPos.y, 3, g);
    }

    private void paintStartVectors(Vector startVector, Line finishLine, Color finishLineColor, int gridSize, Graphics g) {
        Color oldColor = this.changeColor(finishLineColor, g);
        this.paintStartVector(startVector, finishLine.getStartPos(), gridSize, g);
        this.paintStartVector(startVector, finishLine.getEndPos(), gridSize, g);
        this.changeColor(oldColor, g);
    }

    @Override
    protected void paintGridLine(Point startPos, Point endPos, int gridSize, Graphics g) {
        super.paintGridLine(startPos, endPos, gridSize, g);
        this.paintGridDot(startPos, 6, gridSize, g);
        this.paintGridDot(endPos, 6, gridSize, g);
    }

    @Override
    protected void paintTrackLine(Point[] outerLinePoints, Point[] innerLinePoints, Color lineColor, int gridSize, Graphics g) {
        super.paintTrackLine(outerLinePoints, innerLinePoints, lineColor, gridSize, g);
        this.paintGridDots(outerLinePoints, 6, lineColor, gridSize, g);
        this.paintGridDots(innerLinePoints, 6, lineColor, gridSize, g);
    }

    protected void paintMarkedGridPos(Point gridPos, PointType pointType, Color borderColor, Color finishLineColor, Color checkLineColor, int gridSize, Graphics g) {
        int dotSize;
        Color color;
        if (gridPos == null || pointType == null) {
            return;
        }
        switch (pointType) {
            case OUTER_LINE_POS: 
            case INNER_LINE_POS: {
                color = borderColor;
                dotSize = 10;
                break;
            }
            case FINISH_LINE_START_POS: 
            case FINISH_LINE_END_POS: {
                color = finishLineColor;
                dotSize = 10;
                break;
            }
            case CHECK_LINE_START_POS: 
            case CHECK_LINE_END_POS: {
                color = checkLineColor;
                dotSize = 10;
                break;
            }
            case START_POS: {
                color = START_POS_COLOR;
                dotSize = 8;
                break;
            }
            default: {
                return;
            }
        }
        Color oldColor = this.changeColor(color, g);
        this.paintGridCircle(gridPos, dotSize, gridSize, g);
        this.changeColor(oldColor, g);
    }

    protected void paintMarkedTrackLine(Line line, int gridSize, Graphics g) {
        if (line == null) {
            return;
        }
        Line screenLine = new Line(DesignerPanel.convertGridPosToScreenPos(line.getStartPos(), gridSize), DesignerPanel.convertGridPosToScreenPos(line.getEndPos(), gridSize));
        Polygon lineRect = screenLine.toRectangle(10);
        Stroke oldStroke = this.changeStroke(new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{9.0f}, 0.0f), g);
        this.drawPolygon(lineRect, false, g);
        this.changeStroke(oldStroke, g);
    }

    protected void paintStartPositions(Point[] startPositions, int gridSize, Graphics g) {
        if (startPositions == null) {
            return;
        }
        Font oldFont = this.changeFont(6.0f, g);
        Color oldColor = this.changeColor(START_POS_COLOR, g);
        int index = 0;
        while (index < startPositions.length) {
            Point pos = startPositions[index];
            if (pos != null) {
                this.paintGridDot(pos, 4, gridSize, g);
                Point screenPos = DesignerPanel.convertGridPosToScreenPos(pos, gridSize);
                this.drawString(String.valueOf(index + 1), screenPos.x + 1, screenPos.y - 1, g);
            }
            ++index;
        }
        this.changeFont(oldFont, g);
        this.changeColor(oldColor, g);
    }

    protected void paintProblemMarkers(Track.Problem[] problems, int gridSize, Graphics g) {
        if (problems == null) {
            return;
        }
        Part markerPart = this.getGameConfig().getPart("problem", "problem");
        Track.Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Track.Problem problem = problemArray[n2];
            if (problem.getGridPos() != null) {
                Point screenPos = DesignerPanel.convertGridPosToScreenPos(problem.getGridPos(), gridSize);
                this.drawPart(screenPos.x, screenPos.y, 20, markerPart, g);
            }
            ++n2;
        }
    }
}

