/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.DesignerPanel;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;

public class KeyListener
extends KeyAdapter {
    private DesignerPanel designerPanel;
    private DesignerState designerState;

    public KeyListener(DesignerPanel designerPanel, DesignerState designerState) {
        this.designerPanel = designerPanel;
        this.designerState = designerState;
    }

    @Override
    public void keyPressed(KeyEvent ev) {
        super.keyPressed(ev);
        if (this.designerPanel.isPaintingAllowed()) {
            switch (ev.getKeyCode()) {
                case 9: {
                    this.onTabPressed();
                    break;
                }
                case 27: {
                    this.onEscapePressed();
                    break;
                }
            }
        }
    }

    private void onTabPressed() {
        Point gridPos = this.designerState.getSelectedGridPos();
        if (gridPos == null) {
            gridPos = this.designerPanel.getPointedGridPos();
        }
        if (this.designerState.getCountChooseablePointTypes(gridPos) > 1) {
            this.designerState.chooseNextPointType();
            this.designerPanel.repaint();
        }
    }

    private void onEscapePressed() {
        this.designerState.resetNewCheckLineInformation();
        this.designerState.resetSelectionInformation();
        this.designerPanel.repaint();
    }
}

