/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.DesignerPanel;
import com.tjger.lineracer.desktop.trackdesigner.ui.LRTDMainMenu;
import com.tjger.lineracer.desktop.trackdesigner.ui.LRTDStatusBar;
import hgb.lib.HGBaseLog;
import java.io.File;
import tjger.MainFrame;
import tjger.MainPanel;
import tjger.lib.GameConfigurationException;

public class LRTDMainFrame
extends MainFrame {
    public LRTDMainFrame() throws GameConfigurationException {
        super("/xml/settings.xml", true);
        this.setStatusBar(new LRTDStatusBar(this));
        this.setMenu(new LRTDMainMenu(this));
        this.setPanels(new MainPanel(), new DesignerPanel());
        this.setTrackMenuActive(false);
    }

    public static void main(String[] args) {
        try {
            LRTDMainFrame main = new LRTDMainFrame();
            main.testCommandLineForFile(args);
        }
        catch (GameConfigurationException e) {
            HGBaseLog.logError("Could not start the designer: " + e.getMessage());
        }
    }

    private void setTrackMenuActive(boolean active) {
        DesignerState designerState = (DesignerState)this.getGameManager().getGameState();
        this.getMainMenu().setItemEnabled("edit.undo", false);
        this.getMainMenu().setItemEnabled("edit.redo", false);
        this.getMainMenu().setItemEnabled("edit.attributes", active);
        this.getMainMenu().setItemEnabled("edit.grid", active);
        this.getMainMenu().setItemEnabled("edit.colors", active);
        this.getMainMenu().setItemEnabled("edit.startvector", active);
        this.getMainMenu().setItemEnabled("edit.addpoint", false);
        this.getMainMenu().setItemEnabled("edit.removepoint", false);
        this.getMainMenu().setItemEnabled("edit.addcheckline", false);
        this.getMainMenu().setItemEnabled("edit.addbackgroundimage", active);
        this.getMainMenu().setItemEnabled("edit.removebackgroundimage", active && designerState.isRemoveBackgroundImageAllowed());
        this.getMainMenu().setItemEnabled("edit.showhidebackgroundimage", active && designerState.isShowHideBackgroundImageAllowed());
        this.getMainMenu().setItemEnabled("file.export", active);
    }

    @Override
    public int onFileNew() {
        int ret = super.onFileNew();
        if (ret == 0) {
            this.setTrackMenuActive(true);
            this.setChanged(false);
        }
        return ret;
    }

    private DesignerState getDesignerState() {
        return (DesignerState)this.getGameManager().getGameState();
    }

    @Override
    public int onFileClose() {
        int ret = super.onFileClose();
        if (ret == 0) {
            this.setTrackMenuActive(false);
            this.getDesignerState().setTrack(null);
            LRTDStatusBar.clearAll();
        }
        return ret;
    }

    @Override
    public int onFileOpen(File file) {
        int ret = super.onFileOpen(file);
        if (ret == 0) {
            this.setTrackMenuActive(true);
            this.setChanged(false);
        }
        return ret;
    }
}

