/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.common.ShowHideBackgroundImage;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.AddBackgroundImage;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.AddCheckLine;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.AddPoint;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.OpenEditColorsDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.OpenEditGridAttributesDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.OpenEditStartVectorDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.OpenEditTrackAttributesDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.OpenExportTrackDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.RedoModification;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.RemoveBackgroundImage;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.RemovePoint;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.UndoModification;
import hgb.gui.HGBaseDialog;
import hgb.lib.HGBaseText;
import java.awt.event.ActionEvent;
import tjger.MainFrame;
import tjger.MainMenu;

public class LRTDMainMenu
extends MainMenu {
    public static final String MENU_ID_UNDO = "edit.undo";
    public static final String MENU_ID_REDO = "edit.redo";
    public static final String MENU_ID_EDIT_TRACK_ATTRIBUTES = "edit.attributes";
    public static final String MENU_ID_EDIT_GRID_ATTRIBUTES = "edit.grid";
    public static final String MENU_ID_EDIT_COLORS = "edit.colors";
    public static final String MENU_ID_EDIT_START_VECTOR = "edit.startvector";
    public static final String MENU_ID_ADD_POINT = "edit.addpoint";
    public static final String MENU_ID_REMOVE_POINT = "edit.removepoint";
    public static final String MENU_ID_ADD_CHECK_LINE = "edit.addcheckline";
    public static final String MENU_ID_ADD_BACKGROUND_IMAGE = "edit.addbackgroundimage";
    public static final String MENU_ID_REMOVE_BACKGROUND_IMAGE = "edit.removebackgroundimage";
    public static final String MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE = "edit.showhidebackgroundimage";
    public static final String MENU_ID_EXPORT_TRACK = "file.export";
    public static final int ERR_TRACK_PROBLEMS = -87225;
    private Track.Problem[] trackErrors;

    public LRTDMainMenu(MainFrame frame) {
        super(frame);
        this.setTrackErrors(null);
        this.registerAction(MENU_ID_UNDO, new UndoModification(this));
        this.registerAction(MENU_ID_REDO, new RedoModification(this));
        this.registerAction(MENU_ID_EDIT_TRACK_ATTRIBUTES, new OpenEditTrackAttributesDialog(this));
        this.registerAction(MENU_ID_EDIT_GRID_ATTRIBUTES, new OpenEditGridAttributesDialog(this));
        this.registerAction(MENU_ID_EDIT_COLORS, new OpenEditColorsDialog(this));
        this.registerAction(MENU_ID_EDIT_START_VECTOR, new OpenEditStartVectorDialog(this));
        this.registerAction(MENU_ID_ADD_POINT, new AddPoint(this));
        this.registerAction(MENU_ID_REMOVE_POINT, new RemovePoint(this));
        this.registerAction(MENU_ID_ADD_CHECK_LINE, new AddCheckLine(this));
        this.registerAction(MENU_ID_ADD_BACKGROUND_IMAGE, new AddBackgroundImage(this));
        this.registerAction(MENU_ID_REMOVE_BACKGROUND_IMAGE, new RemoveBackgroundImage(this));
        this.registerAction(MENU_ID_SHOW_HIDE_BACKGROUND_IMAGE, new ShowHideBackgroundImage(this));
        this.registerAction(MENU_ID_EXPORT_TRACK, new OpenExportTrackDialog(this));
    }

    @Override
    protected void showFileOpenError(int errorCode) {
        if (errorCode == -87225 && this.trackErrors != null) {
            StringBuilder builder = new StringBuilder(HGBaseText.getText("err_file_open_track_error", new String[0]));
            Track.Problem[] problemArray = this.trackErrors;
            int n = this.trackErrors.length;
            int n2 = 0;
            while (n2 < n) {
                Track.Problem error = problemArray[n2];
                builder.append("\n");
                builder.append(error.getMessage());
                ++n2;
            }
            HGBaseDialog.showMessageDialog(this.getMainFrame(), builder.toString(), HGBaseText.getText("dlg.error", new String[0]), 0);
        } else {
            super.showFileOpenError(errorCode);
        }
    }

    public void setTrackErrors(Track.Problem[] errors) {
        this.trackErrors = errors;
    }

    @Override
    public void onAction(String id, ActionEvent e) {
        if (!MENU_ID_ADD_POINT.equals(id)) {
            ((DesignerState)this.getGameManager().getGameState()).resetNewCheckLineInformation();
            this.getGameManager().getMainFrame().getGamePanel().repaint();
        }
        super.onAction(id, e);
    }
}

