/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.PointType;
import com.tjger.lineracer.desktop.trackdesigner.ui.menu.ActionAdapter;
import hgb.gui.HGBaseGuiTools;
import hgb.lib.HGBaseText;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import tjger.MainFrame;
import tjger.game.completed.GameManager;
import tjger.lib.SimpleStatusBar;

public class LRTDStatusBar
extends SimpleStatusBar {
    private static final int MOUSE_POS_PANEL_INDEX = 0;
    private static final int GRID_POS_PANEL_INDEX = 1;
    private static final int POINT_TYPE_PANEL_INDEX = 2;
    private static final int INFO_PANEL_INDEX = 3;
    private static final int PROBLEM_PANEL_INDEX = 4;
    private static final int ZOOM_PANEL_INDEX = 5;
    private static final int PROGRESS_PANEL_INDEX = 6;

    public LRTDStatusBar(MainFrame frame) {
        int[] nArray = new int[7];
        nArray[0] = 70;
        nArray[1] = 150;
        nArray[2] = 150;
        nArray[4] = 20;
        nArray[5] = 50;
        nArray[6] = 100;
        super(nArray, frame);
        this.setZoomPanel(5);
        this.setProgressPanel(6);
        this.initPointTypePanel();
        this.initProblemPanel();
    }

    private void initPointTypePanel() {
        final JLabel pointTypeLabel = this.getLabel(2);
        pointTypeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                super.mouseClicked(ev);
                if (ev.getButton() == 3) {
                    PointType[] chooseablePointTypes;
                    DesignerState state = LRTDStatusBar.getDesignerState();
                    JMenu menu = LRTDStatusBar.this.getChooseablePointTypesMenu(state, chooseablePointTypes = state.getChooseablePointTypes());
                    if (menu != null) {
                        menu.getPopupMenu().show(pointTypeLabel, ev.getX(), ev.getY());
                    }
                } else if (ev.getButton() == 1 && ev.getClickCount() == 2) {
                    LRTDStatusBar.getDesignerState().chooseNextPointType();
                    LRTDStatusBar.getGameManager().getMainFrame().getGamePanel().repaint();
                }
            }
        });
    }

    private JMenu getChooseablePointTypesMenu(final DesignerState state, PointType[] types) {
        if (types == null || types.length <= 1) {
            return null;
        }
        JMenu menu = new JMenu();
        PointType[] pointTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            final PointType type = pointTypeArray[n2];
            JMenuItem item = new JMenuItem(new ActionAdapter(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    super.actionPerformed(ev);
                    state.setChosenPointType(type);
                    LRTDStatusBar.getGameManager().getMainFrame().getGamePanel().repaint();
                }
            });
            item.setText(HGBaseText.getText(type.getMessageKey(), new String[0]));
            menu.add(item);
            ++n2;
        }
        return menu;
    }

    private void initProblemPanel() {
        final JLabel problemPanel = this.getLabel(4);
        problemPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                DesignerState state;
                Track.Problem[] problems;
                JMenu menu;
                super.mouseClicked(ev);
                if (ev.getButton() == 3 && (menu = LRTDStatusBar.this.getTrackProblemsMenu(problems = (state = LRTDStatusBar.getDesignerState()).getTrackProblems())) != null) {
                    menu.getPopupMenu().show(problemPanel, ev.getX(), ev.getY());
                }
            }
        });
    }

    private void addMenuItems(JMenu menu, ArrayList<JMenuItem> items) {
        if (menu.getMenuComponentCount() > 0 && items.size() > 0) {
            menu.addSeparator();
        }
        for (JMenuItem item : items) {
            menu.add(item);
        }
    }

    private JMenu getTrackProblemsMenu(Track.Problem[] problems) {
        if (problems == null) {
            return null;
        }
        ArrayList<JMenuItem> gridPosWarnings = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> gridPosErrors = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> generalWarnings = new ArrayList<JMenuItem>();
        ArrayList<JMenuItem> generalErrors = new ArrayList<JMenuItem>();
        Track.Problem[] problemArray = problems;
        int n = problems.length;
        int n2 = 0;
        while (n2 < n) {
            Track.Problem problem = problemArray[n2];
            JMenuItem item = new JMenuItem(problem.getMessage(), HGBaseGuiTools.loadImage("/gfx/menu/" + (Track.ProblemType.WARNING.equals((Object)problem.getType()) ? "problem" : "error") + ".png"));
            if (problem.getGridPos() == null) {
                if (Track.ProblemType.WARNING.equals((Object)problem.getType())) {
                    generalWarnings.add(item);
                } else {
                    generalErrors.add(item);
                }
            } else if (Track.ProblemType.WARNING.equals((Object)problem.getType())) {
                gridPosWarnings.add(item);
            } else {
                gridPosErrors.add(item);
            }
            ++n2;
        }
        JMenu menu = new JMenu();
        this.addMenuItems(menu, generalErrors);
        this.addMenuItems(menu, generalWarnings);
        this.addMenuItems(menu, gridPosErrors);
        this.addMenuItems(menu, gridPosWarnings);
        return menu;
    }

    private static GameManager getGameManager() {
        return GameManager.getInstance();
    }

    private static DesignerState getDesignerState() {
        return (DesignerState)LRTDStatusBar.getGameManager().getGameState();
    }

    private static void setPanelText(int index, String text) {
        LRTDStatusBar.getGameManager().getMainFrame().getStatusBar().setText(index, text);
    }

    public static void setMousePos(Point pos) {
        LRTDStatusBar.setPanelText(0, String.valueOf(pos.x) + "/" + pos.y);
    }

    private static void clearMousePos() {
        LRTDStatusBar.setPanelText(0, "");
    }

    public static void setGridPos(Point gridPos, Point dragStartGridPos, Line newCheckLine) {
        String additionalInformation = "";
        if (dragStartGridPos != null) {
            additionalInformation = String.valueOf(dragStartGridPos.x) + "/" + dragStartGridPos.y + " -> ";
        } else if (newCheckLine != null) {
            additionalInformation = String.valueOf(newCheckLine.getStartPos().x) + "/" + newCheckLine.getStartPos().y + " - ";
        }
        LRTDStatusBar.setPanelText(1, String.valueOf(additionalInformation) + gridPos.x + "/" + gridPos.y);
    }

    private static void clearGridPos() {
        LRTDStatusBar.setPanelText(1, "");
    }

    public static void setChosenPointType(PointType pointType) {
        LRTDStatusBar.setPanelText(2, pointType == null ? "" : HGBaseText.getText(pointType.getMessageKey(), new String[0]));
    }

    private static void clearChosenPointType() {
        LRTDStatusBar.setPanelText(2, "");
    }

    public static void setInfoText(String textkey) {
        LRTDStatusBar.setPanelText(3, HGBaseText.getText(textkey, new String[0]));
    }

    public static void clearInfo() {
        LRTDStatusBar.setPanelText(3, "");
    }

    public static void setProblemState(boolean problemExists) {
        JLabel label = LRTDStatusBar.getGameManager().getMainFrame().getStatusBar().getLabel(4);
        label.setIcon(problemExists ? HGBaseGuiTools.loadImage("/gfx/menu/problem.png") : null);
    }

    private static void clearProblemState() {
        LRTDStatusBar.setProblemState(false);
    }

    public static void clearAll() {
        LRTDStatusBar.clearMousePos();
        LRTDStatusBar.clearGridPos();
        LRTDStatusBar.clearChosenPointType();
        LRTDStatusBar.clearInfo();
        LRTDStatusBar.clearProblemState();
    }
}

