/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGamePanel;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.PointType;
import com.tjger.lineracer.desktop.trackdesigner.ui.DesignerPanel;
import com.tjger.lineracer.desktop.trackdesigner.ui.LRTDStatusBar;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

public class MouseListener
extends MouseAdapter {
    private DesignerPanel designerPanel;
    private DesignerState designerState;

    public MouseListener(DesignerPanel designerPanel, DesignerState designerState) {
        this.designerPanel = designerPanel;
        this.designerState = designerState;
    }

    private Point getMousePos() {
        return new Point(this.designerPanel.getMouseX(), this.designerPanel.getMouseY());
    }

    private Point convertMousePosToGridPos() {
        return this.designerPanel.convertScreenPosToGridPos(this.getMousePos(), this.designerState.getGridSize());
    }

    private Point convertGridPosToScreenPos(Point gridPos) {
        return AbstractLineRacerGamePanel.convertGridPosToScreenPos(gridPos, this.designerState.getGridSize());
    }

    @Override
    public void mouseMoved(MouseEvent ev) {
        super.mouseMoved(ev);
        if (!this.designerPanel.isPaintingAllowed()) {
            return;
        }
        Point gridPos = this.convertMousePosToGridPos();
        Point mousePos = this.getMousePos();
        this.setStatusBarInfo(mousePos, gridPos, null, this.designerState.getNewCheckLine(), true);
        this.setPointedGridPos(gridPos);
        this.setPointedTrackLine(mousePos);
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        super.mousePressed(ev);
        if (!this.designerPanel.isPaintingAllowed()) {
            return;
        }
        this.designerState.startDrag(this.convertMousePosToGridPos());
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        super.mouseReleased(ev);
        if (!this.designerPanel.isPaintingAllowed()) {
            return;
        }
        this.designerState.stopDrag();
        Point gridPos = this.convertMousePosToGridPos();
        this.setPointedGridPos(gridPos);
        this.setStatusBarInfo(this.getMousePos(), gridPos, null, this.designerState.getNewCheckLine(), true);
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        super.mouseDragged(ev);
        if (!this.designerPanel.isPaintingAllowed()) {
            return;
        }
        Point gridPos = this.convertMousePosToGridPos();
        this.setDragEndGridPos(gridPos);
        this.setStatusBarInfo(this.getMousePos(), gridPos, this.designerState.getDragStartGridPos(), this.designerState.getNewCheckLine(), false);
    }

    @Override
    public void mouseEntered(MouseEvent ev) {
        super.mouseEntered(ev);
        this.designerPanel.setCursor(Cursor.getPredefinedCursor(1));
    }

    @Override
    public void mouseExited(MouseEvent ev) {
        super.mouseExited(ev);
        this.designerPanel.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void mouseClicked(MouseEvent ev) {
        super.mouseClicked(ev);
        if (!this.designerPanel.isPaintingAllowed()) {
            return;
        }
        if (ev.getClickCount() == 1 && ev.getButton() == 1) {
            PointType pointedGridPosChosenPointType = this.designerState.getPointedGridPosChosenPointType();
            if (pointedGridPosChosenPointType == null) {
                this.designerState.setSelectedGridPos(null);
                this.designerState.resetNewCheckLineInformation();
            } else {
                Point pointedGridPos = this.designerPanel.getPointedGridPos();
                this.designerState.setSelectedGridPos(pointedGridPos);
                this.designerState.confirmNewCheckLineEndPosition(pointedGridPos, true);
            }
            this.designerState.setSelectedTrackLine(this.designerState.getPointedTrackLine());
            this.designerPanel.repaint();
            this.setStatusBarInfo(this.getMousePos(), this.convertMousePosToGridPos(), null, this.designerState.getNewCheckLine(), true);
        }
    }

    private void setStatusBarInfo(Point mousePos, Point gridPos, Point dragStartGridPos, Line newCheckLine, boolean showMultipeUsageInfo) {
        LRTDStatusBar.setMousePos(mousePos);
        if (gridPos == null) {
            return;
        }
        LRTDStatusBar.setGridPos(gridPos, dragStartGridPos, newCheckLine);
        String infoMsgKey = null;
        if (showMultipeUsageInfo) {
            Point selectedGridPos = this.designerState.getSelectedGridPos();
            int countChooseablePointTypes = this.designerState.getCountChooseablePointTypes(selectedGridPos != null ? selectedGridPos : gridPos);
            String string = countChooseablePointTypes > 1 ? (selectedGridPos != null ? "info_multipleposusage_selected" : "info_multipleposusage") : (infoMsgKey = null);
        }
        if (infoMsgKey != null) {
            LRTDStatusBar.setInfoText(infoMsgKey);
        } else {
            LRTDStatusBar.clearInfo();
        }
    }

    private void setPointedGridPos(Point gridPos) {
        if (gridPos == null) {
            return;
        }
        if (!gridPos.equals(this.designerPanel.getPointedGridPos())) {
            this.designerPanel.setPointedGridPos(gridPos);
            this.designerState.setPointedGridPosChooseablePointTypes(gridPos);
            this.designerState.setPointedTrackLine(null);
            this.designerState.setNewCheckLineEndPosition(gridPos);
            this.designerPanel.repaint();
        }
    }

    private void setDragEndGridPos(Point gridPos) {
        if (gridPos == null) {
            return;
        }
        if (!gridPos.equals(this.designerState.getDragEndGridPos()) && this.designerPanel.isGridPosValid(gridPos)) {
            this.designerPanel.setPointedGridPos(null);
            this.designerState.setPointedGridPosChooseablePointTypes(null);
            this.designerState.setSelectedGridPos(null);
            this.designerState.setPointedTrackLine(null);
            this.designerState.setDragEndGridPos(gridPos);
            this.designerState.resetNewCheckLineInformation();
            this.designerPanel.repaint();
        }
    }

    private void setPointedTrackLine(Point mousePos) {
        Line[] trackLines = this.designerState.getTrack().getTrackLines();
        Line pointedLine = null;
        Line[] lineArray = trackLines;
        int n = trackLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line screenLine;
            Polygon lineRect;
            Line line = lineArray[n2];
            if (line != null && line.getStartPos() != null && line.getEndPos() != null && (lineRect = (screenLine = new Line(this.convertGridPosToScreenPos(line.getStartPos()), this.convertGridPosToScreenPos(line.getEndPos()))).toRectangle(10)).contains(mousePos)) {
                pointedLine = line;
                break;
            }
            ++n2;
        }
        this.designerState.setPointedTrackLine(pointedLine);
        this.designerPanel.repaint();
    }
}

