/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.AbstractEditPreviewDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.DialogUtils;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.config.HGBaseConfigColorChooser;
import hgb.lib.HGBaseConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SpringLayout;

public class EditColorsDialog
extends AbstractEditPreviewDialog {
    private Color orgGridColor;
    private Color orgBorderColor;
    private Color orgFinishLineColor;
    private Color orgBackgroundColor;
    private HGBaseConfigColorChooser gridColor;
    private HGBaseConfigColorChooser borderColor;
    private HGBaseConfigColorChooser finishLineColor;
    private HGBaseConfigColorChooser backgroundColor;
    private JButton removeBackgroundColorButton;

    public EditColorsDialog(HGBaseFrame mainFrame, Color gridColor, Color borderColor, Color finishLineColor, Color backgroundColor) {
        super(mainFrame, "dlg_title_editcolors");
        this.orgGridColor = gridColor;
        this.orgBorderColor = borderColor;
        this.orgFinishLineColor = finishLineColor;
        this.orgBackgroundColor = backgroundColor;
        this.gridColor = this.createColorChooser("gridcolor", gridColor);
        this.borderColor = this.createColorChooser("bordercolor", borderColor);
        this.finishLineColor = this.createColorChooser("finishlinecolor", finishLineColor);
        this.backgroundColor = this.createColorChooser("backgroundcolor", backgroundColor);
        this.removeBackgroundColorButton = new JButton(HGBaseGuiTools.loadImage("/gfx/menu/remove.png"));
        this.removeBackgroundColorButton.addActionListener(this);
    }

    private HGBaseConfigColorChooser createColorChooser(String configKey, Color initColor) {
        HGBaseConfig.set(configKey, "");
        HGBaseConfigColorChooser chooser = new HGBaseConfigColorChooser(configKey, initColor, 30);
        chooser.addActionListener(this);
        return chooser;
    }

    @Override
    protected boolean canLeave() {
        return true;
    }

    @Override
    protected JPanel createConfigPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        DialogUtils.addField(panel, "label_gridcolor", this.gridColor);
        DialogUtils.addField(panel, "label_bordercolor", this.borderColor);
        DialogUtils.addField(panel, "label_finishlinecolor", this.finishLineColor);
        DialogUtils.addField(panel, "label_backgroundcolor", this.createBackgroundColorPanel());
        this.makeForm(panel, 4);
        return panel;
    }

    private JPanel createBackgroundColorPanel() {
        JPanel panel = new JPanel(new BorderLayout(5, 0));
        panel.add((Component)this.backgroundColor, "Center");
        panel.add((Component)this.removeBackgroundColorButton, "East");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        if (ev.getSource().equals(this.gridColor) || ev.getSource().equals(this.borderColor) || ev.getSource().equals(this.finishLineColor) || ev.getSource().equals(this.backgroundColor)) {
            this.previewChanges();
        } else if (ev.getSource().equals(this.removeBackgroundColorButton)) {
            this.backgroundColor.setColor(null);
            this.previewChanges();
        }
    }

    private void setStateValues(DesignerState state, Color gridColor, Color borderColor, Color finishLineColor, Color backgroundColor) {
        state.setGridColor(gridColor);
        state.setBorderColor(borderColor);
        state.setFinishLineColor(finishLineColor);
        state.setBackgroundColor(backgroundColor);
    }

    @Override
    protected void setCurrentStateValues(DesignerState state) {
        this.setStateValues(state, this.gridColor.getColor(), this.borderColor.getColor(), this.finishLineColor.getColor(), this.backgroundColor.getColor(false));
    }

    @Override
    protected void restoreStateValues(DesignerState state) {
        this.setStateValues(state, this.orgGridColor, this.orgBorderColor, this.orgFinishLineColor, this.orgBackgroundColor);
    }
}

