/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.AbstractEditPreviewDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.DialogUtils;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.JGridSizeSpinner;
import hgb.gui.HGBaseFrame;
import hgb.gui.config.HGBaseConfigColorChooser;
import hgb.lib.HGBaseText;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EditGridAttributesDialog
extends AbstractEditPreviewDialog
implements ChangeListener {
    private int orgGridSize;
    private Color orgGridColor;
    private JGridSizeSpinner gridSize;
    private HGBaseConfigColorChooser gridColor;

    public EditGridAttributesDialog(HGBaseFrame mainFrame, int gridSize, Color gridColor) {
        super(mainFrame, "dlg_title_editgridattributes");
        this.orgGridSize = gridSize;
        this.orgGridColor = gridColor;
        this.gridSize = new JGridSizeSpinner(gridSize);
        this.gridSize.addChangeListener(this);
        this.gridColor = new HGBaseConfigColorChooser("gridcolor", gridColor, 30);
        this.gridColor.addActionListener(this);
    }

    @Override
    protected boolean canLeave() {
        Point[] trackPoints;
        Point maxGridPos = LineRacerUtils.calcMaxGridPos((Integer)this.gridSize.getValue(), 1600, 900);
        Point[] pointArray = trackPoints = this.getDesigerState().getTrack().getTrackPoints();
        int n = trackPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Point pos = pointArray[n2];
            if (!LineRacerUtils.isGridPosValid(pos, maxGridPos)) {
                this.setErrorMessage(HGBaseText.getText("err_track_point_outside_grid", new String[0]));
                return false;
            }
            ++n2;
        }
        this.setErrorMessage("");
        return true;
    }

    @Override
    protected JPanel createConfigPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        DialogUtils.addField(panel, "label_gridsize", this.gridSize);
        DialogUtils.addField(panel, "label_gridcolor", this.gridColor);
        this.makeForm(panel, 2);
        return panel;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        if (ev.getSource().equals(this.gridSize)) {
            this.previewChanges();
            this.canLeave();
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        super.actionPerformed(ev);
        if (ev.getSource().equals(this.gridColor)) {
            this.previewChanges();
        }
    }

    private void setStateValues(DesignerState state, int gridSize, Color gridColor) {
        state.setGridSize(gridSize);
        state.setGridColor(gridColor);
    }

    @Override
    protected void setCurrentStateValues(DesignerState state) {
        this.setStateValues(state, (Integer)this.gridSize.getValue(), this.gridColor.getColor());
    }

    @Override
    protected void restoreStateValues(DesignerState state) {
        this.setStateValues(state, this.orgGridSize, this.orgGridColor);
    }
}

