/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.common.Vector;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.AbstractEditPreviewDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;

public class EditStartVectorDialog
extends AbstractEditPreviewDialog {
    private JToggleButton leftup;
    private JToggleButton up;
    private JToggleButton rightup;
    private JToggleButton left;
    private JToggleButton right;
    private JToggleButton leftdown;
    private JToggleButton down;
    private JToggleButton rightdown;
    private Vector orgStartVector;
    private Vector selectedStartVector;

    public EditStartVectorDialog(HGBaseFrame mainFrame, Vector startVector) {
        super(mainFrame, "dlg_title_editstartvector");
        this.orgStartVector = startVector;
        this.selectedStartVector = startVector;
        ButtonGroup buttonGroup = new ButtonGroup();
        this.leftup = this.createButton("leftup", new Vector(-1, -1), this.selectedStartVector, buttonGroup);
        this.up = this.createButton("up", new Vector(0, -1), this.selectedStartVector, buttonGroup);
        this.rightup = this.createButton("rightup", new Vector(1, -1), this.selectedStartVector, buttonGroup);
        this.left = this.createButton("left", new Vector(-1, 0), this.selectedStartVector, buttonGroup);
        this.right = this.createButton("right", new Vector(1, 0), this.selectedStartVector, buttonGroup);
        this.leftdown = this.createButton("leftdown", new Vector(-1, 1), this.selectedStartVector, buttonGroup);
        this.down = this.createButton("down", new Vector(0, 1), this.selectedStartVector, buttonGroup);
        this.rightdown = this.createButton("rightdown", new Vector(1, 1), this.selectedStartVector, buttonGroup);
    }

    private JToggleButton createButton(String imageName, final Vector vector, Vector currentVector, ButtonGroup buttonGroup) {
        JToggleButton button = new JToggleButton(HGBaseGuiTools.loadImage("/gfx/menu/" + imageName + ".png"));
        buttonGroup.add(button);
        button.setSelected(vector.equals(currentVector));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                EditStartVectorDialog.this.selectedStartVector = vector;
                EditStartVectorDialog.this.previewChanges();
            }
        });
        return button;
    }

    @Override
    protected JPanel createConfigPanel() {
        JPanel panel = new JPanel(new GridLayout(3, 3, 5, 5));
        panel.add(this.leftup);
        panel.add(this.up);
        panel.add(this.rightup);
        panel.add(this.left);
        panel.add(new JLabel());
        panel.add(this.right);
        panel.add(this.leftdown);
        panel.add(this.down);
        panel.add(this.rightdown);
        return panel;
    }

    @Override
    protected void restoreStateValues(DesignerState state) {
        state.setStartVector(this.orgStartVector);
    }

    @Override
    protected void setCurrentStateValues(DesignerState state) {
        state.setStartVector(this.selectedStartVector);
    }

    @Override
    protected boolean canLeave() {
        return true;
    }
}

