/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.Language;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.AbstractEditDialog;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.DialogUtils;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBasePanel;
import hgb.gui.util.SpringUtilities;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class EditTrackAttributesDialog
extends AbstractEditDialog {
    public static final String MSGKEY_NO_TRACK_NAME_ERROR = "err_notrackname";
    public static final String MSGKEY_TRACK_NAME_LABEL = "label_trackname";
    public static final String MSGKEY_TRACK_VERSION_LABEL = "label_version";
    public static final String MSGKEY_TRACK_DESCRIPTION_LABEL = "label_description";
    public static final String MSGKEY_LANGUAGE_LABEL = "label_language";
    public static final String MSGKEY_TRACK_AUTHOR_LABEL = "label_author";
    private JTextField name;
    private JTextField version;
    private HashMap<String, String> trackDescriptions;
    private JComboBox<Language> language;
    private JTextArea description;
    private JTextField author;

    public EditTrackAttributesDialog(HGBaseFrame mainFrame, String trackName, String trackVersion, HashMap<String, String> trackDescriptions, String trackAuthor) {
        super(mainFrame, "dlg_title_edittrackattributes");
        this.name = new JTextField(trackName);
        this.name.getDocument().addDocumentListener(this.getCheckStateDocumentListener());
        this.version = new JTextField(trackVersion);
        this.trackDescriptions = trackDescriptions;
        String defaultText = this.trackDescriptions.getOrDefault(HGBaseText.getLanguage(), "x");
        this.description = new JTextArea(defaultText, 5, 30);
        this.description.getDocument().addDocumentListener(this.getApplyDescriptionListener());
        this.language = new JComboBox<Language>(Language.getAvailableLanguages());
        this.language.addActionListener(this);
        this.language.setSelectedItem(new Language(HGBaseText.getLanguage()));
        this.author = new JTextField(trackAuthor);
    }

    private DocumentListener getCheckStateDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.checkState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.checkState();
            }
        };
    }

    private DocumentListener getApplyDescriptionListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.applyDescription();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.applyDescription();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditTrackAttributesDialog.this.applyDescription();
            }
        };
    }

    private void applyDescription() {
        this.trackDescriptions.put(this.getSelectedLanguage().getCode(), this.description.getText());
    }

    private Language getSelectedLanguage() {
        return this.language.getItemAt(this.language.getSelectedIndex());
    }

    @Override
    protected boolean canLeave() {
        if (!HGBaseTools.hasContent(this.name.getText())) {
            this.setErrorMessage(HGBaseText.getText(MSGKEY_NO_TRACK_NAME_ERROR, new String[0]));
            return false;
        }
        this.setErrorMessage("");
        return true;
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        pnDialog.setLayout(new SpringLayout());
        DialogUtils.addField(pnDialog, MSGKEY_TRACK_NAME_LABEL, this.name);
        DialogUtils.addField(pnDialog, MSGKEY_TRACK_VERSION_LABEL, this.version);
        pnDialog.add(this.createDescriptionPromptPanel());
        pnDialog.add(new JScrollPane(this.description));
        DialogUtils.addField(pnDialog, MSGKEY_TRACK_AUTHOR_LABEL, this.author);
        this.makeForm(pnDialog, 4);
    }

    private JPanel createDescriptionPromptPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(DialogUtils.createLabel(MSGKEY_TRACK_DESCRIPTION_LABEL, this.description));
        panel.add(this.createLanguagePanel());
        SpringUtilities.makeCompactGrid(panel, 2, 1, 0, 0, 0, 5);
        return panel;
    }

    private JPanel createLanguagePanel() {
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.add(DialogUtils.createLabel(MSGKEY_LANGUAGE_LABEL, this.language));
        panel.add(this.language);
        return panel;
    }

    @Override
    protected void setCurrentStateValues(DesignerState state) {
        state.setTrackName(this.name.getText());
        state.setTrackVersion(this.version.getText());
        state.setTrackDescriptions(this.trackDescriptions);
        state.setTrackAuthor(this.author.getText());
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.language)) {
            this.description.setText(this.trackDescriptions.getOrDefault(this.getSelectedLanguage().getCode(), ""));
        }
        super.actionPerformed(ev);
    }
}

