/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.common.AbstractLineRacerGamePanel;
import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.trackdesigner.ui.DesignerPanel;
import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigDialog;
import hgb.lib.HGBaseText;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ExportTrackDialog
extends HGBaseConfigDialog {
    private Track track;
    private HGBaseConfigCheckBox withBorderLines;
    private HGBaseConfigCheckBox withGridLines;
    private HGBaseConfigCheckBox withFinishLine;
    private HGBaseConfigCheckBox withStartPositions;
    private HGBaseConfigCheckBox withCheckLines;
    private HGBaseConfigCheckBox withBackground;

    public ExportTrackDialog(HGBaseFrame mainFrame, Track track) {
        super(mainFrame, HGBaseText.getText("dlg_title_export_track", new String[0]));
        this.track = track;
        this.withBorderLines = new HGBaseConfigCheckBox("boder_lines", "export_border_lines", "1");
        this.withGridLines = new HGBaseConfigCheckBox("grid_lines", "export_grid_lines", "0");
        this.withFinishLine = new HGBaseConfigCheckBox("finish_line", "export_finish_line", "0");
        this.withStartPositions = new HGBaseConfigCheckBox("start_positions", "export_start_positions", "0");
        this.withCheckLines = new HGBaseConfigCheckBox("check_lines", "export_check_lines", "0");
        this.withBackground = new HGBaseConfigCheckBox("background", "export_background", "0");
    }

    @Override
    protected void createComponents(HGBasePanel pnDialog) {
        pnDialog.setLayout(new BoxLayout(pnDialog, 1));
        pnDialog.add(new JLabel(HGBaseText.getText("label_select_export_elements", new String[0])));
        pnDialog.add(this.withBorderLines);
        pnDialog.add(this.withGridLines);
        pnDialog.add(this.withFinishLine);
        pnDialog.add(this.withStartPositions);
        pnDialog.add(this.withCheckLines);
        pnDialog.add(this.withBackground);
    }

    @Override
    protected void okPressed() {
        super.okPressed();
        JFileChooser chooser = HGBaseGuiTools.createFileChooser(HGBaseText.getText("png_imagefiles", new String[0]), "png", null);
        int result = chooser.showSaveDialog(this.getMainFrame());
        if (result != 0) {
            return;
        }
        ExportTrackDialog.exportImage(this.track, chooser.getSelectedFile(), this.withBorderLines.isSelected(), this.withGridLines.isSelected(), this.withFinishLine.isSelected(), this.withStartPositions.isSelected(), this.withCheckLines.isSelected(), this.withBackground.isSelected(), this.getMainFrame());
    }

    private static void exportImage(Track track, File file, boolean withBorderLines, boolean withGridLines, boolean withFinishLine, boolean withStartPositions, boolean withCheckLines, boolean withBackground, JFrame mainFrame) {
        BufferedImage bufferedImage = new BufferedImage(1600, 900, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        if (withBackground) {
            ExportTrackDialog.paintBackground(track.getBackgroundImage(), track.getBackgroundColor(), g2d);
        }
        if (withGridLines) {
            ExportTrackDialog.paintGrid(track.getGridSize(), track.getGridColor(), g2d);
        }
        if (withBorderLines) {
            ExportTrackDialog.paintTrackLines(track.getOuterPoints(), track.getInnerPoints(), track.getBorderColor(), track.getGridSize(), g2d);
        }
        if (withFinishLine) {
            ExportTrackDialog.paintFinishLine(track.getFinishLine(), track.getFinishLineColor(), track.getGridSize(), g2d);
        }
        if (withStartPositions) {
            ExportTrackDialog.paintStartPositions(track.getStartPositions(), track.getGridSize(), g2d);
        }
        if (withCheckLines) {
            ExportTrackDialog.paintCheckLines(track.getCheckLines(), track.getGridSize(), g2d);
        }
        g2d.dispose();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException e) {
            HGBaseDialog.printError("err_export_track_create_image", mainFrame);
        }
    }

    private static void paintBackground(ImageIcon backgroundImage, Color backgroundColor, Graphics g) {
        if (backgroundImage != null) {
            g.drawImage(backgroundImage.getImage(), 0, 0, backgroundImage.getImageObserver());
        } else if (backgroundColor != null) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, 1600, 900);
        }
    }

    private static void paintGrid(int gridSize, Color lineColor, Graphics g) {
        g.setColor(lineColor);
        ExportTrackDialog.paintHorizontalGridLines(1600, 900, gridSize, g);
        ExportTrackDialog.paintVerticalGridLines(1600, 900, gridSize, g);
    }

    private static void paintHorizontalGridLines(int imageWidth, int imageHeight, int gridSize, Graphics g) {
        int y = gridSize;
        while (y < imageHeight) {
            g.drawLine(0, y, imageWidth, y);
            y += gridSize;
        }
    }

    private static void paintVerticalGridLines(int imageWidth, int imageHeight, int gridSize, Graphics g) {
        int x = gridSize;
        while (x < imageWidth) {
            g.drawLine(x, 0, x, imageHeight);
            x += gridSize;
        }
    }

    private static void paintTrackLines(Point[] outerLinePoints, Point[] innerLinePoints, Color lineColor, int gridSize, Graphics g) {
        g.setColor(lineColor);
        g.drawPolygon(AbstractLineRacerGamePanel.getPolygon(outerLinePoints, gridSize));
        g.drawPolygon(AbstractLineRacerGamePanel.getPolygon(innerLinePoints, gridSize));
    }

    private static void paintFinishLine(Line line, Color lineColor, int gridSize, Graphics g) {
        g.setColor(lineColor);
        ExportTrackDialog.paintGridLine(line, gridSize, g);
    }

    private static void paintGridLine(Line line, int gridSize, Graphics g) {
        if (line == null || line.getStartPos() == null || line.getEndPos() == null) {
            return;
        }
        Point startPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(line.getStartPos(), gridSize);
        Point endPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(line.getEndPos(), gridSize);
        g.drawLine(startPos.x, startPos.y, endPos.x, endPos.y);
    }

    private static void paintStartPositions(Point[] startPositions, int gridSize, Graphics g) {
        if (startPositions == null) {
            return;
        }
        g.setFont(g.getFont().deriveFont(6.0f));
        g.setColor(DesignerPanel.START_POS_COLOR);
        int index = 0;
        while (index < startPositions.length) {
            Point pos = startPositions[index];
            if (pos != null) {
                Point screenPos = AbstractLineRacerGamePanel.convertGridPosToScreenPos(pos, gridSize);
                int offset = 2;
                g.fillOval(screenPos.x - offset, screenPos.y - offset, 4, 4);
                g.drawString(String.valueOf(index + 1), screenPos.x + 1, screenPos.y - 1);
            }
            ++index;
        }
    }

    private static void paintCheckLines(Line[] checkLines, int gridSize, Graphics g) {
        if (checkLines == null) {
            return;
        }
        g.setColor(DesignerPanel.CHECK_LINE_COLOR);
        Line[] lineArray = checkLines;
        int n = checkLines.length;
        int n2 = 0;
        while (n2 < n) {
            Line line = lineArray[n2];
            ExportTrackDialog.paintGridLine(line, gridSize, g);
            ++n2;
        }
    }
}

