/*
 * Decompiled with CFR 0.152.
 */
package com.tjger.lineracer.desktop.trackdesigner.ui.dialog;

import com.tjger.lineracer.desktop.common.Line;
import com.tjger.lineracer.desktop.common.LineRacerUtils;
import com.tjger.lineracer.desktop.common.Track;
import com.tjger.lineracer.desktop.common.Vector;
import com.tjger.lineracer.desktop.trackdesigner.DesignerState;
import com.tjger.lineracer.desktop.trackdesigner.Language;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.DialogUtils;
import com.tjger.lineracer.desktop.trackdesigner.ui.dialog.JGridSizeSpinner;
import hgb.gui.HGBaseFrame;
import hgb.gui.util.SpringUtilities;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import tjger.game.completed.GameConfig;
import tjger.game.completed.GameManager;
import tjger.gui.NewGameDialog;

public class NewTrackDialog
extends NewGameDialog {
    public static final String MSGKEY_GRID_SIZE_LABEL = "label_gridsize";
    public static final int DEFAULT_TRACK_WIDTH = 3;
    private JTextField name;
    private JTextField version;
    private HashMap<String, String> trackDescriptions;
    private JComboBox<Language> language;
    private JTextArea description;
    private JTextField author;
    private JGridSizeSpinner gridSize;

    public NewTrackDialog(HGBaseFrame mainFrame, String askToSave) {
        super(mainFrame, askToSave);
    }

    @Override
    protected JPanel getDefaultPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        this.name = new JTextField(HGBaseText.getText("default_trackname", new String[0]));
        this.name.getDocument().addDocumentListener(this.getCheckStateDocumentListener());
        this.version = new JTextField();
        this.trackDescriptions = new HashMap();
        this.description = new JTextArea(5, 30);
        this.description.getDocument().addDocumentListener(this.getApplyDescriptionListener());
        this.language = new JComboBox<Language>(Language.getAvailableLanguages());
        this.language.addActionListener(this);
        this.language.setSelectedItem(new Language(HGBaseText.getLanguage()));
        this.author = new JTextField();
        this.gridSize = new JGridSizeSpinner();
        DialogUtils.addField(panel, "label_trackname", this.name);
        DialogUtils.addField(panel, "label_version", this.version);
        panel.add(this.createDescriptionPromptPanel());
        panel.add(new JScrollPane(this.description));
        DialogUtils.addField(panel, "label_author", this.author);
        DialogUtils.addField(panel, MSGKEY_GRID_SIZE_LABEL, this.gridSize);
        SpringUtilities.makeCompactGrid(panel, 5, 2, 0, 0, 5, 5);
        return panel;
    }

    private DocumentListener getCheckStateDocumentListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTrackDialog.this.checkState();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTrackDialog.this.checkState();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTrackDialog.this.checkState();
            }
        };
    }

    private DocumentListener getApplyDescriptionListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewTrackDialog.this.applyDescription();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewTrackDialog.this.applyDescription();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                NewTrackDialog.this.applyDescription();
            }
        };
    }

    private void applyDescription() {
        this.trackDescriptions.put(this.getSelectedLanguage().getCode(), this.description.getText());
    }

    private Language getSelectedLanguage() {
        return this.language.getItemAt(this.language.getSelectedIndex());
    }

    private JPanel createDescriptionPromptPanel() {
        JPanel panel = new JPanel(new SpringLayout());
        panel.add(DialogUtils.createLabel("label_description", this.description));
        panel.add(this.createLanguagePanel());
        SpringUtilities.makeCompactGrid(panel, 2, 1, 0, 0, 0, 5);
        return panel;
    }

    private JPanel createLanguagePanel() {
        JPanel panel = new JPanel(new FlowLayout(0, 5, 0));
        panel.add(DialogUtils.createLabel("label_language", this.language));
        panel.add(this.language);
        return panel;
    }

    @Override
    protected boolean canLeave() {
        if (!HGBaseTools.hasContent(this.name.getText())) {
            this.setErrorMessage(HGBaseText.getText("err_notrackname", new String[0]));
            return false;
        }
        this.setErrorMessage("");
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getSource().equals(this.language)) {
            this.description.setText(this.trackDescriptions.getOrDefault(this.getSelectedLanguage().getCode(), ""));
        }
        super.actionPerformed(ev);
    }

    private Point[] getDefaultOuterPoints(Point maxGridPos) {
        return new Point[]{new Point(0, 0), new Point(maxGridPos.x / 2, 0), new Point(maxGridPos.x, 0), maxGridPos, new Point(0, maxGridPos.y)};
    }

    private Point[] getDefaultInnerPoints(Point maxGridPos) {
        return new Point[]{new Point(3, 3), new Point(maxGridPos.x / 2, 3), new Point(maxGridPos.x - 3, 3), new Point(maxGridPos.x - 3, maxGridPos.y - 3), new Point(3, maxGridPos.y - 3)};
    }

    private Line getDefaultFinishLine(Point maxGridPos) {
        return new Line(new Point(maxGridPos.x / 2, 0), new Point(maxGridPos.x / 2, 3));
    }

    private Point[] getDefaultStartPositions(Point maxGridPos) {
        Point[] startPositions = new Point[6];
        int row = 0;
        while (row < 3) {
            int x = maxGridPos.x / 2 - row;
            startPositions[2 * row] = new Point(x, 1);
            startPositions[2 * row + 1] = new Point(x, 2);
            ++row;
        }
        return startPositions;
    }

    private Line[] getDefaultCheckLines(Point maxGridPos) {
        return new Line[]{new Line(new Point(0, 0), new Point(3, 3)), new Line(new Point(maxGridPos.x, 0), new Point(maxGridPos.x - 3, 3)), new Line(maxGridPos, new Point(maxGridPos.x - 3, maxGridPos.y - 3)), new Line(new Point(0, maxGridPos.y), new Point(3, maxGridPos.y - 3))};
    }

    @Override
    protected void okPressed() {
        DesignerState state = (DesignerState)GameManager.getInstance().getGameState();
        state.setTrack(new Track());
        state.setTrackName(this.name.getText());
        state.setTrackVersion(this.version.getText());
        state.setTrackDescriptions(this.trackDescriptions);
        state.setTrackAuthor(this.author.getText());
        int gridSizeValue = (Integer)this.gridSize.getValue();
        state.setGridSize(gridSizeValue);
        GameConfig gameConfig = GameManager.getInstance().getGameConfig();
        Point maxGridPos = LineRacerUtils.calcMaxGridPos(gridSizeValue, gameConfig.getFieldWidth(), gameConfig.getFieldHeight());
        state.setOuterPoints(this.getDefaultOuterPoints(maxGridPos));
        state.setInnerPoints(this.getDefaultInnerPoints(maxGridPos));
        state.setFinishLine(this.getDefaultFinishLine(maxGridPos));
        state.setStartPosition(this.getDefaultStartPositions(maxGridPos));
        state.setStartVector(new Vector(1, 0));
        state.setCheckLines(this.getDefaultCheckLines(maxGridPos));
        state.checkTrackProblems();
        super.okPressed();
    }
}

