/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseHTMLPage;
import hgb.lib.HGBaseFileTools;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseSettings;
import hgb.lib.HGBaseText;
import hgb.lib.HGBaseTools;
import hgb.lib.HtmlFilesFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public final class HGBaseAboutDlg {
    private HGBaseAboutDlg() {
    }

    public static void show(HGBaseFrame pane) {
        String infoTitle = HGBaseText.getText("help.abouttitle", new String[0]);
        String applicationName = HGBaseSettings.get("appName", "");
        String additionalInfoPathMsgKey = HGBaseSettings.get("addInfoHTMLPathMsg");
        if (HGBaseTools.hasContent(additionalInfoPathMsgKey)) {
            HGBaseAboutDlg.showTabDialog(pane, infoTitle, applicationName, HGBaseText.getText(additionalInfoPathMsgKey, new String[0]));
        } else {
            HGBaseHTMLPage html = HGBaseAboutDlg.getInfoHTMLPage(pane, applicationName);
            HGBaseAboutDlg.showHTMLDialog(pane, html, infoTitle, applicationName);
        }
    }

    protected static void showHTMLDialog(HGBaseFrame pane, HGBaseHTMLPage html, String infoTitle, String applicationName) {
        try {
            HGBaseDialog.showMessageDialog(pane, html, String.valueOf(infoTitle) + " " + applicationName, -1);
        }
        catch (HeadlessException e) {
            HGBaseLog.logError("Could not show about page: " + e.getMessage());
        }
    }

    protected static void showTabDialog(HGBaseFrame pane, String infoTitle, String applicationName, String additionalInfoPath) {
        JPanel panel = new JPanel(new BorderLayout());
        JTabbedPane tabSet = new JTabbedPane();
        panel.add((Component)tabSet, "Center");
        HGBaseAboutDlg.addInfoTabs(pane, applicationName, tabSet, additionalInfoPath);
        HGBaseDialog.showMessageDialog(pane, panel, String.valueOf(infoTitle) + " " + applicationName, -1);
    }

    protected static void addInfoTabs(HGBaseFrame pane, String applicationName, JTabbedPane tabSet, String additionalInfoPath) {
        HGBaseHTMLPage aboutPage = HGBaseAboutDlg.getInfoHTMLPage(pane, applicationName);
        if (aboutPage != null) {
            HGBaseAboutDlg.addHTMLInfoTab(tabSet, HGBaseText.getText("aboutinfotabtitle", new String[0]), aboutPage);
        }
        Vector<Path> htmlFiles = null;
        try {
            htmlFiles = HGBaseFileTools.getFolderEntries(Paths.get(pane.getClass().getResource(additionalInfoPath).toURI()), new HtmlFilesFilter(), true);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (htmlFiles == null) {
            return;
        }
        for (Path htmlFile : htmlFiles) {
            try {
                HGBaseAboutDlg.addHTMLInfoTab(tabSet, HGBaseText.getText(HGBaseFileTools.getBaseName(htmlFile), new String[0]), new HGBaseHTMLPage(htmlFile.toUri().toURL()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected static void addHTMLInfoTab(JTabbedPane tabSet, String title, HGBaseHTMLPage page) {
        JPanel panel = new JPanel(new BorderLayout());
        HGBaseAboutDlg.setPreferredSizeHTMLPage(page);
        JScrollPane scroll = new JScrollPane(page);
        panel.add((Component)scroll, "Center");
        tabSet.addTab(title, panel);
    }

    protected static HGBaseHTMLPage getInfoHTMLPage(HGBaseFrame pane, String applicationName) {
        HGBaseHTMLPage html = HGBaseAboutDlg.getDynamicInfoHTMLPage(pane);
        if (html == null) {
            html = HGBaseAboutDlg.getStaticInfoHTMLPage(pane, applicationName);
        }
        return html;
    }

    public static HGBaseHTMLPage getDynamicInfoHTMLPage(HGBaseFrame pane) {
        String htmlMsg = HGBaseSettings.get("infoHtmlMsg");
        if (!HGBaseTools.hasContent(htmlMsg)) {
            return null;
        }
        String htmlPath = HGBaseSettings.get("infoHtmlPath", "");
        String url = String.valueOf(htmlPath) + "/" + HGBaseText.getText(htmlMsg, new String[0]);
        URL urlPath = pane.getClass().getResource(url);
        HGBaseHTMLPage html = null;
        try {
            html = new HGBaseHTMLPage(urlPath);
            HGBaseAboutDlg.setPreferredSizeHTMLPage(html);
        }
        catch (IOException e) {
            HGBaseLog.logError("Could not show about page: " + e.getMessage());
        }
        return html;
    }

    protected static void setPreferredSizeHTMLPage(HGBaseHTMLPage page) {
        if (page == null) {
            return;
        }
        int width = HGBaseSettings.getInt("infoHtmlWidth");
        int height = HGBaseSettings.getInt("infoHtmlHeight");
        if (width != -2147483631 && height != -2147483631) {
            page.setPreferredSize(new Dimension(width, height));
        }
    }

    public static HGBaseHTMLPage getStaticInfoHTMLPage(HGBaseFrame pane, String applicationName) {
        String httpURL = HGBaseSettings.get("infoUrl");
        String aboutInfo = HGBaseText.existsText("help.aboutinfo") ? HGBaseText.getText("help.aboutinfo", new String[0]) : "";
        String infoVersion = HGBaseSettings.get("appVersion", "");
        String infoCopy = HGBaseSettings.get("infoCopyright", "");
        StringBuffer htmlBody = new StringBuffer(512);
        htmlBody.append("<html><div style=\"font-family:Arial,Verdana,System\"><table width=\"100%\"><tr><td valign=top><b>" + applicationName + " " + infoVersion + "</b><br>" + infoCopy + "<br>");
        if (httpURL != null) {
            htmlBody.append("<a href=\"" + httpURL + "\">" + httpURL + "</a>");
        }
        htmlBody.append("</td>");
        String imgLogo = HGBaseAboutDlg.getHtmlForImagePath(HGBaseSettings.get("infoIcon"));
        if (HGBaseTools.hasContent(imgLogo)) {
            htmlBody.append("<td align=right>" + imgLogo + "</td>");
        }
        htmlBody.append("</tr></table>" + aboutInfo);
        htmlBody.append(HGBaseAboutDlg.getHtmlForLinkImages(pane));
        htmlBody.append("</div></html>");
        HGBaseHTMLPage html = new HGBaseHTMLPage(htmlBody.toString());
        return html;
    }

    public static String getHtmlForLinkImages(HGBaseFrame pane) {
        StringBuffer htmlBody = new StringBuffer();
        Collection<String> linkIds = pane.getMenu().getLinkItems();
        if (!linkIds.isEmpty()) {
            htmlBody.append("<table width=\"100%\" cellspacing=\"10\"><tr>");
            for (String linkId : linkIds) {
                String imgLink = HGBaseAboutDlg.getHtmlForImagePath(HGBaseSettings.get(String.valueOf(linkId) + ".image"));
                String urlLink = HGBaseSettings.get(String.valueOf(linkId) + ".url");
                if (!HGBaseTools.hasContent(imgLink)) continue;
                htmlBody.append("<td>");
                if (HGBaseTools.hasContent(urlLink)) {
                    htmlBody.append("<a href=\"" + urlLink + "\">");
                }
                htmlBody.append(imgLink);
                if (HGBaseTools.hasContent(urlLink)) {
                    htmlBody.append("</a>");
                }
                htmlBody.append("</td>");
            }
            htmlBody.append("</tr></table>");
        }
        return htmlBody.toString();
    }

    public static String getHtmlForImagePath(String imagePath) {
        if (HGBaseTools.hasContent(imagePath)) {
            String urlPath;
            ImageIcon imgLogo = HGBaseGuiTools.loadImage(imagePath);
            int w = imgLogo != null ? imgLogo.getIconWidth() : 0;
            int h = imgLogo != null ? imgLogo.getIconHeight() : 0;
            String string = urlPath = imgLogo != null ? HGBaseAboutDlg.class.getResource(imagePath).toString() : null;
            if (imgLogo != null) {
                return "<img src=\"" + urlPath + "\" width=" + w + " height=" + h + " border=\"0\">";
            }
        }
        return "";
    }
}

