/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui;

import hgb.gui.HGBaseFrame;
import hgb.gui.HGBaseGuiTools;
import hgb.gui.HGBaseHTMLPage;
import hgb.lib.HGBaseLog;
import hgb.lib.HGBaseText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class HGBaseDialog
extends JOptionPane {
    private static final long serialVersionUID = 424781072L;
    private static JButton[] optButton = null;
    private static int lastPositionX = 0;
    private static int lastPositionY = 0;
    private static boolean resizeNext = false;
    private static JComponent focusComponent = null;

    private HGBaseDialog() {
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        if (parentComponent instanceof HGBaseFrame) {
            ((HGBaseFrame)parentComponent).setCursorDefault();
        }
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dlg = pane.createDialog(parentComponent, HGBaseDialog.getMessageIfAvailable(title));
        dlg.setResizable(resizeNext);
        HGBaseDialog.requestFocus(focusComponent);
        resizeNext = false;
        focusComponent = null;
        dlg.setVisible(true);
    }

    public static int showWarningDialog(Component parentComponent, Object message, String title) {
        if (parentComponent instanceof HGBaseFrame) {
            ((HGBaseFrame)parentComponent).setCursorDefault();
        }
        Object[] options = new String[]{HGBaseText.getText("dlg.yes", new String[0]), HGBaseText.getText("dlg.no", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
        JOptionPane pane = new JOptionPane(message, 2, -1, null, options, options[1]);
        return HGBaseDialog.handleThreeButtonDialog(parentComponent, title, (String[])options, pane);
    }

    private static int handleThreeButtonDialog(Component parentComponent, String title, String[] options, JOptionPane pane) {
        JDialog dlg = pane.createDialog(parentComponent, HGBaseDialog.getMessageIfAvailable(title));
        dlg.setResizable(resizeNext);
        HGBaseDialog.requestFocus(focusComponent);
        resizeNext = false;
        focusComponent = null;
        dlg.setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return 2;
        }
        if (options[0].equals(selectedValue)) {
            return 0;
        }
        if (options[1].equals(selectedValue)) {
            return 1;
        }
        if (options[2].equals(selectedValue)) {
            return 2;
        }
        return 2;
    }

    public static int showConfirmSaveDialog(Component parentComponent, Object message, String title, int initial) {
        if (parentComponent instanceof HGBaseFrame) {
            ((HGBaseFrame)parentComponent).setCursorDefault();
        }
        Object[] options = new String[]{HGBaseText.getText("dlg.save", new String[0]), HGBaseText.getText("dlg.notsave", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
        JOptionPane pane = new JOptionPane(message, 3, 1, null, options, options[initial]);
        return HGBaseDialog.handleThreeButtonDialog(parentComponent, title, (String[])options, pane);
    }

    public static int showConfirmSaveDialog(Component parentComponent, Object message, String title) {
        return HGBaseDialog.showConfirmSaveDialog(parentComponent, message, title, 0);
    }

    private static void getButtons(Component comp, List<JButton> al) {
        if (comp instanceof Container) {
            Container co = (Container)comp;
            int i = 0;
            while (i < co.getComponentCount()) {
                Component newComp = co.getComponent(i);
                if (newComp instanceof JButton) {
                    al.add((JButton)newComp);
                } else {
                    HGBaseDialog.getButtons(newComp, al);
                }
                ++i;
            }
        }
    }

    public static JButton getDialogButton(int index) {
        if (optButton != null && index >= 0 && index < optButton.length) {
            return optButton[index];
        }
        return null;
    }

    public static int showOptionDialog(Frame parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, int initialValue, int xPos, int yPos) {
        boolean[] disable = new boolean[options.length];
        int i = 0;
        while (i < disable.length) {
            disable[i] = false;
            ++i;
        }
        return HGBaseDialog.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, disable, xPos, yPos);
    }

    public static int showOptionDialog(Frame parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, int initialValue) {
        boolean[] disable = new boolean[options.length];
        int i = 0;
        while (i < disable.length) {
            disable[i] = false;
            ++i;
        }
        return HGBaseDialog.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, disable);
    }

    public static int showOptionDialog(Frame parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, int initialValue, boolean[] disable) {
        return HGBaseDialog.showOptionDialog(parentComponent, message, title, optionType, messageType, icon, options, initialValue, disable, 0, 0);
    }

    public static int showOptionDialog(Frame parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, int initialValue, boolean[] disable, int xPos, int yPos) {
        if (parentComponent instanceof HGBaseFrame) {
            ((HGBaseFrame)parentComponent).setCursorDefault();
        }
        if (initialValue < 0 || initialValue >= options.length) {
            initialValue = 0;
        }
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, options[initialValue]);
        JDialog dlg = pane.createDialog(parentComponent, HGBaseDialog.getMessageIfAvailable(title));
        ArrayList<JButton> al = new ArrayList<JButton>();
        HGBaseDialog.getButtons(pane, al);
        optButton = new JButton[options.length];
        int i = 0;
        while (i < options.length) {
            HGBaseDialog.optButton[i] = (JButton)al.get(al.size() - options.length + i);
            ++i;
        }
        i = 0;
        while (i < disable.length) {
            JButton b;
            if (disable[i] && (b = HGBaseDialog.getDialogButton(i)) != null) {
                b.setEnabled(false);
            }
            ++i;
        }
        dlg.setResizable(resizeNext);
        if (xPos != 0 && yPos != 0) {
            dlg.setLocation(xPos, yPos);
        }
        HGBaseDialog.requestFocus(focusComponent);
        dlg.setVisible(true);
        lastPositionX = (int)dlg.getLocation().getX();
        lastPositionY = (int)dlg.getLocation().getY();
        resizeNext = false;
        optButton = null;
        focusComponent = null;
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        int counter = 0;
        while (counter < options.length) {
            if (options[counter].equals(selectedValue)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    public static int getLastX() {
        return lastPositionX;
    }

    public static int getLastY() {
        return lastPositionY;
    }

    public static int showOkCancelDialog(Frame parentComponent, Object message, String title, boolean defaultCancel) {
        Object[] options = new String[]{HGBaseText.getText("dlg.ok", new String[0]), HGBaseText.getText("dlg.cancel", new String[0])};
        return HGBaseDialog.showOptionDialog(parentComponent, message, title, -1, -1, null, options, defaultCancel ? 1 : 0);
    }

    public static int showOkCancelDialog(Frame parentComponent, Object message, String title) {
        return HGBaseDialog.showOkCancelDialog(parentComponent, message, title, false);
    }

    public static int showOkDialog(Frame parentComponent, Object message, String title) {
        Object[] options = new String[]{HGBaseText.getText("dlg.ok", new String[0])};
        return HGBaseDialog.showOptionDialog(parentComponent, message, title, -1, -1, null, options, 0);
    }

    public static int showConfirmDialog(Frame parentComponent, Object message, String title) {
        return HGBaseDialog.showConfirmDialog(parentComponent, message, title, 3);
    }

    public static int showConfirmDialog(Frame parentComponent, Object message, String title, int messageType) {
        Object[] options;
        int ret;
        if (parentComponent instanceof HGBaseFrame) {
            ((HGBaseFrame)parentComponent).setCursorDefault();
        }
        if ((ret = HGBaseDialog.showOptionDialog(parentComponent, message, title, -1, messageType, null, options = new String[]{HGBaseText.getText("dlg.yes", new String[0]), HGBaseText.getText("dlg.no", new String[0])}, 1)) == 0) {
            return 0;
        }
        if (ret == 1) {
            return 1;
        }
        return 2;
    }

    public static int showSaveDialog(JFileChooser fc, String title, Frame parentComponent) {
        int result;
        block6: {
            block4: while (true) {
                if ((result = fc.showSaveDialog(parentComponent)) != 0) {
                    return result;
                }
                File file = fc.getSelectedFile();
                if (file == null || !file.exists()) break block6;
                String text = HGBaseText.getText("dlg.fileexists", file.getName());
                int r = HGBaseDialog.showWarningDialog(parentComponent, text, title);
                switch (r) {
                    case 0: {
                        return 0;
                    }
                    case 1: {
                        continue block4;
                    }
                }
                break;
            }
            return 1;
        }
        return result;
    }

    public static void printError(int code, JFrame panel) {
        HGBaseDialog.printError(String.valueOf(code), panel);
    }

    public static void printError(String code, JFrame panel) {
        HGBaseDialog.printError(code, null, panel);
    }

    public static void printError(String code, String[] placeHolder, JFrame panel) {
        HGBaseDialog.showMessageDialog(panel, HGBaseText.getText(code, placeHolder), HGBaseText.getText("dlg.error", new String[0]), 0);
    }

    public static void printError(Throwable exception, JFrame panel) {
        HGBaseDialog.printError("err.exception", new String[]{exception.getMessage()}, panel);
    }

    public static void printInfo(int code, JFrame panel) {
        HGBaseDialog.printInfo(String.valueOf(code), panel);
    }

    public static void printInfo(String code, JFrame panel) {
        HGBaseDialog.printInfo(code, null, panel);
    }

    public static void printInfo(String code, String[] placeHolder, JFrame panel) {
        HGBaseDialog.showMessageDialog(panel, HGBaseText.getText(code, placeHolder), HGBaseText.getText("dlg.info", new String[0]), 1);
    }

    public static void showHtmlDialog(HGBaseFrame frame, String url, String title, int width, int height) {
        HGBaseDialog.showHtmlDialog(frame, frame.getClass().getResource(url), title, width, height);
    }

    public static void showHtmlDialog(HGBaseFrame frame, URL url, String title, int width, int height) {
        try {
            HGBaseHTMLPage html = new HGBaseHTMLPage(url);
            html.setOpaque(true);
            JScrollPane pane = HGBaseGuiTools.createScrollPane(html, width, height, false);
            HGBaseDialog.setNextDialogResizeable();
            HGBaseDialog.showOkDialog(frame, pane, title);
        }
        catch (HeadlessException | IOException ex) {
            HGBaseLog.logError(ex.getMessage());
        }
    }

    public static void setNextDialogResizeable() {
        resizeNext = true;
    }

    public static String getMessageIfAvailable(String text) {
        return HGBaseText.existsText(text) ? HGBaseText.getText(text, new String[0]) : text;
    }

    public static void setFocusComponent(JComponent component) {
        focusComponent = component;
    }

    private static void requestFocus(JComponent component) {
        if (component != null) {
            component.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    final JComponent comp = event.getComponent();
                    final 1 listener = this;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Timer timer = new Timer(true);
                            timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    comp.requestFocusInWindow();
                                    comp.removeAncestorListener(listener);
                                }
                            }, 500L);
                        }
                    });
                }
            });
        }
    }
}

