/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.HGBaseItem;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseText;
import javax.swing.JCheckBox;

public class HGBaseConfigCheckBox
extends JCheckBox
implements HGBaseItem,
HGBaseConfigItem {
    private static final long serialVersionUID = 424781079L;
    private String itemId;
    private String itemOption;

    public HGBaseConfigCheckBox(String id, String option) {
        this(id, option, null);
    }

    public HGBaseConfigCheckBox(String id, String option, String defaultValue) {
        super(HGBaseText.getText(id, new String[0]));
        this.itemId = id;
        this.itemOption = option;
        this.setValue(HGBaseConfig.get(this.getOption(), defaultValue));
    }

    @Override
    public String getId() {
        return this.itemId;
    }

    @Override
    public String getOption() {
        return this.itemOption;
    }

    @Override
    public String getValue() {
        return this.isSelected() ? "1" : "0";
    }

    @Override
    public void setValue(String value) {
        this.setSelected("1".equals(value));
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }
}

