/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.HGBaseDialog;
import hgb.gui.HGBaseFrame;
import hgb.gui.HGBasePanel;
import hgb.gui.config.HGBaseConfigCheckBox;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import hgb.lib.HGBaseTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridLayout;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class HGBaseConfigDialog {
    private HGBaseFrame mainFrame;
    private String title;
    private HGBasePanel pnDialog;
    protected JLabel lbState;
    private JButton okButton;
    private JButton cancelButton;
    private String askToSaveOption;
    private HGBaseConfigCheckBox chkSave;
    private boolean displaying;
    private boolean showOnlyOk;

    public HGBaseConfigDialog(HGBaseFrame mainFrame, String title) {
        this(mainFrame, title, false);
    }

    public HGBaseConfigDialog(HGBaseFrame mainFrame, String title, boolean showOnlyOk) {
        this(mainFrame, title, null, showOnlyOk);
    }

    public HGBaseConfigDialog(HGBaseFrame mainFrame, String title, String askToSaveOption) {
        this(mainFrame, title, askToSaveOption, false);
    }

    public HGBaseConfigDialog(HGBaseFrame mainFrame, String title, String askToSaveOption, boolean showOnlyOk) {
        this.mainFrame = mainFrame;
        this.title = title;
        this.askToSaveOption = askToSaveOption;
        this.showOnlyOk = showOnlyOk;
        this.lbState = new JLabel();
        this.pnDialog = new HGBasePanel(new BorderLayout()){
            private static final long serialVersionUID = -8588833043312785133L;
            private boolean first;
            {
                this.first = true;
            }

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                this.testOnDisplaying();
            }

            @Override
            protected void paintChildren(Graphics g) {
                super.paintChildren(g);
                this.testOnDisplaying();
            }

            private void testOnDisplaying() {
                if (this.first) {
                    HGBaseConfigDialog.this.onDisplaying();
                    this.first = false;
                }
            }
        };
    }

    public boolean isAskToSave() {
        return HGBaseTools.hasContent(this.askToSaveOption);
    }

    protected HGBaseFrame getMainFrame() {
        return this.mainFrame;
    }

    public boolean show() {
        this.displaying = true;
        HGBasePanel pnMain = new HGBasePanel(new BorderLayout());
        pnMain.add((Component)this.pnDialog, "Center");
        JPanel pnBottom = new JPanel(new GridLayout(this.isAskToSave() ? 2 : 1, 1));
        pnBottom.add(this.lbState);
        if (this.isAskToSave()) {
            this.chkSave = new HGBaseConfigCheckBox("dlg.asktosave", this.askToSaveOption);
            if (!HGBaseConfig.existsKey(this.askToSaveOption)) {
                this.chkSave.setSelected(true);
            }
            pnBottom.add(this.chkSave);
        }
        pnMain.add((Component)pnBottom, "South");
        this.createComponents(this.pnDialog);
        int ret = 0;
        ret = this.showOnlyOk ? HGBaseDialog.showOkDialog(this.getMainFrame(), pnMain, this.title) : HGBaseDialog.showOkCancelDialog(this.getMainFrame(), pnMain, this.title);
        if (ret == 0) {
            this.okPressed();
            return true;
        }
        this.cancelPressed();
        return false;
    }

    protected void onDisplaying() {
        this.okButton = HGBaseDialog.getDialogButton(0);
        this.cancelButton = HGBaseDialog.getDialogButton(1);
    }

    protected void okPressed() {
        this.displaying = false;
        if (this.chkSave == null || this.chkSave.isSelected()) {
            this.saveConfigItems(this.pnDialog);
        }
        if (this.chkSave != null) {
            this.chkSave.saveOption();
        }
    }

    private void saveConfigItems(JComponent component) {
        int i = 0;
        while (i < component.getComponentCount()) {
            Component c = component.getComponent(i);
            if (c instanceof HGBaseConfigItem) {
                ((HGBaseConfigItem)((Object)c)).saveOption();
            } else if (c instanceof AbstractButton) {
                Object property = ((AbstractButton)c).getClientProperty("HGBaseConfigItem");
                if (property instanceof HGBaseConfigItem) {
                    ((HGBaseConfigItem)property).saveOption();
                }
            } else if (c instanceof JComponent) {
                this.saveConfigItems((JComponent)c);
            }
            ++i;
        }
    }

    protected void cancelPressed() {
        this.displaying = false;
    }

    protected JButton getOkButton() {
        return this.okButton;
    }

    protected JButton getCancelButton() {
        return this.cancelButton;
    }

    protected boolean isDisplaying() {
        return this.displaying;
    }

    protected abstract void createComponents(HGBasePanel var1);
}

