/*
 * Decompiled with CFR 0.152.
 */
package hgb.gui.config;

import hgb.gui.EditTextField;
import hgb.gui.config.HGBaseConfigItem;
import hgb.lib.HGBaseConfig;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.UIManager;

public class HGBaseConfigTextField
extends EditTextField
implements HGBaseConfigItem {
    private static final long serialVersionUID = 424781083L;
    private String itemId;
    private String itemOption;
    private boolean passwordField;
    private boolean drawCaret;

    public HGBaseConfigTextField(String option) {
        this(option, false);
    }

    public HGBaseConfigTextField(String id, String option) {
        this(id, option, false);
    }

    public HGBaseConfigTextField(String id, String option, String defaultValue) {
        this(id, option, false, defaultValue);
    }

    public HGBaseConfigTextField(String option, boolean passwordField) {
        this("", option, passwordField);
    }

    public HGBaseConfigTextField(String option, boolean passwordField, String defaultValue) {
        this("", option, passwordField, defaultValue);
    }

    public HGBaseConfigTextField(String id, String option, boolean passwordField) {
        this(id, option, passwordField, null);
    }

    public HGBaseConfigTextField(String id, String option, boolean passwordField, String defaultValue) {
        this.itemId = id;
        this.itemOption = option;
        this.passwordField = passwordField;
        this.setValue(HGBaseConfig.get(this.getOption(), defaultValue));
        if (passwordField) {
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent ev) {
                    HGBaseConfigTextField.this.drawCaret = true;
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    HGBaseConfigTextField.this.drawCaret = false;
                }
            });
        }
    }

    public String getId() {
        return this.itemId;
    }

    @Override
    public String getOption() {
        return this.itemOption;
    }

    @Override
    public String getValue() {
        return this.getText();
    }

    @Override
    public void setValue(String value) {
        this.setText(value);
    }

    @Override
    public void saveOption() {
        if (this.isEnabled()) {
            HGBaseConfig.set(this.getOption(), this.getValue());
        }
    }

    public boolean isPasswordField() {
        return this.passwordField;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isPasswordField()) {
            this.paintPasswordChars(g);
        } else {
            super.paintComponent(g);
        }
    }

    private void paintPasswordChars(Graphics g) {
        int charSize = 12;
        int h = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth() - 1, h - 1);
        int numChars = this.getText().length();
        g.setColor(this.getForeground());
        int i = 0;
        while (i < numChars) {
            g.fillOval(2 + i * charSize, h / 4, charSize - 2, charSize - 2);
            ++i;
        }
        if (this.drawCaret) {
            int endPos = this.getSelectionEnd();
            g.setColor(this.getCaretColor());
            g.drawLine(charSize * endPos, 1, charSize * endPos, h - 1);
        }
    }

    @Override
    public void copy() {
        if (this.isPasswordField()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.copy();
        }
    }

    @Override
    public void cut() {
        if (this.isPasswordField()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        } else {
            super.cut();
        }
    }
}

